/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.particles.effects;

import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.ParticleStatus;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistryEntry;

public abstract class ParticleEffect<A extends Details>
extends ForgeRegistryEntry<ParticleEffect<?>> {
    public static final NoDetails EMPTY_DETAILS = new NoDetails();
    private IFactory<A> factory;

    public ParticleEffect() {
    }

    public ParticleEffect(IFactory<A> factory) {
        this.factory = factory;
    }

    public void spawn(Entity entity, World world, double posX, double posY, double posZ, A details) {
        this.spawn(entity.field_70170_p, posX, posY, posZ, 0.0, 0.0, 0.0);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean canParticlesSpawn(World world) {
        ParticleStatus particles = Minecraft.func_71410_x().field_71474_y.field_74362_aa;
        return (particles != ParticleStatus.DECREASED || world.func_201674_k().nextInt(10) >= 2) && (particles != ParticleStatus.MINIMAL || world.func_201674_k().nextInt(10) >= 8);
    }

    public A createDetails() {
        if (this.factory != null) {
            return this.factory.create();
        }
        return (A)EMPTY_DETAILS;
    }

    @Deprecated
    public void spawn(World world, double posX, double posY, double posZ, double motionX, double motionY, double motionZ) {
    }

    public static interface IFactory<A extends Details> {
        public A create();
    }

    public static class NoDetails
    extends Details {
        @Override
        public void save(CompoundNBT nbt) {
        }

        @Override
        public void load(CompoundNBT nbt) {
        }
    }

    public static abstract class Details {
        public abstract void save(CompoundNBT var1);

        public abstract void load(CompoundNBT var1);
    }
}

