/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.particles.effects.suna;

import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.world.World;
import xyz.pixelatedw.mineminenomi.init.ModParticleTypes;
import xyz.pixelatedw.mineminenomi.particles.data.SimpleParticleData;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class SablesNewParticleEffect
extends ParticleEffect<Details> {
    public SablesNewParticleEffect() {
        super(Details::new);
    }

    @Override
    public void spawn(Entity entity, World world, double posX, double posY, double posZ, Details details) {
        int angle = 0;
        int maxHeight = (int)(details.size * 1.25f);
        double minRadius = details.size / 7.0f;
        double maxRadius = details.size * 3.0f;
        int lines = 6;
        double heightIncrease = 0.15;
        double radiusIncrement = maxRadius / (double)maxHeight / 4.0;
        for (int l = 0; l < lines; ++l) {
            for (double y = 0.0; y < (double)maxHeight; y += heightIncrease) {
                double radius = y * radiusIncrement;
                double v = (double)(360.0f / (float)lines * (float)l) + y * 25.0;
                double x = Math.cos(Math.toRadians(v - (double)angle)) * Math.max(radius, minRadius);
                double z = Math.sin(Math.toRadians(v - (double)angle)) * Math.max(radius, minRadius);
                float t = WyHelper.colorTolerance(0.1f);
                SimpleParticleData part = new SimpleParticleData((ParticleType)ModParticleTypes.SUNA2.get());
                part.setLife(100);
                part.setSize(2.5f * (details.size / 15.0f));
                part.setMotion(0.0, 0.1 + Math.abs(WyHelper.randomDouble() / 15.0), 0.0);
                part.setColor(1.0f - t, 1.0f - t, 1.0f - t);
                entity.field_70170_p.func_195590_a((IParticleData)part, true, posX + x, posY + y, posZ + z, 0.0, 0.0, 0.0);
            }
        }
        angle += 2;
    }

    public static class Details
    extends ParticleEffect.Details {
        private float size;

        @Override
        public void save(CompoundNBT nbt) {
            nbt.func_74776_a("size", this.size);
        }

        @Override
        public void load(CompoundNBT nbt) {
            this.size = nbt.func_74760_g("size");
        }

        public float getSize() {
            return this.size;
        }

        public void setSize(float size) {
            this.size = size;
        }
    }
}

