/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.particles.effects.suna;

import net.minecraft.entity.Entity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.world.World;
import xyz.pixelatedw.mineminenomi.init.ModParticleTypes;
import xyz.pixelatedw.mineminenomi.particles.data.SimpleParticleData;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class SablesParticleEffect
extends ParticleEffect<ParticleEffect.NoDetails> {
    private float size = 1.0f;

    public SablesParticleEffect() {
        this.size = 1.0f;
    }

    public SablesParticleEffect(float size) {
        this.size = size;
    }

    @Override
    public void spawn(Entity entity, World world, double posX, double posY, double posZ, ParticleEffect.NoDetails details) {
        int angle = 0;
        int maxHeight = 35 + (int)(2.0f * this.size);
        double minRadius = 1.0f * this.size;
        double maxRadius = 20.0f * this.size;
        int lines = 12;
        double heightIncrease = 0.25;
        double radiusIncrement = maxRadius / (double)maxHeight * (double)(1.0f - this.size / 2.0f);
        for (int l = 0; l < lines; ++l) {
            for (double y = 0.0; y < (double)maxHeight; y += heightIncrease) {
                double radius = y * radiusIncrement;
                double v = (double)(360.0f / (float)lines * (float)l) + y * 25.0;
                double x = Math.cos(Math.toRadians(v - (double)angle)) * Math.max(radius, minRadius);
                double z = Math.sin(Math.toRadians(v - (double)angle)) * Math.max(radius, minRadius);
                SimpleParticleData data = new SimpleParticleData((ParticleType)ModParticleTypes.SUNA2.get());
                data.setLife(70);
                data.setSize(2.5f * this.size);
                data.setMotion(entity.func_213322_ci().field_72450_a, entity.func_213322_ci().field_72448_b + 0.1 - Math.abs(WyHelper.randomDouble() / 5.0), entity.func_213322_ci().field_72449_c);
                entity.field_70170_p.func_195590_a((IParticleData)data, true, posX + x, posY + y, posZ + z, 0.0, 0.0, 0.0);
            }
        }
        angle += 2;
    }
}

