/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.quests.brawler;

import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import xyz.pixelatedw.mineminenomi.abilities.brawler.HakaiHoAbility;
import xyz.pixelatedw.mineminenomi.abilities.brawler.JishinHoAbility;
import xyz.pixelatedw.mineminenomi.abilities.brawler.KingPunchAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityUnlock;
import xyz.pixelatedw.mineminenomi.api.quests.Quest;
import xyz.pixelatedw.mineminenomi.api.quests.QuestId;
import xyz.pixelatedw.mineminenomi.api.quests.objectives.Objective;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.init.ModQuests;
import xyz.pixelatedw.mineminenomi.quests.objectives.KillEntityObjective;
import xyz.pixelatedw.mineminenomi.quests.objectives.ReachDorikiObjective;
import xyz.pixelatedw.mineminenomi.quests.objectives.SharedKillChecks;
import xyz.pixelatedw.mineminenomi.quests.objectives.TimedKillEntityObjective;

public class BrawlerTrial06Quest
extends Quest {
    public static final QuestId INSTANCE = new QuestId.Builder("Trial: King Punch", BrawlerTrial06Quest::new).addRequirements(ModQuests.BRAWLER_TRIAL_04, ModQuests.BRAWLER_TRIAL_05).build();
    private Objective objective01 = new ReachDorikiObjective("Reach %s doriki", 7000);
    private Objective objective02 = new KillEntityObjective("Kill %s enemies using Hakai Ho", 10, SharedKillChecks.checkAbilitySource(HakaiHoAbility.INSTANCE)).addRequirement(this.objective01);
    private Objective objective03 = new TimedKillEntityObjective("Kill %s enemies using Jishin Ho in %s seconds or less", 5, 5, SharedKillChecks.checkAbilitySource(JishinHoAbility.INSTANCE)).addRequirement(this.objective01);

    public BrawlerTrial06Quest(QuestId id) {
        super(id);
        this.addObjectives(this.objective01, this.objective02, this.objective03);
        this.onCompleteEvent = this::giveReward;
    }

    public boolean giveReward(PlayerEntity player) {
        IAbilityData props = AbilityDataCapability.get((LivingEntity)player);
        props.addUnlockedAbility(KingPunchAbility.INSTANCE, AbilityUnlock.PROGRESSION);
        return true;
    }
}

