/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.quests.objectives;

import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.text.TranslationTextComponent;
import xyz.pixelatedw.mineminenomi.quests.objectives.HitEntityObjective;

public class TimedHitEntityObjective
extends HitEntityObjective {
    private long lastHit = 0L;
    private int seconds = 0;

    public TimedHitEntityObjective(String title, int count, int seconds) {
        super(title, count, (HitEntityObjective.ICheckHit)null);
        this.seconds = seconds * 20;
    }

    public TimedHitEntityObjective(String title, int count, int seconds, HitEntityObjective.ICheckHit check) {
        super(title, count, check);
        this.seconds = seconds * 20;
    }

    @Override
    public boolean checkHit(PlayerEntity player, LivingEntity target, DamageSource source, float amount) {
        long hitTime;
        if (this.lastHit == 0L) {
            this.lastHit = player.field_70170_p.func_82737_E();
        }
        if ((hitTime = player.field_70170_p.func_82737_E()) - (long)this.seconds <= this.lastHit) {
            this.lastHit = hitTime;
            return super.checkHit(player, target, source, amount);
        }
        this.setProgress(player, 0.0, false);
        this.lastHit = 0L;
        return true;
    }

    @Override
    public String getLocalizedTitle() {
        String objectiveKey = new TranslationTextComponent(String.format("quest.objective.mineminenomi.%s", this.getId())).func_150268_i();
        return new TranslationTextComponent(objectiveKey, new Object[]{(int)this.getMaxProgress(), this.seconds / 20}).getString();
    }
}

