/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.quests.objectives;

import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.text.TranslationTextComponent;
import xyz.pixelatedw.mineminenomi.quests.objectives.KillEntityObjective;

public class TimedKillEntityObjective
extends KillEntityObjective {
    private long firstHit = 0L;
    private int ticks = 0;

    public TimedKillEntityObjective(String title, int count, int seconds) {
        super(title, count, null);
        this.ticks = seconds * 20;
    }

    public TimedKillEntityObjective(String title, int count, int seconds, KillEntityObjective.ICheckKill check) {
        super(title, count, check);
        this.ticks = seconds * 20;
    }

    @Override
    public boolean checkKill(PlayerEntity player, LivingEntity target, DamageSource source) {
        long hitTime = player.field_70170_p.func_82737_E();
        if (hitTime > this.firstHit + (long)this.ticks) {
            this.setProgress(player, 0.0, false);
            this.firstHit = 0L;
        }
        if (this.firstHit == 0L) {
            this.firstHit = player.field_70170_p.func_82737_E();
        }
        if (hitTime - (long)this.ticks <= this.firstHit) {
            return super.checkKill(player, target, source);
        }
        return false;
    }

    @Override
    public String getLocalizedTitle() {
        String objectiveKey = new TranslationTextComponent(String.format("quest.objective.mineminenomi.%s", this.getId())).func_150268_i();
        return new TranslationTextComponent(objectiveKey, new Object[]{(int)this.getMaxProgress(), this.ticks / 20}).getString();
    }
}

