/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.quests.sniper;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import xyz.pixelatedw.mineminenomi.abilities.sniper.SakuretsuSabotenBoshiAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityUnlock;
import xyz.pixelatedw.mineminenomi.api.helpers.ItemsHelper;
import xyz.pixelatedw.mineminenomi.api.quests.Quest;
import xyz.pixelatedw.mineminenomi.api.quests.QuestId;
import xyz.pixelatedw.mineminenomi.api.quests.objectives.Objective;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.entities.mobs.quest.objectives.SniperTargetEntity;
import xyz.pixelatedw.mineminenomi.init.ModEntities;
import xyz.pixelatedw.mineminenomi.init.ModQuests;
import xyz.pixelatedw.mineminenomi.packets.server.quest.SDespawnQuestObjectivePacket;
import xyz.pixelatedw.mineminenomi.quests.objectives.KillEntityObjective;
import xyz.pixelatedw.mineminenomi.quests.objectives.ObtainItemObjective;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.WyNetwork;

public class SniperTrial04Quest
extends Quest {
    public static final QuestId INSTANCE = new QuestId.Builder("Trial: Sakuretsu Saboten Boshi", SniperTrial04Quest::new).addRequirements(ModQuests.SNIPER_TRIAL_01, ModQuests.SNIPER_TRIAL_02).build();
    private static final Predicate<ItemStack> ITEM_WITH_PUNCH_2 = itemStack -> ItemsHelper.isBow(itemStack) && EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185310_v, (ItemStack)itemStack) > 1;
    private static final KillEntityObjective.ICheckKill TARGET_CHECK = (player, target, source) -> target.func_200600_R() == ModEntities.SNIPER_TARGET.get();
    private Objective objective01 = new ObtainItemObjective("Obtain a bow with Punch II", 1, ITEM_WITH_PUNCH_2);
    private Objective objective02 = new ObtainItemObjective<Object>("Collect %s cacti", 50, () -> Items.field_221774_cw).addRequirement(this.objective01);
    private Objective objective03 = new KillEntityObjective("Hit all %s targets before they touch the ground", 10, TARGET_CHECK).addRequirement(this.objective02);
    private List<SniperTargetEntity> targets = new ArrayList<SniperTargetEntity>();

    public SniperTrial04Quest(QuestId id) {
        super(id);
        this.objective03.setHasEvent(true);
        this.objective03.onStartEvent = this::spawnTargets;
        this.objective03.onRestartEvent = this::respawnTargets;
        this.addObjectives(this.objective01, this.objective02, this.objective03);
        this.onCompleteEvent = this::giveReward;
    }

    private void spawnTargets(PlayerEntity player) {
        for (int i = 0; i < 10; ++i) {
            SniperTargetEntity target = new SniperTargetEntity(player.field_70170_p);
            double posX = player.func_226277_ct_() + WyHelper.randomWithRange(-10, 10);
            double posY = player.func_226278_cu_() + 30.0;
            double posZ = player.func_226281_cx_() + WyHelper.randomWithRange(-10, 10);
            target.func_70012_b(posX, posY, posZ, 0.0f, 0.0f);
            player.field_70170_p.func_217376_c((Entity)target);
            this.targets.add(target);
            if (!target.func_70089_S()) continue;
            WyNetwork.sendToAll(new SDespawnQuestObjectivePacket(player.func_110124_au(), target.func_145782_y()));
        }
    }

    private boolean respawnTargets(PlayerEntity player) {
        if (this.targets.size() <= 0) {
            return true;
        }
        for (SniperTargetEntity target : this.targets) {
            target.func_70106_y();
        }
        this.targets.clear();
        this.objective03.setProgress(player, 0.0, true);
        return true;
    }

    private boolean giveReward(PlayerEntity player) {
        if (!this.removeQuestItem(player, Items.field_221774_cw, 50)) {
            return false;
        }
        IAbilityData props = AbilityDataCapability.get((LivingEntity)player);
        props.addUnlockedAbility(SakuretsuSabotenBoshiAbility.INSTANCE, AbilityUnlock.PROGRESSION);
        return true;
    }
}

