/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.renderers.abilities;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import xyz.pixelatedw.mineminenomi.api.morph.MorphInfo;
import xyz.pixelatedw.mineminenomi.data.entity.devilfruit.DevilFruitCapability;
import xyz.pixelatedw.mineminenomi.data.entity.devilfruit.IDevilFruit;
import xyz.pixelatedw.mineminenomi.entities.PhysicalBodyEntity;
import xyz.pixelatedw.mineminenomi.init.ModAbilities;
import xyz.pixelatedw.mineminenomi.init.ModMorphs;
import xyz.pixelatedw.mineminenomi.models.abilities.PhysicalBodyModel;

@OnlyIn(value=Dist.CLIENT)
public class PhysicalBodyRenderer
extends EntityRenderer<PhysicalBodyEntity> {
    private PhysicalBodyModel model = new PhysicalBodyModel();

    public PhysicalBodyRenderer(EntityRendererManager renderManager) {
        super(renderManager);
    }

    public void render(PhysicalBodyEntity entity, float entityYaw, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer buffer, int packedLight) {
        boolean isSkeleton = false;
        if (entity.getOwner() != null) {
            IDevilFruit devilFruitProps = DevilFruitCapability.get((LivingEntity)entity.getOwner());
            isSkeleton = devilFruitProps.hasDevilFruit(ModAbilities.YOMI_YOMI_NO_MI) && ((MorphInfo)ModMorphs.YOMI_SKELETON.get()).isActive((LivingEntity)entity.getOwner());
        }
        matrixStack.func_227860_a_();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        matrixStack.func_227861_a_(0.0, 1.5, 0.0);
        matrixStack.func_227863_a_(new Quaternion(Vector3f.field_229183_f_, 180.0f, true));
        matrixStack.func_227863_a_(new Quaternion(Vector3f.field_229181_d_, entity.field_70125_A + 180.0f, true));
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        if (entity.field_70737_aN > 0) {
            matrixStack.func_227860_a_();
            RenderSystem.color3f((float)1.0f, (float)0.0f, (float)0.0f);
            matrixStack.func_227865_b_();
        }
        ResourceLocation res = this.getTextureLocation(entity);
        if (isSkeleton) {
            res = new ResourceLocation("mineminenomi", "textures/models/zoanmorph/yomi_skeleton.png");
            Minecraft.func_71410_x().func_110434_K().func_110577_a(res);
        } else {
            res = this.getTextureLocation(entity);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(res);
        }
        IVertexBuilder ivertexbuilder = buffer.getBuffer(this.model.func_228282_a_(res));
        this.model.func_225598_a_(matrixStack, ivertexbuilder, packedLight, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
        matrixStack.func_227865_b_();
    }

    public ResourceLocation getTextureLocation(PhysicalBodyEntity entity) {
        PlayerEntity player = entity.getOwner();
        if (player != null) {
            return ((AbstractClientPlayerEntity)player).func_110306_p();
        }
        UUID uuid = entity.getOwnerUUID();
        if (uuid != null) {
            return DefaultPlayerSkin.func_177334_a((UUID)uuid);
        }
        return DefaultPlayerSkin.func_177335_a();
    }

    public static class Factory
    implements IRenderFactory<PhysicalBodyEntity> {
        public EntityRenderer<? super PhysicalBodyEntity> createRenderFor(EntityRendererManager manager) {
            return new PhysicalBodyRenderer(manager);
        }
    }
}

