/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.renderers.abilities;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.awt.Color;
import java.lang.reflect.InvocationTargetException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import xyz.pixelatedw.mineminenomi.api.helpers.HakiHelper;
import xyz.pixelatedw.mineminenomi.entities.projectiles.AbilityProjectileEntity;
import xyz.pixelatedw.mineminenomi.entities.projectiles.doku.VenomRoadProjectile;
import xyz.pixelatedw.mineminenomi.init.ModRenderTypes;
import xyz.pixelatedw.mineminenomi.models.abilities.EntityArmModel;
import xyz.pixelatedw.mineminenomi.renderers.abilities.AbilityProjectileRenderer;

@OnlyIn(value=Dist.CLIENT)
public class StretchingProjectileRenderer<T extends AbilityProjectileEntity, M extends EntityModel<T>>
extends AbilityProjectileRenderer<T, M> {
    private M stretchModel;
    private float stretchScaleX = 1.0f;
    private float stretchScaleY = 1.0f;
    private float stretchScaleZ = 1.0f;

    public StretchingProjectileRenderer(EntityRendererManager renderManager, M model, M stretchModel) {
        super(renderManager, model, null);
        this.stretchModel = stretchModel;
    }

    public void setStretchScale(double scaleX, double scaleY, double scaleZ) {
        this.stretchScaleX = (float)scaleX;
        this.stretchScaleY = (float)scaleY;
        this.stretchScaleZ = (float)scaleZ;
    }

    @Override
    public void render(T entity, float entityYaw, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer buffer, int packedLight) {
        if (((AbilityProjectileEntity)((Object)entity)).field_70173_aa < 2) {
            return;
        }
        if (((AbilityProjectileEntity)((Object)entity)).getThrower() == null || !((AbilityProjectileEntity)((Object)entity)).getThrower().func_70089_S()) {
            ((AbilityProjectileEntity)((Object)entity)).func_70106_y();
            return;
        }
        if (Minecraft.func_71410_x().func_175598_ae().func_178634_b() && !entity.func_82150_aj() && !Minecraft.func_71410_x().func_189648_am()) {
            this.renderDebugBox(matrixStack, buffer.getBuffer(RenderType.func_228659_m_()), entity);
        }
        Vector3d originPos = ((AbilityProjectileEntity)((Object)entity)).getThrower().func_213303_ch();
        if (entity instanceof VenomRoadProjectile) {
            originPos = ((VenomRoadProjectile)((Object)entity)).getStartPos();
        }
        Vector3d entityPos = new Vector3d(MathHelper.func_219803_d((double)partialTicks, (double)((AbilityProjectileEntity)((Object)entity)).field_70169_q, (double)entity.func_226277_ct_()), MathHelper.func_219803_d((double)partialTicks, (double)((AbilityProjectileEntity)((Object)entity)).field_70167_r, (double)entity.func_226278_cu_()), MathHelper.func_219803_d((double)partialTicks, (double)((AbilityProjectileEntity)((Object)entity)).field_70166_s, (double)entity.func_226281_cx_()));
        Vector3d stretchVec = entityPos.func_178788_d(originPos);
        if (this.stretchModel != null) {
            boolean haoshokuInfusionCheck;
            matrixStack.func_227860_a_();
            matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(((AbilityProjectileEntity)((Object)entity)).field_70126_B + (((AbilityProjectileEntity)((Object)entity)).field_70177_z - ((AbilityProjectileEntity)((Object)entity)).field_70126_B) * partialTicks - 180.0f));
            matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(((AbilityProjectileEntity)((Object)entity)).field_70127_C + (((AbilityProjectileEntity)((Object)entity)).field_70125_A - ((AbilityProjectileEntity)((Object)entity)).field_70127_C) * partialTicks));
            matrixStack.func_227863_a_(new Quaternion(Vector3f.field_229183_f_, 180.0f, true));
            float modelLength = this.stretchScaleZ / 16.0f;
            float modelOffset = 0.25f;
            float stretchLength = (float)stretchVec.func_72433_c();
            matrixStack.func_227861_a_(this.translateX, this.translateY, (double)(-modelOffset) - this.translateZ);
            matrixStack.func_227862_a_(this.stretchScaleX, this.stretchScaleY, (stretchLength - 2.0f * modelOffset) / modelLength);
            matrixStack.func_227861_a_(this.translateX, this.translateY, (double)modelOffset + this.translateZ);
            ResourceLocation finalTexture = super.getTextureLocation((AbilityProjectileEntity)((Object)entity));
            RenderType type = finalTexture == null ? (this.isGlowing() ? ModRenderTypes.getEnergyRenderType() : ModRenderTypes.TRANSPARENT_COLOR) : RenderType.func_228644_e_((ResourceLocation)finalTexture);
            boolean isSlim = false;
            if (((AbilityProjectileEntity)((Object)entity)).getThrower() instanceof ClientPlayerEntity) {
                isSlim = ((AbstractClientPlayerEntity)((AbilityProjectileEntity)((Object)entity)).getThrower()).func_175154_l().equals("slim");
            }
            if (isSlim && this.stretchModel instanceof EntityArmModel) {
                try {
                    this.stretchModel = (EntityModel)this.stretchModel.getClass().getConstructor(Boolean.TYPE).newInstance(isSlim);
                }
                catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
            Color colour = this.getColor();
            boolean bl = haoshokuInfusionCheck = ((AbilityProjectileEntity)((Object)entity)).isAffectedByHaki() && HakiHelper.isProjectileHaoshokuInfused(entity);
            if (haoshokuInfusionCheck && !this.isGlowing() && ((AbilityProjectileEntity)((Object)entity)).getThrower() != null) {
                colour = new Color(HakiHelper.getHaoshokuColour(((AbilityProjectileEntity)((Object)entity)).getThrower()));
            }
            IVertexBuilder ivertexbuilder = buffer.getBuffer(type);
            this.stretchModel.func_225598_a_(matrixStack, ivertexbuilder, packedLight, OverlayTexture.field_229196_a_, (float)colour.getRed() / 255.0f, (float)colour.getGreen() / 255.0f, (float)colour.getBlue() / 255.0f, (float)colour.getAlpha() / 255.0f);
            super.renderHakiOverlay(this.stretchModel, entity, matrixStack, buffer, packedLight);
            matrixStack.func_227865_b_();
        }
        super.render(entity, entityYaw, partialTicks, matrixStack, buffer, packedLight);
    }

    private void renderDebugBox(MatrixStack matrixStack, IVertexBuilder vertexBuilder, T entity) {
        AxisAlignedBB axisalignedbb = new AxisAlignedBB(-((AbilityProjectileEntity)((Object)entity)).getBlockCollisionBox().func_216364_b() / 2.0, -((AbilityProjectileEntity)((Object)entity)).getBlockCollisionBox().func_216360_c() / 2.0, -((AbilityProjectileEntity)((Object)entity)).getBlockCollisionBox().func_216362_d() / 2.0, ((AbilityProjectileEntity)((Object)entity)).getBlockCollisionBox().func_216364_b() / 2.0, ((AbilityProjectileEntity)((Object)entity)).getBlockCollisionBox().func_216360_c() / 2.0, ((AbilityProjectileEntity)((Object)entity)).getBlockCollisionBox().func_216362_d() / 2.0);
        WorldRenderer.func_228430_a_((MatrixStack)matrixStack, (IVertexBuilder)vertexBuilder, (AxisAlignedBB)axisalignedbb, (float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
    }

    public static class Factory
    extends AbilityProjectileRenderer.Factory {
        private EntityModel stretchModel;
        protected double stretchScaleX = 1.0;
        protected double stretchScaleY = 1.0;
        protected double stretchScaleZ = 8.0;

        public Factory(EntityModel stretchModel) {
            super(null);
            this.stretchModel = stretchModel;
        }

        public Factory(EntityModel tipModel, EntityModel stretchModel) {
            super(tipModel);
            this.stretchModel = stretchModel;
        }

        public Factory setStretchScale(double scaleX, double scaleY) {
            return this.setStretchScale(scaleX, scaleY, 8.0);
        }

        public Factory setStretchScale(double scaleX, double scaleY, double scaleZ) {
            this.stretchScaleX = scaleX;
            this.stretchScaleY = scaleY;
            this.stretchScaleZ = scaleZ;
            return this;
        }

        @Override
        public EntityRenderer<? super AbilityProjectileEntity> createRenderFor(EntityRendererManager manager) {
            StretchingProjectileRenderer renderer = new StretchingProjectileRenderer(manager, this.model, this.stretchModel);
            renderer.setStretchScale(this.stretchScaleX, this.stretchScaleY, this.stretchScaleZ);
            renderer.setTexture(this.texture);
            renderer.setPlayerTexture(this.usePlayerTexture);
            renderer.setGlowing(this.isGlowing);
            renderer.setScale(this.scaleX, this.scaleY, this.scaleZ);
            renderer.setTranslate(this.translateX, this.translateY, this.translateZ);
            renderer.setColor(this.colour);
            return renderer;
        }
    }
}

