/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.renderers.abilities.doku;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.awt.Color;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import xyz.pixelatedw.mineminenomi.entities.projectiles.doku.ChloroBallProjectile;
import xyz.pixelatedw.mineminenomi.models.abilities.SphereModel;
import xyz.pixelatedw.mineminenomi.renderers.abilities.AbilityProjectileRenderer;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class ChloroBallRenderer
extends AbilityProjectileRenderer<ChloroBallProjectile, SphereModel<ChloroBallProjectile>> {
    private static final Color NORMAL_COLOR = WyHelper.hexToRGB("#A020F0");
    private static final Color DEMON_COLOR = WyHelper.hexToRGB("#5A0000");
    private static final Vector3f NORMAL_SCALE = new Vector3f(2.0f, 2.0f, 2.0f);
    private static final Vector3f DEMON_SCALE = new Vector3f(4.0f, 4.0f, 4.0f);

    public ChloroBallRenderer(EntityRendererManager renderManager, SphereModel model, Set<AbilityProjectileRenderer.Effect> effects) {
        super(renderManager, model, effects);
        this.setNormalDetails();
    }

    @Override
    public void render(ChloroBallProjectile entity, float entityYaw, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer buffer, int packedLight) {
        super.render(entity, entityYaw, partialTicks, matrixStack, buffer, packedLight);
        if (entity.isDemonMode()) {
            this.setDemonDetails();
        } else {
            this.setNormalDetails();
        }
    }

    private void setDemonDetails() {
        this.setColor(DEMON_COLOR);
        this.setScale(DEMON_SCALE);
    }

    private void setNormalDetails() {
        this.setColor(NORMAL_COLOR);
        this.setScale(NORMAL_SCALE);
    }

    public static class Factory
    implements IRenderFactory<ChloroBallProjectile> {
        public ChloroBallRenderer createRenderFor(EntityRendererManager manager) {
            return new ChloroBallRenderer(manager, new SphereModel(), new HashSet<AbilityProjectileRenderer.Effect>());
        }
    }
}

