/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.renderers.entities;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.function.Predicate;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.layers.HeadLayer;
import net.minecraft.client.renderer.entity.layers.HeldItemLayer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import xyz.pixelatedw.mineminenomi.entities.mobs.animals.AbstractDugongEntity;
import xyz.pixelatedw.mineminenomi.init.ModRenderTypes;
import xyz.pixelatedw.mineminenomi.models.entities.mobs.animals.DugongModel;
import xyz.pixelatedw.mineminenomi.renderers.layers.AuraLayer;
import xyz.pixelatedw.mineminenomi.renderers.layers.BodyCoatingLayer;
import xyz.pixelatedw.mineminenomi.renderers.layers.EyesLayer;
import xyz.pixelatedw.mineminenomi.renderers.layers.PotionLayer;

public class DugongRenderer<T extends AbstractDugongEntity, M extends DugongModel<T>>
extends MobRenderer<T, M> {
    private final ResourceLocation baseTexture;
    private static final RenderType ANGRY_EYES = ModRenderTypes.getEyesLayerRenderType(new ResourceLocation("mineminenomi", "textures/models/kung_fu_dugong_angry_eyes.png"));
    private static final RenderType SLEEPING_EYES = ModRenderTypes.getEyesLayerRenderType(new ResourceLocation("mineminenomi", "textures/models/kung_fu_dugong_sleeping_eyes.png"));
    private static final Predicate<AbstractDugongEntity> IS_ANGRY = AbstractDugongEntity::isEnraged;
    private static final Predicate<AbstractDugongEntity> IS_RESTING = AbstractDugongEntity::isResting;

    public DugongRenderer(EntityRendererManager manager, ResourceLocation texture) {
        super(manager, new DugongModel(), 0.4f);
        this.baseTexture = texture;
        this.func_177094_a(new BodyCoatingLayer((IEntityRenderer)this));
        this.func_177094_a((LayerRenderer)new HeadLayer((IEntityRenderer)this, 1.0f, 1.0f, 1.0f));
        this.func_177094_a((LayerRenderer)new HeldItemLayer((IEntityRenderer)this));
        this.func_177094_a(new PotionLayer((IEntityRenderer)this));
        this.func_177094_a(new AuraLayer(this));
        this.func_177094_a(new EyesLayer((IEntityRenderer)this, ANGRY_EYES, IS_ANGRY));
        this.func_177094_a(new EyesLayer((IEntityRenderer)this, SLEEPING_EYES, IS_RESTING));
    }

    public void render(T entity, float entityYaw, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer buffer, int packedLight) {
        super.func_225623_a_(entity, entityYaw, partialTicks, matrixStack, buffer, packedLight);
    }

    protected void setupRotations(T entity, MatrixStack matrixStack, float ageInTicks, float rotationYaw, float partialTicks) {
        super.func_225621_a_(entity, matrixStack, ageInTicks, rotationYaw, partialTicks);
        if (((AbstractDugongEntity)entity).isTraining()) {
            switch (((AbstractDugongEntity)entity).getTrainingMode()) {
                case PUSHUPS: {
                    matrixStack.func_227861_a_(0.0, 0.25, 0.5);
                    matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(-75.0f));
                    break;
                }
                case SHADOW_BOXING: {
                    break;
                }
            }
        }
        if (((AbstractDugongEntity)entity).isResting()) {
            matrixStack.func_227861_a_(0.0, 0.25, 0.5);
            matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(-90.0f));
        }
    }

    public ResourceLocation getTextureLocation(T pEntity) {
        return this.baseTexture;
    }

    public static class Factory
    implements IRenderFactory {
        private final ResourceLocation texture;

        public Factory(ResourceLocation texture) {
            this.texture = texture;
        }

        public EntityRenderer createRenderFor(EntityRendererManager manager) {
            return new DugongRenderer(manager, this.texture);
        }
    }
}

