/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.renderers.entities;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.awt.Color;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.culling.ClippingHelper;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.settings.PointOfView;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import xyz.pixelatedw.mineminenomi.entities.LightningDischargeEntity;
import xyz.pixelatedw.mineminenomi.entities.projectiles.goro.LightningEntity;
import xyz.pixelatedw.mineminenomi.init.ModRenderTypes;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class LightningEntityRenderer
extends EntityRenderer<LightningEntity> {
    public LightningEntityRenderer(EntityRendererManager manager) {
        super(manager);
    }

    public void render(LightningEntity entity, float entityYaw, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer bufferIn, int packedLightIn) {
        matrixStack.func_227860_a_();
        LightningEntityRenderer.renderLightning(entity, partialTicks, matrixStack, bufferIn, packedLightIn);
        matrixStack.func_227865_b_();
    }

    public static void renderLightning(LightningEntity entity, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer bufferIn, int packedLightIn) {
        if (entity.field_70173_aa < 1 || entity.getSegments() < 0) {
            return;
        }
        Random random = new Random(entity.seed);
        int angle = entity.getAngle();
        int segments = entity.getSegments();
        int branches = entity.getBranches();
        float lengthFactor = Math.min(((float)entity.field_70173_aa + partialTicks) / 2.0f, 1.0f);
        float length = entity.getLength() * lengthFactor;
        float size = entity.getSize();
        float maxDistance = entity.getLength() / (float)segments;
        Color rgb = new Color(entity.getColor());
        float[] arr = new float[segments];
        int targetNumber = (int)((float)segments * lengthFactor);
        int renderTime = (entity.getMaxLife() + entity.getMaxLife() - entity.getLife()) / 2;
        float defAlpha = (float)entity.getAlpha() / 255.0f;
        float alpha = entity.field_70173_aa < renderTime ? defAlpha : Math.max(defAlpha * (1.0f - ((float)(entity.field_70173_aa - renderTime) + partialTicks) / (float)renderTime), 0.0f);
        for (int segment = 0; segment < segments; ++segment) {
            arr[segment] = segment == targetNumber ? length - maxDistance * (float)segment : maxDistance;
        }
        float[] offsetsY = new float[segments];
        float[] offsetsX = new float[segments];
        IVertexBuilder vertex = bufferIn.getBuffer(entity.getEnergyEffect() ? ModRenderTypes.ENERGY : ModRenderTypes.TRANSPARENT_COLOR2);
        Matrix4f matrix4f = matrixStack.func_227866_c_().func_227870_a_();
        matrixStack.func_227863_a_(Vector3f.field_229180_c_.func_229187_a_(entity.field_70177_z));
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(entity.field_70125_A));
        matrixStack.func_227861_a_(0.0, 0.0, 0.1);
        for (int i = 0; i < branches; ++i) {
            int j;
            float lastOffsetY = 0.0f;
            float lastOffsetX = 0.0f;
            for (j = 0; j < segments; ++j) {
                offsetsY[j] = lastOffsetY;
                offsetsX[j] = lastOffsetX;
                lastOffsetY = (float)((double)lastOffsetY + Math.sin(Math.toRadians((float)random.nextInt(angle) - (float)angle / 2.0f)));
                lastOffsetX = (float)((double)lastOffsetX + Math.sin(Math.toRadians((float)random.nextInt(angle) - (float)angle / 2.0f)));
            }
            for (j = 0; j < segments; ++j) {
                float y = offsetsY[j];
                float x = offsetsX[j];
                for (int depth = 1; depth < 4; ++depth) {
                    float endX;
                    float depthY = size / 2.0f + (float)depth * size;
                    float depthZ = size / 2.0f + (float)depth * size;
                    float endY = j == segments - 1 ? y : offsetsY[j + 1];
                    float f = endX = j == segments - 1 ? x : offsetsX[j + 1];
                    if (j > targetNumber) continue;
                    LightningEntityRenderer.drawQuad(matrix4f, vertex, y, x, j, endY, endX, rgb.getRed(), rgb.getGreen(), rgb.getBlue(), alpha, depthY, depthZ, false, false, true, false, maxDistance, arr[j], packedLightIn);
                    LightningEntityRenderer.drawQuad(matrix4f, vertex, y, x, j, endY, endX, rgb.getRed(), rgb.getGreen(), rgb.getBlue(), alpha, depthY, depthZ, true, false, true, true, maxDistance, arr[j], packedLightIn);
                    LightningEntityRenderer.drawQuad(matrix4f, vertex, y, x, j, endY, endX, rgb.getRed(), rgb.getGreen(), rgb.getBlue(), alpha, depthY, depthZ, true, true, false, true, maxDistance, arr[j], packedLightIn);
                    LightningEntityRenderer.drawQuad(matrix4f, vertex, y, x, j, endY, endX, rgb.getRed(), rgb.getGreen(), rgb.getBlue(), alpha, depthY, depthZ, false, true, false, false, maxDistance, arr[j], packedLightIn);
                }
            }
        }
    }

    private static void drawQuad(Matrix4f matrix4f, IVertexBuilder builder, float startY, float startX, int segmentIndex, float endY, float endX, int red, int green, int blue, float alpha, float firstOffset, float secondOffset, boolean negativeOffset, boolean bl2, boolean bl3, boolean bl4, float segmentLength, float segmentLengthAdded, int light) {
        float r = (float)red / 255.0f;
        float g = (float)green / 255.0f;
        float b = (float)blue / 255.0f;
        float a = alpha;
        float x1 = startX + (bl2 ? secondOffset : -secondOffset);
        float y1 = startY + (negativeOffset ? secondOffset : -secondOffset);
        float x2 = endX + (bl2 ? firstOffset : -firstOffset);
        float y2 = endY + (negativeOffset ? firstOffset : -firstOffset);
        float x3 = endX + (bl4 ? firstOffset : -firstOffset);
        float y3 = endY + (bl3 ? firstOffset : -firstOffset);
        float x4 = startX + (bl4 ? secondOffset : -secondOffset);
        float y4 = startY + (bl3 ? secondOffset : -secondOffset);
        float z1 = (float)segmentIndex * segmentLength;
        float z2 = z1 + segmentLengthAdded;
        builder.func_227888_a_(matrix4f, x1, y1, z1).func_227885_a_(r, g, b, a).func_227886_a_(light).func_181675_d();
        builder.func_227888_a_(matrix4f, x2, y2, z2).func_227885_a_(r, g, b, a).func_227886_a_(light).func_181675_d();
        builder.func_227888_a_(matrix4f, x3, y3, z2).func_227885_a_(r, g, b, a).func_227886_a_(light).func_181675_d();
        builder.func_227888_a_(matrix4f, x4, y4, z1).func_227885_a_(r, g, b, a).func_227886_a_(light).func_181675_d();
    }

    public static void renderLightningDischarge(LightningDischargeEntity entity, long seed, float len, float pitch, float yaw, Color rgb, float alpha0, Color outlineRGB, float outlineAlpha, MatrixStack matrixStack, IRenderTypeBuffer bufferIn, int packedLightIn) {
        int j;
        float alpha2;
        float partialTicks = 1.0f;
        Random random = new Random(seed);
        int maxAngle = 90;
        int segments = entity.getDetails();
        float lengthFactor = Math.min(((float)entity.field_70173_aa + partialTicks) / 2.0f, 1.0f);
        float size = 0.01f;
        float length = len * lengthFactor;
        float maxDistance = length / (float)segments;
        float[] arr = new float[segments];
        int targetNumber = (int)((float)segments * lengthFactor);
        int renderTime = (entity.getAliveTicks() > 0 ? entity.getAliveTicks() : 100) / 2;
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71474_y.func_243230_g() == PointOfView.FIRST_PERSON && entity.isRenderingTransparent() && entity.getOwnerId().isPresent() && entity.getOwnerId().get().equals(Minecraft.func_71410_x().field_71439_g.func_110124_au())) {
            alpha0 = 0.03f;
            outlineAlpha = 0.03f;
        }
        float alpha = entity.field_70173_aa < renderTime ? alpha0 : Math.max(alpha0 * (1.0f - ((float)(entity.field_70173_aa - renderTime) + partialTicks) / (float)renderTime), 0.0f);
        float f = alpha2 = entity.field_70173_aa < renderTime ? outlineAlpha : Math.max(outlineAlpha * (1.0f - ((float)(entity.field_70173_aa - renderTime) + partialTicks) / (float)renderTime), 0.0f);
        if (entity.getAliveTicks() <= 0) {
            alpha = alpha0;
            alpha2 = outlineAlpha;
        }
        for (int segment = 0; segment < arr.length; ++segment) {
            arr[segment] = segment == targetNumber ? length - maxDistance * (float)segment : maxDistance;
        }
        float[] offsetsY = new float[segments];
        float[] offsetsX = new float[segments];
        IVertexBuilder vertex = entity.isRenderingTransparent() ? bufferIn.getBuffer(ModRenderTypes.TRANSPARENT_COLOR2) : bufferIn.getBuffer(ModRenderTypes.ENERGY);
        Matrix4f matrix4f = matrixStack.func_227866_c_().func_227870_a_();
        matrixStack.func_227863_a_(Vector3f.field_229180_c_.func_229187_a_(pitch));
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(yaw));
        size = (float)((double)size + WyHelper.randomDouble() / 20.0);
        float lastOffsetY = 0.0f;
        float lastOffsetX = 0.0f;
        for (j = 0; j < segments; ++j) {
            offsetsY[j] = lastOffsetY;
            offsetsX[j] = lastOffsetX;
            lastOffsetY = (float)((double)lastOffsetY + Math.sin(Math.toRadians((float)random.nextInt(maxAngle) - (float)maxAngle / 2.0f)));
            lastOffsetX = (float)((double)lastOffsetX + Math.sin(Math.toRadians((float)random.nextInt(maxAngle) - (float)maxAngle / 2.0f)));
        }
        for (j = 0; j < segments; ++j) {
            if (entity.isSplit() && (double)j % WyHelper.randomWithRange(1, 3) == 0.0 || j < entity.getSkipSegmnets()) continue;
            float y = offsetsY[j];
            float x = offsetsX[j];
            for (int depth = 1; depth < 4; ++depth) {
                float endX;
                float depthY = size / 2.0f + (float)depth * size;
                float depthZ = size / 2.0f + (float)depth * size;
                float endY = j == segments - 1 ? y : offsetsY[j + 1];
                float f2 = endX = j == segments - 1 ? x : offsetsX[j + 1];
                if (j <= targetNumber) {
                    LightningEntityRenderer.drawQuad(matrix4f, vertex, y, x, j, endY, endX, rgb.getRed(), rgb.getGreen(), rgb.getBlue(), alpha, depthY, depthZ, false, false, true, false, maxDistance, arr[j], packedLightIn);
                    LightningEntityRenderer.drawQuad(matrix4f, vertex, y, x, j, endY, endX, rgb.getRed(), rgb.getGreen(), rgb.getBlue(), alpha, depthY, depthZ, true, false, true, true, maxDistance, arr[j], packedLightIn);
                    LightningEntityRenderer.drawQuad(matrix4f, vertex, y, x, j, endY, endX, rgb.getRed(), rgb.getGreen(), rgb.getBlue(), alpha, depthY, depthZ, true, true, false, true, maxDistance, arr[j], packedLightIn);
                    LightningEntityRenderer.drawQuad(matrix4f, vertex, y, x, j, endY, endX, rgb.getRed(), rgb.getGreen(), rgb.getBlue(), alpha, depthY, depthZ, false, true, false, false, maxDistance, arr[j], packedLightIn);
                }
                if (entity.getOutlineColor() == 0) continue;
                depthY = size / 2.0f + (float)depth * (size + 0.01f);
                depthZ = size / 2.0f + (float)depth * (size + 0.01f);
                if (j > targetNumber) continue;
                LightningEntityRenderer.drawQuad(matrix4f, vertex, y, x, j, endY, endX, outlineRGB.getRed(), outlineRGB.getGreen(), outlineRGB.getBlue(), alpha2, depthY, depthZ, false, false, true, false, maxDistance, arr[j], packedLightIn);
                LightningEntityRenderer.drawQuad(matrix4f, vertex, y, x, j, endY, endX, outlineRGB.getRed(), outlineRGB.getGreen(), outlineRGB.getBlue(), alpha2, depthY, depthZ, true, false, true, true, maxDistance, arr[j], packedLightIn);
                LightningEntityRenderer.drawQuad(matrix4f, vertex, y, x, j, endY, endX, outlineRGB.getRed(), outlineRGB.getGreen(), outlineRGB.getBlue(), alpha2, depthY, depthZ, true, true, false, true, maxDistance, arr[j], packedLightIn);
                LightningEntityRenderer.drawQuad(matrix4f, vertex, y, x, j, endY, endX, outlineRGB.getRed(), outlineRGB.getGreen(), outlineRGB.getBlue(), alpha2, depthY, depthZ, false, true, false, false, maxDistance, arr[j], packedLightIn);
            }
        }
    }

    public ResourceLocation getTextureLocation(LightningEntity entity) {
        return null;
    }

    public boolean shouldRender(LightningEntity livingEntityIn, ClippingHelper camera, double camX, double camY, double camZ) {
        return true;
    }

    public static class Factory
    implements IRenderFactory<LightningEntity> {
        public EntityRenderer<? super LightningEntity> createRenderFor(EntityRendererManager manager) {
            return new LightningEntityRenderer(manager);
        }
    }
}

