/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.renderers.entities;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.function.Predicate;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import xyz.pixelatedw.mineminenomi.entities.mobs.animals.WhiteWalkieEntity;
import xyz.pixelatedw.mineminenomi.init.ModRenderTypes;
import xyz.pixelatedw.mineminenomi.models.entities.mobs.animals.WhiteWalkieModel;
import xyz.pixelatedw.mineminenomi.renderers.layers.EyesLayer;
import xyz.pixelatedw.mineminenomi.renderers.layers.WhiteWalkieSaddleLayer;

public class WhiteWalkieRenderer<T extends WhiteWalkieEntity, M extends WhiteWalkieModel<T>>
extends MobRenderer<T, M> {
    private static final RenderType SLEEPING_EYES = ModRenderTypes.getEyesLayerRenderType(new ResourceLocation("mineminenomi", "textures/models/white_walkie_sleeping_eyes.png"));
    public static final ResourceLocation TEXTURE = new ResourceLocation("mineminenomi", "textures/models/white_walkie.png");
    private static final Predicate<WhiteWalkieEntity> IS_SLEEPING = WhiteWalkieEntity::func_70608_bn;

    public WhiteWalkieRenderer(EntityRendererManager manager) {
        super(manager, new WhiteWalkieModel(), 1.2f);
        this.func_177094_a(new EyesLayer((IEntityRenderer)this, SLEEPING_EYES, IS_SLEEPING));
        this.func_177094_a(new WhiteWalkieSaddleLayer(this));
    }

    public void render(T entity, float entityYaw, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer buffer, int packedLight) {
        super.func_225623_a_(entity, entityYaw, partialTicks, matrixStack, buffer, packedLight);
    }

    protected void setupRotations(T entity, MatrixStack matrixStack, float ageInTicks, float rotationYaw, float partialTicks) {
        super.func_225621_a_(entity, matrixStack, ageInTicks, rotationYaw, partialTicks);
        if (((WhiteWalkieEntity)entity).func_70608_bn()) {
            matrixStack.func_227861_a_(0.0, -0.55, 0.0);
            ((WhiteWalkieModel)this.func_217764_d()).setSleepPosition(true);
        } else {
            ((WhiteWalkieModel)this.func_217764_d()).setSleepPosition(false);
        }
    }

    public ResourceLocation getTextureLocation(T entity) {
        return TEXTURE;
    }

    public static class Factory
    implements IRenderFactory {
        public EntityRenderer createRenderFor(EntityRendererManager manager) {
            return new WhiteWalkieRenderer(manager);
        }
    }
}

