/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.renderers.morphs;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import xyz.pixelatedw.mineminenomi.api.morph.MorphInfo;
import xyz.pixelatedw.mineminenomi.api.morph.MorphModel;
import xyz.pixelatedw.mineminenomi.entities.zoan.PteranodonFlyMorphInfo;
import xyz.pixelatedw.mineminenomi.renderers.morphs.ZoanMorphRenderer;

public class FlyPointRenderer<T extends AbstractClientPlayerEntity, M extends MorphModel>
extends ZoanMorphRenderer<T, M> {
    public FlyPointRenderer(EntityRendererManager rendererManager, MorphInfo info) {
        super(rendererManager, info);
        this.setCullingState(true);
    }

    @Override
    protected void renderModel(AbstractClientPlayerEntity entity, MatrixStack matrixStack, int packedLight, IRenderTypeBuffer buffer, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (this.info instanceof PteranodonFlyMorphInfo) {
            matrixStack.func_227861_a_(0.0, 1.0, 0.0);
        }
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(headPitch));
        double distanceX = entity.func_226277_ct_() - entity.field_70169_q;
        double distanceZ = entity.func_226281_cx_() - entity.field_70166_s;
        double movementSpeed = MathHelper.func_76133_a((double)(distanceX * distanceX + distanceZ * distanceZ));
        float maxRotation = (float)(movementSpeed * 80.0);
        float rot = -netHeadYaw * 3.0f;
        rot = MathHelper.func_76131_a((float)rot, (float)(-maxRotation), (float)maxRotation);
        matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(rot));
        super.renderModel(entity, matrixStack, packedLight, buffer, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch);
    }

    public static class Factory<T extends PlayerEntity>
    implements IRenderFactory<T> {
        private MorphInfo info;
        private boolean hasCulling;

        public Factory(MorphInfo info) {
            this.info = info;
        }

        public Factory(MorphInfo info, boolean hasCulling) {
            this.info = info;
            this.hasCulling = hasCulling;
        }

        public EntityRenderer<? super T> createRenderFor(EntityRendererManager manager) {
            FlyPointRenderer renderer = new FlyPointRenderer(manager, this.info);
            renderer.setCullingState(this.hasCulling);
            return renderer;
        }
    }
}

