/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.screens;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.InventoryScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.RegistryObject;
import xyz.pixelatedw.mineminenomi.api.interactions.Interaction;
import xyz.pixelatedw.mineminenomi.packets.client.ui.CTriggerInteractionPacket;
import xyz.pixelatedw.mineminenomi.screens.extra.SequencedString;
import xyz.pixelatedw.mineminenomi.screens.extra.buttons.FactionButton;
import xyz.pixelatedw.mineminenomi.wypi.WyNetwork;

@OnlyIn(value=Dist.CLIENT)
public class DialogueScreen
extends Screen {
    private PlayerEntity player;
    private LivingEntity entity;
    private SequencedString message = new SequencedString("", 0, 0);
    private Interaction[] interactions;

    public DialogueScreen(LivingEntity entity, Interaction interaction) {
        super(StringTextComponent.field_240750_d_);
        this.entity = entity;
        this.player = Minecraft.func_71410_x().field_71439_g;
        this.field_230706_i_ = Minecraft.func_71410_x();
        this.field_230712_o_ = this.field_230706_i_.field_71466_p;
        this.triggerInteraction(interaction);
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(matrixStack);
        int posX = this.field_230708_k_ / 2;
        int posY = this.field_230709_l_ / 2;
        this.message.render(matrixStack, posX - 150, posY - 105, partialTicks);
        RenderSystem.pushMatrix();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        InventoryScreen.func_228187_a_((int)(posX + 150), (int)(posY + 150), (int)100, (float)40.0f, (float)5.0f, (LivingEntity)this.entity);
        RenderSystem.popMatrix();
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
    }

    public void func_231158_b_(Minecraft minecraft, int width, int height) {
        super.func_231158_b_(minecraft, width, height);
        int posX = this.field_230708_k_ / 2;
        int posY = this.field_230709_l_ / 2;
        this.setupInteractions();
    }

    private void setupInteractions() {
        int posX = this.field_230708_k_ / 2;
        int posY = this.field_230709_l_ / 2;
        int i = 0;
        for (Interaction interaction : this.interactions) {
            if (!interaction.hasTriggerAction()) continue;
            FactionButton interactionButton = new FactionButton(posX - 180, posY + 10 + i * 20, 100, 20, interaction.getTitle(), btn -> WyNetwork.sendToServer(new CTriggerInteractionPacket(interaction, this.entity)));
            this.func_230480_a_((Widget)interactionButton);
            ++i;
        }
    }

    public void triggerInteraction(Interaction interaction) {
        String message = interaction.getMessage().getString();
        this.message = new SequencedString(message, 250, this.field_230712_o_.func_78256_a(message) / 2);
        this.interactions = new Interaction[interaction.getInteractions().length];
        int i = 0;
        for (RegistryObject<Interaction> sub : interaction.getInteractions()) {
            this.interactions[i] = (Interaction)sub.get();
            ++i;
        }
        this.func_231158_b_(this.field_230706_i_, this.field_230708_k_, this.field_230709_l_);
    }
}

