/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.screens;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.client.gui.GuiUtils;
import net.minecraftforge.fml.client.gui.widget.Slider;
import org.lwjgl.opengl.GL11;
import xyz.pixelatedw.mineminenomi.api.crew.Crew;
import xyz.pixelatedw.mineminenomi.api.crew.JollyRoger;
import xyz.pixelatedw.mineminenomi.api.crew.JollyRogerElement;
import xyz.pixelatedw.mineminenomi.api.helpers.RendererHelper;
import xyz.pixelatedw.mineminenomi.init.ModI18n;
import xyz.pixelatedw.mineminenomi.init.ModResources;
import xyz.pixelatedw.mineminenomi.packets.client.crew.CUpdateJollyRogerPacket;
import xyz.pixelatedw.mineminenomi.screens.NewCrewScreen;
import xyz.pixelatedw.mineminenomi.screens.extra.buttons.SimpleButton;
import xyz.pixelatedw.mineminenomi.screens.extra.buttons.TexturedIconButton;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.WyNetwork;

@OnlyIn(value=Dist.CLIENT)
public class JollyRogerCreatorScreen
extends Screen {
    private PlayerEntity player;
    private Widget selectedButton;
    private JollyRogerElement.LayerType layerType = JollyRogerElement.LayerType.BASE;
    private Crew crew;
    private JollyRoger jollyRoger;
    private float animationTime = 0.0f;
    private int nextElementTry = 0;
    private boolean isEditing = false;
    private int layerIndex;
    private int trueIndex;
    private Slider redSlider;
    private Slider greenSlider;
    private Slider blueSlider;
    private LinkedHashSet<JollyRogerElement> allElements;
    private List<JollyRogerElement> allBases;
    private List<JollyRogerElement> allBackgrounds;
    private List<JollyRogerElement> allDetails;

    public JollyRogerCreatorScreen(boolean isEditing, Crew crew, LinkedHashSet<JollyRogerElement> elements) {
        super((ITextComponent)new StringTextComponent(""));
        Minecraft mc = Minecraft.func_71410_x();
        this.player = mc.field_71439_g;
        this.crew = crew;
        this.jollyRoger = crew.getJollyRoger();
        this.isEditing = isEditing;
        this.allElements = elements;
        this.allBases = this.getTotalElementsForType(this.player, JollyRogerElement.LayerType.BASE);
        this.allBackgrounds = this.getTotalElementsForType(this.player, JollyRogerElement.LayerType.BACKGROUND);
        this.allDetails = this.getTotalElementsForType(this.player, JollyRogerElement.LayerType.DETAIL);
        this.animationTime = 1.0f;
    }

    public void func_230430_a_(MatrixStack matrixStack, int x, int y, float f) {
        String text;
        this.player.field_70170_p.func_217381_Z().func_76320_a("jollyRogerRendering");
        this.func_230446_a_(matrixStack);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int posX = this.field_230708_k_ / 2;
        int posY = this.field_230709_l_ / 2;
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GL11.glPushMatrix();
        double scale = 0.5;
        GL11.glTranslated((double)(posX - 115), (double)(posY - 130), (double)1.0);
        GL11.glTranslated((double)128.0, (double)128.0, (double)0.0);
        GL11.glScaled((double)scale, (double)scale, (double)scale);
        GL11.glTranslated((double)-128.0, (double)-128.0, (double)0.0);
        RendererHelper.drawPlayerJollyRoger(this.jollyRoger, matrixStack);
        if ((double)this.animationTime < 0.15) {
            this.animationTime = (float)((double)this.animationTime + 0.007);
            GL11.glTranslated((double)128.0, (double)128.0, (double)0.0);
            GL11.glScaled((double)(scale += 0.45 + (double)this.animationTime), (double)scale, (double)scale);
            GL11.glTranslated((double)-128.0, (double)-128.0, (double)0.0);
            JollyRogerElement element = this.getLayerElement();
            if (element != null) {
                if (element.canBeColored()) {
                    Color color = WyHelper.getComplementaryColor(element.getFullColor());
                    RenderSystem.color4f((float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f), (float)(0.9f - this.animationTime * 5.0f));
                } else {
                    RenderSystem.color4f((float)1.0f, (float)0.0f, (float)0.0f, (float)(0.9f - this.animationTime * 4.0f));
                }
                Minecraft.func_71410_x().func_110434_K().func_110577_a(element.getTexture());
                GuiUtils.drawTexturedModalRect((MatrixStack)matrixStack, (int)0, (int)0, (int)0, (int)0, (int)256, (int)256, (float)10.0f);
            }
        }
        GL11.glPopMatrix();
        String string = text = this.trueIndex >= 0 ? this.trueIndex + 1 + " / " + this.allBases.size() : new TranslationTextComponent(ModI18n.GUI_EMPTY).getString();
        if (this.layerType == JollyRogerElement.LayerType.BACKGROUND) {
            text = this.trueIndex >= 0 ? this.trueIndex + 1 + " / " + this.allBackgrounds.size() : new TranslationTextComponent(ModI18n.GUI_EMPTY).getString();
        } else if (this.layerType == JollyRogerElement.LayerType.DETAIL) {
            text = this.trueIndex >= 0 ? this.trueIndex + 1 + " / " + this.allDetails.size() : new TranslationTextComponent(ModI18n.GUI_EMPTY).getString();
        }
        WyHelper.drawStringWithBorder(this.field_230712_o_, matrixStack, text, posX - this.field_230712_o_.func_78256_a(text) / 2 + 12, posY + 80, WyHelper.hexToRGB("#FFFFFF").getRGB());
        RenderSystem.disableBlend();
        posX = this.field_230708_k_;
        posY = this.field_230709_l_ / 2;
        int outlineSize = 2;
        int pX = posX - 95;
        int pY = posY - 85;
        int sW = posX + 100;
        int sH = posY + 45;
        JollyRogerElement element = this.getLayerElement();
        if (element != null) {
            if (element.canBeColored()) {
                this.func_238468_a_(matrixStack, pX - outlineSize, pY - outlineSize, sW + outlineSize, sH + outlineSize, WyHelper.hexToRGB("#000000").getRGB(), WyHelper.hexToRGB("#000000").getRGB());
                this.func_238468_a_(matrixStack, pX, pY, sW, sH, WyHelper.hexToRGB("#B3B3B3").getRGB(), WyHelper.hexToRGB("#505050").getRGB());
                WyHelper.drawStringWithBorder(this.field_230712_o_, matrixStack, new TranslationTextComponent(ModI18n.GUI_RED).getString() + " ", posX - 75, posY -= 75, WyHelper.hexToRGB("#FFFFFF").getRGB());
                WyHelper.drawStringWithBorder(this.field_230712_o_, matrixStack, "0", posX - 85, posY + 14, WyHelper.hexToRGB("#FFFFFF").getRGB());
                WyHelper.drawStringWithBorder(this.field_230712_o_, matrixStack, "255", posX - 23, posY + 14, WyHelper.hexToRGB("#FFFFFF").getRGB());
                WyHelper.drawStringWithBorder(this.field_230712_o_, matrixStack, new TranslationTextComponent(ModI18n.GUI_GREEN).getString() + " ", posX - 75, posY += 40, WyHelper.hexToRGB("#FFFFFF").getRGB());
                WyHelper.drawStringWithBorder(this.field_230712_o_, matrixStack, "0", posX - 85, posY + 14, WyHelper.hexToRGB("#FFFFFF").getRGB());
                WyHelper.drawStringWithBorder(this.field_230712_o_, matrixStack, "255", posX - 23, posY + 14, WyHelper.hexToRGB("#FFFFFF").getRGB());
                WyHelper.drawStringWithBorder(this.field_230712_o_, matrixStack, new TranslationTextComponent(ModI18n.GUI_BLUE).getString() + " ", posX - 75, posY += 40, WyHelper.hexToRGB("#FFFFFF").getRGB());
                WyHelper.drawStringWithBorder(this.field_230712_o_, matrixStack, "0", posX - 85, posY + 14, WyHelper.hexToRGB("#FFFFFF").getRGB());
                WyHelper.drawStringWithBorder(this.field_230712_o_, matrixStack, "255", posX - 23, posY + 14, WyHelper.hexToRGB("#FFFFFF").getRGB());
            }
            if (element != this.jollyRoger.getBase()) {
                posY = this.field_230709_l_ / 2;
                pX = posX - 95;
                pY = posY + 50;
                sW = posX + 100;
                sH = posY + 85;
                this.func_238468_a_(matrixStack, pX - outlineSize, pY - outlineSize, sW + outlineSize, sH + outlineSize, WyHelper.hexToRGB("#000000").getRGB(), WyHelper.hexToRGB("#000000").getRGB());
                this.func_238468_a_(matrixStack, pX, pY, sW, sH, WyHelper.hexToRGB("#B3B3B3").getRGB(), WyHelper.hexToRGB("#505050").getRGB());
                WyHelper.drawStringWithBorder(this.field_230712_o_, matrixStack, this.layerIndex + 1 + "", posX - 55, posY + 64, WyHelper.hexToRGB("#FFFFFF").getRGB());
            }
        }
        this.player.field_70170_p.func_217381_Z().func_76319_b();
        super.func_230430_a_(matrixStack, x, y, f);
    }

    public void func_231158_b_(Minecraft mc, int width, int height) {
        Slider blueColorPicker;
        Slider greenColorPicker;
        Slider redColorPicker;
        int i;
        super.func_231158_b_(mc, width, height);
        int posX = 0;
        int posY = this.field_230709_l_ / 2;
        int listPosY = posY - 85;
        SimpleButton baseButton = new SimpleButton(posX + 5, listPosY, 115, 16, (ITextComponent)new TranslationTextComponent(ModI18n.GUI_BASE), this::selectButton);
        this.func_230480_a_((Widget)baseButton);
        for (i = 0; i < this.jollyRoger.getBackgrounds().length; ++i) {
            SimpleButton bgButton = new SimpleButton(posX + 5, listPosY + 20 + i * 20, 115, 16, (ITextComponent)new StringTextComponent(new TranslationTextComponent(ModI18n.GUI_BACKGROUND).getString() + " " + (i + 1)), this::selectButton);
            this.func_230480_a_((Widget)bgButton);
        }
        for (i = 0; i < this.jollyRoger.getDetails().length; ++i) {
            SimpleButton detailButton = new SimpleButton(posX + 5, listPosY + 60 + i * 20, 115, 16, (ITextComponent)new StringTextComponent(new TranslationTextComponent(ModI18n.GUI_DETAIL).getString() + " " + (i + 1)), this::selectButton);
            this.func_230480_a_((Widget)detailButton);
        }
        posX = this.field_230708_k_ / 2;
        TexturedIconButton nextBaseTexture = new TexturedIconButton(ModResources.BIG_WOOD_BUTTON_RIGHT, posX + 80, posY - 65, 32, 110, (ITextComponent)new StringTextComponent(""), btn -> this.moveIndex(btn, true));
        nextBaseTexture = nextBaseTexture.setTextureInfo(posX + 80, posY - 75, 32, 128);
        this.func_230480_a_((Widget)nextBaseTexture);
        TexturedIconButton prevBaseTexture = new TexturedIconButton(ModResources.BIG_WOOD_BUTTON_LEFT, posX - 85, posY - 65, 32, 110, (ITextComponent)new StringTextComponent(""), btn -> this.moveIndex(btn, false));
        prevBaseTexture = prevBaseTexture.setTextureInfo(posX - 85, posY - 75, 32, 128);
        this.func_230480_a_((Widget)prevBaseTexture);
        posX = this.field_230708_k_;
        this.redSlider = redColorPicker = new Slider(posX - 76, posY - 65, 50, 16, (ITextComponent)new StringTextComponent(""), (ITextComponent)new StringTextComponent(""), 0.0, 255.0, 255.0, false, true, btn -> {}, slider -> this.changeColor(slider, "red"));
        this.func_230480_a_((Widget)redColorPicker);
        this.greenSlider = greenColorPicker = new Slider(posX - 76, posY - 25, 50, 16, (ITextComponent)new StringTextComponent(""), (ITextComponent)new StringTextComponent(""), 0.0, 255.0, 255.0, false, true, btn -> {}, slider -> this.changeColor(slider, "green"));
        this.func_230480_a_((Widget)greenColorPicker);
        this.blueSlider = blueColorPicker = new Slider(posX - 76, posY + 15, 50, 16, (ITextComponent)new StringTextComponent(""), (ITextComponent)new StringTextComponent(""), 0.0, 255.0, 255.0, false, true, btn -> {}, slider -> this.changeColor(slider, "blue"));
        this.func_230480_a_((Widget)blueColorPicker);
        SimpleButton editJollyRogerButton = new SimpleButton(this.field_230708_k_ / 2 - 17, posY + 95, 60, 16, (ITextComponent)new TranslationTextComponent(ModI18n.GUI_FINISH), btn -> this.finishEditing());
        this.func_230480_a_((Widget)editJollyRogerButton);
        TexturedIconButton layerUpBtn = new TexturedIconButton(ModResources.BRIGHT_WOOD_ARROW, posX - 80, posY + 53, 16, 25, (ITextComponent)new StringTextComponent(""), btn -> this.changeLayerIndex(true));
        layerUpBtn = layerUpBtn.setTextureInfo(posX - 104, posY + 51, 64, 32);
        this.func_230480_a_((Widget)layerUpBtn);
        TexturedIconButton layerDownBtn = new TexturedIconButton(ModResources.BRIGHT_WOOD_ARROW_DOWN, posX - 40, posY + 53, 16, 25, (ITextComponent)new StringTextComponent(""), btn -> this.changeLayerIndex(false));
        layerDownBtn = layerDownBtn.setTextureInfo(posX - 64, posY + 48, 64, 32);
        this.func_230480_a_((Widget)layerDownBtn);
        this.updateButtons();
    }

    private void finishEditing() {
        if (this.isEditing) {
            NewCrewScreen.open();
        } else {
            this.func_231175_as__();
        }
    }

    private void changeLayerIndex(boolean isUp) {
        int layerIndex = this.layerIndex;
        boolean canSwitch = false;
        if (this.layerType == JollyRogerElement.LayerType.BACKGROUND) {
            JollyRogerElement currentElement = this.jollyRoger.getBackgrounds()[layerIndex];
            JollyRogerElement nextElement = null;
            JollyRogerElement prevElement = null;
            if (isUp && this.layerIndex >= 0 && this.layerIndex + 1 < this.jollyRoger.getBackgrounds().length) {
                nextElement = this.jollyRoger.getBackgrounds()[++layerIndex];
                canSwitch = true;
            } else if (!isUp && this.layerIndex - 1 >= 0 && this.layerIndex <= this.jollyRoger.getBackgrounds().length) {
                prevElement = this.jollyRoger.getBackgrounds()[--layerIndex];
                canSwitch = true;
            }
            if (currentElement != null && canSwitch) {
                this.jollyRoger.getBackgrounds()[layerIndex] = currentElement;
                if (isUp) {
                    this.jollyRoger.getBackgrounds()[--layerIndex] = nextElement;
                    ++this.layerIndex;
                } else if (!isUp) {
                    this.jollyRoger.getBackgrounds()[++layerIndex] = prevElement;
                    --this.layerIndex;
                }
                this.updateButtons();
                this.animationTime = 0.0f;
                ((SimpleButton)this.selectedButton).select();
                this.selectedButton = (Widget)this.field_230710_m_.get(1 + this.layerIndex);
                ((SimpleButton)this.selectedButton).select();
            }
        } else if (this.layerType == JollyRogerElement.LayerType.DETAIL) {
            JollyRogerElement currentElement = this.jollyRoger.getDetails()[layerIndex];
            JollyRogerElement nextElement = null;
            JollyRogerElement prevElement = null;
            if (isUp && this.layerIndex >= 0 && this.layerIndex + 1 < this.jollyRoger.getDetails().length) {
                nextElement = this.jollyRoger.getDetails()[++layerIndex];
                canSwitch = true;
            } else if (!isUp && this.layerIndex - 1 >= 0 && this.layerIndex <= this.jollyRoger.getDetails().length) {
                prevElement = this.jollyRoger.getDetails()[--layerIndex];
                canSwitch = true;
            }
            if (currentElement != null && canSwitch) {
                this.jollyRoger.getDetails()[layerIndex] = currentElement;
                if (isUp) {
                    this.jollyRoger.getDetails()[--layerIndex] = nextElement;
                    ++this.layerIndex;
                } else if (!isUp) {
                    this.jollyRoger.getDetails()[++layerIndex] = prevElement;
                    --this.layerIndex;
                }
                this.updateButtons();
                this.animationTime = 0.0f;
                ((SimpleButton)this.selectedButton).select();
                this.selectedButton = (Widget)this.field_230710_m_.get(3 + this.layerIndex);
                ((SimpleButton)this.selectedButton).select();
            }
        }
    }

    public void changeColor(Slider slider, String color) {
        JollyRogerElement element;
        if (!slider.func_230449_g_()) {
            slider.dragging = false;
        }
        if ((element = this.getLayerElement()) == null) {
            return;
        }
        if (color.equalsIgnoreCase("red")) {
            element.setColor(slider.getValueInt(), element.getGreen(), element.getBlue());
        } else if (color.equalsIgnoreCase("green")) {
            element.setColor(element.getRed(), slider.getValueInt(), element.getBlue());
        } else if (color.equalsIgnoreCase("blue")) {
            element.setColor(element.getRed(), element.getGreen(), slider.getValueInt());
        }
    }

    public void moveIndex(Button btn, boolean toRight) {
        try {
            ++this.nextElementTry;
            this.trueIndex = toRight ? ++this.trueIndex : --this.trueIndex;
            if (this.layerType == JollyRogerElement.LayerType.BASE) {
                boolean hasElement;
                JollyRogerElement element;
                int i;
                if (this.trueIndex >= this.allBases.size()) {
                    this.trueIndex = -1;
                }
                if (this.trueIndex < 0 && this.jollyRoger.getBase() == null) {
                    this.trueIndex = this.allBases.size() - 1;
                }
                if (this.trueIndex >= 0 && this.trueIndex <= this.allBases.size()) {
                    this.jollyRoger.setBase(this.allBases.get(this.trueIndex));
                } else if (this.trueIndex <= 0 && this.jollyRoger.getBase().getTexture() != null) {
                    this.jollyRoger.setBase(null);
                }
                for (i = 0; i < this.jollyRoger.getBackgrounds().length; ++i) {
                    element = this.jollyRoger.getBackgrounds()[i];
                    hasElement = this.allBackgrounds.stream().anyMatch(elem -> elem.equals((Object)element) && !elem.canUse(this.player, this.crew));
                    if (!hasElement) continue;
                    this.jollyRoger.getBackgrounds()[i] = null;
                }
                for (i = 0; i < this.jollyRoger.getDetails().length; ++i) {
                    element = this.jollyRoger.getDetails()[i];
                    hasElement = this.allDetails.stream().anyMatch(elem -> elem.equals((Object)element) && !elem.canUse(this.player, this.crew));
                    if (!hasElement) continue;
                    this.jollyRoger.getDetails()[i] = null;
                }
            } else if (this.layerType == JollyRogerElement.LayerType.BACKGROUND) {
                if (this.trueIndex >= this.allBackgrounds.size()) {
                    this.trueIndex = -1;
                }
                if (this.trueIndex < 0 && this.jollyRoger.getBackgrounds()[this.layerIndex] == null) {
                    this.trueIndex = this.allBackgrounds.size() - 1;
                }
                if (this.nextElementTry > this.allBackgrounds.size()) {
                    this.jollyRoger.getBackgrounds()[this.layerIndex] = null;
                    this.trueIndex = -1;
                    this.nextElementTry = 0;
                    this.updateButtons();
                    return;
                }
                if (this.trueIndex >= 0 && this.trueIndex <= this.allBackgrounds.size()) {
                    JollyRogerElement ogElem = this.allBackgrounds.get(this.trueIndex);
                    for (int i = 0; i < this.jollyRoger.getBackgrounds().length; ++i) {
                        JollyRogerElement element = this.jollyRoger.getBackgrounds()[i];
                        if (element == null || ogElem == null || !ogElem.equals((Object)element)) continue;
                        this.moveIndex(btn, toRight);
                        return;
                    }
                }
                if (this.trueIndex >= 0 && this.trueIndex <= this.allBackgrounds.size()) {
                    this.jollyRoger.getBackgrounds()[this.layerIndex] = this.allBackgrounds.get(this.trueIndex);
                } else if (this.trueIndex <= 0 && this.jollyRoger.getBackgrounds()[this.layerIndex].getTexture() != null) {
                    this.jollyRoger.getBackgrounds()[this.layerIndex] = null;
                }
                this.nextElementTry = 0;
            } else if (this.layerType == JollyRogerElement.LayerType.DETAIL) {
                if (this.trueIndex >= this.allDetails.size()) {
                    this.trueIndex = -1;
                }
                if (this.trueIndex < 0 && this.trueIndex <= this.allDetails.size() && this.jollyRoger.getDetails()[this.layerIndex] == null) {
                    this.trueIndex = this.allDetails.size() - 1;
                }
                if (this.nextElementTry >= this.allDetails.size()) {
                    this.jollyRoger.getDetails()[this.layerIndex] = null;
                    this.trueIndex = -1;
                    this.nextElementTry = 0;
                    this.updateButtons();
                    return;
                }
                if (this.trueIndex >= 0 && this.trueIndex <= this.allDetails.size()) {
                    JollyRogerElement ogElem = this.allDetails.get(this.trueIndex);
                    for (int i = 0; i < this.jollyRoger.getDetails().length; ++i) {
                        JollyRogerElement element = this.jollyRoger.getDetails()[i];
                        if (element == null || ogElem == null || !ogElem.equals((Object)element)) continue;
                        this.moveIndex(btn, toRight);
                        return;
                    }
                }
                if (this.trueIndex >= 0 && this.trueIndex <= this.allDetails.size()) {
                    this.jollyRoger.getDetails()[this.layerIndex] = this.allDetails.get(this.trueIndex);
                } else if (this.trueIndex <= 0 && this.jollyRoger.getDetails()[this.layerIndex].getTexture() != null) {
                    this.jollyRoger.getDetails()[this.layerIndex] = null;
                }
                this.nextElementTry = 0;
            }
            this.updateButtons();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void selectButton(Button btn) {
        int i;
        int j;
        if (!(btn instanceof SimpleButton)) {
            return;
        }
        if (this.selectedButton != null) {
            ((SimpleButton)this.selectedButton).select();
        }
        this.selectedButton = btn;
        ((SimpleButton)btn).select();
        this.animationTime = 0.0f;
        boolean hasLayerSet = false;
        if (this.field_230710_m_.get(0) == btn) {
            this.trueIndex = this.findIndex(this.getListFromType(JollyRogerElement.LayerType.BASE), this.jollyRoger.getBase(), this.player);
            this.layerType = JollyRogerElement.LayerType.BASE;
            this.layerIndex = 0;
            hasLayerSet = true;
        }
        if (!hasLayerSet) {
            j = 0;
            for (i = 1; i < this.jollyRoger.getBackgrounds().length + 1; ++i) {
                if (this.field_230710_m_.get(i) == btn) {
                    this.trueIndex = this.findIndex(this.getListFromType(JollyRogerElement.LayerType.BACKGROUND), this.jollyRoger.getBackgrounds()[j], this.player);
                    this.layerType = JollyRogerElement.LayerType.BACKGROUND;
                    this.allBackgrounds = this.getTotalElementsForType(this.player, JollyRogerElement.LayerType.BACKGROUND);
                    this.layerIndex = j;
                    hasLayerSet = true;
                }
                ++j;
            }
        }
        if (!hasLayerSet) {
            j = 0;
            for (i = this.jollyRoger.getBackgrounds().length + 1; i < this.jollyRoger.getDetails().length + this.jollyRoger.getBackgrounds().length + 1; ++i) {
                if (this.field_230710_m_.get(i) == btn) {
                    this.trueIndex = this.findIndex(this.getListFromType(JollyRogerElement.LayerType.DETAIL), this.jollyRoger.getDetails()[j], this.player);
                    this.layerType = JollyRogerElement.LayerType.DETAIL;
                    this.allDetails = this.getTotalElementsForType(this.player, JollyRogerElement.LayerType.DETAIL);
                    this.layerIndex = j;
                    hasLayerSet = true;
                }
                ++j;
            }
        }
        this.updateButtons();
    }

    private void updateButtons() {
        JollyRogerElement element = this.getLayerElement();
        if (element == null) {
            ((Widget)this.field_230710_m_.get((int)(this.field_230710_m_.size() - 1))).field_230694_p_ = false;
            ((Widget)this.field_230710_m_.get((int)(this.field_230710_m_.size() - 2))).field_230694_p_ = false;
            for (Widget widget : this.field_230710_m_) {
                if (!(widget instanceof Slider)) continue;
                widget.field_230694_p_ = false;
            }
        } else {
            ((Widget)this.field_230710_m_.get((int)(this.field_230710_m_.size() - 1))).field_230694_p_ = true;
            ((Widget)this.field_230710_m_.get((int)(this.field_230710_m_.size() - 2))).field_230694_p_ = true;
            if (element == this.jollyRoger.getBase()) {
                ((Widget)this.field_230710_m_.get((int)(this.field_230710_m_.size() - 1))).field_230694_p_ = false;
                ((Widget)this.field_230710_m_.get((int)(this.field_230710_m_.size() - 2))).field_230694_p_ = false;
            }
            if (!element.canBeColored()) {
                for (Widget widget : this.field_230710_m_) {
                    if (!(widget instanceof Slider)) continue;
                    widget.field_230694_p_ = false;
                }
            } else {
                for (Widget widget : this.field_230710_m_) {
                    if (!(widget instanceof Slider)) continue;
                    widget.field_230694_p_ = true;
                }
                this.resetColorSliders(element);
            }
        }
    }

    private JollyRogerElement getLayerElement() {
        JollyRogerElement element = this.jollyRoger.getBase();
        if (this.layerType == JollyRogerElement.LayerType.BASE) {
            element = this.jollyRoger.getBase();
        } else if (this.layerType == JollyRogerElement.LayerType.BACKGROUND) {
            element = this.jollyRoger.getBackgrounds()[this.layerIndex];
        } else if (this.layerType == JollyRogerElement.LayerType.DETAIL) {
            element = this.jollyRoger.getDetails()[this.layerIndex];
        }
        return element;
    }

    private void resetColorSliders(JollyRogerElement element) {
        if (element != null) {
            this.redSlider.setValue((double)element.getRed());
            this.redSlider.updateSlider();
            this.greenSlider.setValue((double)element.getGreen());
            this.greenSlider.updateSlider();
            this.blueSlider.setValue((double)element.getBlue());
            this.blueSlider.updateSlider();
        } else {
            this.redSlider.setValue(255.0);
            this.redSlider.updateSlider();
            this.greenSlider.setValue(255.0);
            this.greenSlider.updateSlider();
            this.blueSlider.setValue(255.0);
            this.blueSlider.updateSlider();
        }
    }

    public void func_231175_as__() {
        WyNetwork.sendToServer(new CUpdateJollyRogerPacket(this.jollyRoger));
        super.func_231175_as__();
    }

    private int findIndex(List<JollyRogerElement> elements, JollyRogerElement element, PlayerEntity player) {
        for (int i = 0; i < elements.size(); ++i) {
            if (!elements.get(i).equals((Object)element)) continue;
            return i;
        }
        return -1;
    }

    public List<JollyRogerElement> getListFromType(JollyRogerElement.LayerType type) {
        if (type == JollyRogerElement.LayerType.BASE) {
            return this.allBases;
        }
        if (type == JollyRogerElement.LayerType.BACKGROUND) {
            return this.allBackgrounds;
        }
        if (type == JollyRogerElement.LayerType.DETAIL) {
            return this.allDetails;
        }
        return this.allBases;
    }

    public List<JollyRogerElement> getTotalElementsForType(PlayerEntity player, JollyRogerElement.LayerType type) {
        return this.allElements.stream().filter(reg -> reg.getLayerType() == type).collect(Collectors.toList());
    }

    public static void open(boolean isEditing, Crew crew, LinkedHashSet<JollyRogerElement> elements) {
        Minecraft.func_71410_x().func_147108_a((Screen)new JollyRogerCreatorScreen(isEditing, crew, elements));
    }
}

