/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.screens.extra.panels;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.awt.Color;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraftforge.client.gui.ScrollPanel;
import net.minecraftforge.fml.client.gui.GuiUtils;
import xyz.pixelatedw.mineminenomi.api.helpers.FactionHelper;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.packets.client.challenge.CSendChallengeInvitationPacket;
import xyz.pixelatedw.mineminenomi.screens.ChallengesScreen;
import xyz.pixelatedw.mineminenomi.wypi.WyNetwork;

public class ChallengeGroupSelectorPanel
extends ScrollPanel {
    private static final int ENTRY_HEIGHT = 55;
    private static final int ENTRY_WIDTH = 120;
    private static final int SETUP_TIME = 20;
    private final Color topColor;
    private static final Color BOTTOM_COLOR = new Color(0.0f, 0.0f, 0.0f, 0.8f);
    private final PlayerEntity player;
    private final ChallengesScreen parent;
    private final List<LivingEntity> nearbyGroupMembers;
    private int setupTime;

    public ChallengeGroupSelectorPanel(ChallengesScreen parent, PlayerEntity player, List<Integer> nearbyIds) {
        super(parent.getMinecraft(), 260, 170, parent.field_230709_l_ / 2 - 70, parent.field_230708_k_ / 2 - 46);
        this.player = player;
        this.parent = parent;
        this.setupTime = 20;
        this.topColor = FactionHelper.getFactionColor(EntityStatsCapability.get((LivingEntity)player));
        this.nearbyGroupMembers = nearbyIds.stream().map(id -> player.field_70170_p.func_73045_a(id.intValue())).filter(e -> e instanceof LivingEntity).map(e -> (LivingEntity)e).collect(Collectors.toList());
    }

    public boolean func_231048_c_(double p_mouseReleased_1_, double p_mouseReleased_3_, int p_mouseReleased_5_) {
        return true;
    }

    protected int getContentHeight() {
        return this.nearbyGroupMembers.size() * 27 + 55 - 25;
    }

    protected int getScrollAmount() {
        return 55;
    }

    protected void drawGradientRect(MatrixStack matrixStack, int left, int top, int right, int bottom, int color1, int color2) {
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        if (this.setupTime > 0) {
            --this.setupTime;
        } else {
            super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        }
    }

    protected void drawPanel(MatrixStack matrixStack, int entryRight, int relativeY, Tessellator tess, int mouseX, int mouseY) {
        int y = relativeY + 65;
        int x = this.parent.field_230708_k_ / 2 + 20;
        LivingEntity entity = this.findEntry(mouseX, mouseY);
        int row = 0;
        int xOffset = 0;
        int yOffset = 0;
        for (LivingEntity target : this.nearbyGroupMembers) {
            boolean isHovered;
            if (row == 2) {
                xOffset = 0;
                yOffset += 55;
                row = 0;
            }
            boolean bl = isHovered = entity != null && entity.equals((Object)target) && this.func_231047_b_(mouseX, mouseY);
            if (isHovered) {
                GuiUtils.drawGradientRect((Matrix4f)matrixStack.func_227866_c_().func_227870_a_(), (int)0, (int)(x - 60 + xOffset), (int)(relativeY + yOffset), (int)(x + 60 + xOffset), (int)(relativeY + yOffset + 55), (int)this.topColor.getRGB(), (int)BOTTOM_COLOR.getRGB());
                matrixStack.func_227860_a_();
                matrixStack.func_227861_a_(0.0, -2.0, 0.0);
            }
            if (y + yOffset > this.top + 55 && y + yOffset < this.bottom + 55) {
                this.parent.renderEntityBust(target, matrixStack, x + xOffset, y + 5 + yOffset);
            }
            if (isHovered) {
                matrixStack.func_227865_b_();
            }
            xOffset += 120;
            ++row;
        }
    }

    private LivingEntity findEntry(int mouseX, int mouseY) {
        double yOffset = (float)(mouseY - this.top - 4) + this.scrollDistance;
        double xOffset = mouseX - this.left - 6;
        if (yOffset <= 0.0) {
            return null;
        }
        if (xOffset <= 0.0) {
            return null;
        }
        int lineIdx = (int)(yOffset / 55.0);
        int rowIdx = (int)(xOffset / 120.0);
        if (rowIdx > 1) {
            return null;
        }
        int id = lineIdx * 2 + rowIdx;
        if (id < 0 || id >= this.nearbyGroupMembers.size()) {
            return null;
        }
        LivingEntity entry = this.nearbyGroupMembers.get(id);
        if (entry != null) {
            return entry;
        }
        return null;
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        LivingEntity entity = this.findEntry((int)mouseX, (int)mouseY);
        if (entity != null && this.func_231047_b_(mouseX, mouseY) && button == 0 && this.setupTime <= 0) {
            if (entity instanceof PlayerEntity) {
                WyNetwork.sendToServer(new CSendChallengeInvitationPacket((PlayerEntity)entity, this.parent.getSelectedChallenge().getCore(), this.parent.getSelectedMemberSlot()));
                this.parent.showGroupStep();
            } else {
                this.parent.setGroupMember(entity);
            }
            return true;
        }
        return super.func_231044_a_(mouseX, mouseY, button);
    }

    public boolean func_231047_b_(double mouseX, double mouseY) {
        return mouseX >= (double)this.left && mouseY >= (double)this.top && mouseX < (double)(this.left + this.width) && mouseY < (double)(this.top + this.height);
    }
}

