/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.world;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.mojang.serialization.Lifecycle;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import net.minecraft.client.world.DimensionRenderInfo;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.registry.MutableRegistry;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.SimpleRegistry;
import net.minecraft.world.Dimension;
import net.minecraft.world.DimensionType;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeManager;
import net.minecraft.world.border.IBorderListener;
import net.minecraft.world.border.WorldBorder;
import net.minecraft.world.chunk.listener.IChunkStatusListener;
import net.minecraft.world.gen.settings.DimensionGeneratorSettings;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.DerivedWorldInfo;
import net.minecraft.world.storage.IServerConfiguration;
import net.minecraft.world.storage.IServerWorldInfo;
import net.minecraft.world.storage.SaveFormat;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.Event;
import xyz.pixelatedw.mineminenomi.packets.server.SSyncDynDimensionsPacket;
import xyz.pixelatedw.mineminenomi.wypi.WyNetwork;

public class DynamicDimensionManager {
    private static final Set<RegistryKey<World>> VANILLA_WORLDS = ImmutableSet.of((Object)World.field_234918_g_, (Object)World.field_234919_h_, (Object)World.field_234920_i_);
    private static Set<RegistryKey<World>> pendingWorldsToUnregister = new HashSet<RegistryKey<World>>();

    public static ServerWorld getOrCreateWorld(MinecraftServer server, RegistryKey<World> worldKey, BiFunction<MinecraftServer, RegistryKey<Dimension>, Dimension> dimensionFactory) {
        Map map = server.forgeGetWorldMap();
        ServerWorld existingWorld = (ServerWorld)map.get(worldKey);
        if (existingWorld != null) {
            return existingWorld;
        }
        return DynamicDimensionManager.createAndRegisterWorldAndDimension(server, map, worldKey, dimensionFactory);
    }

    public static void markDimensionForUnregistration(MinecraftServer server, RegistryKey<World> WorldToRemove) {
        if (!VANILLA_WORLDS.contains(WorldToRemove)) {
            pendingWorldsToUnregister.add(WorldToRemove);
        }
    }

    public static Set<RegistryKey<World>> getWorldsPendingUnregistration() {
        return Collections.unmodifiableSet(pendingWorldsToUnregister);
    }

    @Deprecated
    public static void unregisterScheduledDimensions(MinecraftServer server) {
        Set<RegistryKey<World>> keysToRemove = pendingWorldsToUnregister;
        pendingWorldsToUnregister = new HashSet<RegistryKey<World>>();
        DimensionGeneratorSettings worldGenSettings = server.func_240793_aU_().func_230418_z_();
        HashSet<RegistryKey<World>> removedWorldKeys = new HashSet<RegistryKey<World>>();
        ServerWorld overworld = server.func_71218_a(World.field_234918_g_);
        for (RegistryKey<World> WorldKeyToRemove : keysToRemove) {
            ServerWorld removedWorld = (ServerWorld)server.forgeGetWorldMap().remove(WorldKeyToRemove);
            if (removedWorld == null) continue;
            for (ServerPlayerEntity player : Lists.newArrayList((Iterable)removedWorld.func_217369_A())) {
                RegistryKey respawnKey = player.func_241141_L_();
                if (keysToRemove.contains(respawnKey)) {
                    respawnKey = World.field_234918_g_;
                    player.func_242111_a(World.field_234918_g_, null, 0.0f, false, false);
                }
                if (respawnKey == null) {
                    respawnKey = World.field_234918_g_;
                }
                ServerWorld destinationWorld = server.func_71218_a(respawnKey);
                BlockPos destinationPos = player.func_241140_K_();
                if (destinationPos == null) {
                    destinationPos = destinationWorld.func_241135_u_();
                }
                float respawnAngle = player.func_242109_L();
                player.func_200619_a(destinationWorld, (double)destinationPos.func_177958_n(), (double)destinationPos.func_177956_o(), (double)destinationPos.func_177952_p(), respawnAngle, 0.0f);
            }
            removedWorld.func_217445_a(null, false, removedWorld.func_217402_u());
            MinecraftForge.EVENT_BUS.post((Event)new WorldEvent.Unload((IWorld)removedWorld));
            WorldBorder overworldBorder = overworld.func_175723_af();
            WorldBorder removedWorldBorder = removedWorld.func_175723_af();
            List listeners = overworldBorder.field_177758_a;
            IBorderListener targetListener = null;
            for (IBorderListener listener : listeners) {
                if (!(listener instanceof IBorderListener.Impl) || removedWorldBorder != ((IBorderListener.Impl)listener).field_219590_a) continue;
                targetListener = listener;
                break;
            }
            if (targetListener != null) {
                overworldBorder.removeListener(targetListener);
            }
            removedWorldKeys.add(WorldKeyToRemove);
        }
        if (!removedWorldKeys.isEmpty()) {
            SimpleRegistry oldRegistry = worldGenSettings.func_236224_e_();
            SimpleRegistry newRegistry = new SimpleRegistry(Registry.field_239700_af_, oldRegistry.func_241875_b());
            for (Map.Entry entry : oldRegistry.func_239659_c_()) {
                RegistryKey oldKey = (RegistryKey)entry.getKey();
                RegistryKey oldWorldKey = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)oldKey.func_240901_a_());
                Dimension dimension = (Dimension)entry.getValue();
                if (oldKey == null || dimension == null || removedWorldKeys.contains(oldWorldKey)) continue;
                Registry.func_218322_a((Registry)newRegistry, (ResourceLocation)oldKey.getRegistryName(), (Object)dimension);
            }
            worldGenSettings.field_236208_h_ = newRegistry;
            server.markWorldsDirty();
            WyNetwork.sendToAll(new SSyncDynDimensionsPacket((Set<RegistryKey<World>>)ImmutableSet.of(), removedWorldKeys));
        }
    }

    private static ServerWorld createAndRegisterWorldAndDimension(MinecraftServer server, Map<RegistryKey<World>, ServerWorld> map, RegistryKey<World> worldKey, BiFunction<MinecraftServer, RegistryKey<Dimension>, Dimension> dimensionFactory) {
        ServerWorld overworld = server.func_71218_a(World.field_234918_g_);
        RegistryKey dimensionKey = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239700_af_, (ResourceLocation)worldKey.func_240901_a_());
        Dimension dimension = dimensionFactory.apply(server, (RegistryKey<Dimension>)dimensionKey);
        IChunkStatusListener chunkProgressListener = server.field_213220_d.create(11);
        Executor executor = server.field_213217_au;
        SaveFormat.LevelSave anvilConverter = server.field_71310_m;
        IServerConfiguration worldData = server.func_240793_aU_();
        DimensionGeneratorSettings worldGenSettings = worldData.func_230418_z_();
        DerivedWorldInfo derivedWorldData = new DerivedWorldInfo(worldData, worldData.func_230407_G_());
        SimpleRegistry dimensionRegistry = worldGenSettings.func_236224_e_();
        if (!(dimensionRegistry instanceof MutableRegistry)) {
            throw new IllegalStateException("Unable to register dimension '" + dimensionKey.func_240901_a_() + "'! Registry not writable!");
        }
        ((MutableRegistry)dimensionRegistry).func_218381_a(dimensionKey, (Object)dimension, Lifecycle.stable());
        ServerWorld newWorld = new ServerWorld(server, executor, anvilConverter, (IServerWorldInfo)derivedWorldData, worldKey, (DimensionType)dimension.func_236059_a_().get(), chunkProgressListener, dimension.func_236064_c_(), worldGenSettings.func_236227_h_(), BiomeManager.func_235200_a_((long)worldGenSettings.func_236221_b_()), (List)ImmutableList.of(), false);
        overworld.func_175723_af().func_177737_a((IBorderListener)new IBorderListener.Impl(newWorld.func_175723_af()));
        map.put(worldKey, newWorld);
        server.markWorldsDirty();
        MinecraftForge.EVENT_BUS.post((Event)new WorldEvent.Load((IWorld)newWorld));
        WyNetwork.sendToAll(new SSyncDynDimensionsPacket((Set<RegistryKey<World>>)ImmutableSet.of(worldKey), (Set<RegistryKey<World>>)ImmutableSet.of()));
        return newWorld;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class ChallengeDimensionRenderInfo
    extends DimensionRenderInfo {
        public ChallengeDimensionRenderInfo() {
            super(Float.NaN, false, DimensionRenderInfo.FogType.NORMAL, false, false);
        }

        public Vector3d func_230494_a_(Vector3d p_230494_1_, float p_230494_2_) {
            return p_230494_1_.func_216372_d((double)(p_230494_2_ * 0.94f + 0.06f), (double)(p_230494_2_ * 0.94f + 0.06f), (double)(p_230494_2_ * 0.91f + 0.09f));
        }

        public boolean func_230493_a_(int p_230493_1_, int p_230493_2_) {
            return false;
        }
    }
}

