/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.world.features.structures.ghostship;

import java.util.Random;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.feature.structure.TemplateStructurePiece;
import net.minecraft.world.gen.feature.template.BlockIgnoreStructureProcessor;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;
import xyz.pixelatedw.mineminenomi.api.helpers.StructuresHelper;
import xyz.pixelatedw.mineminenomi.init.ModLootTables;
import xyz.pixelatedw.mineminenomi.init.ModStructures;

public class GhostShipPiece
extends TemplateStructurePiece {
    private ResourceLocation resourceLocation;
    private Rotation rotation;

    public GhostShipPiece(TemplateManager template, CompoundNBT nbt) {
        super(ModStructures.Pieces.GHOST_SHIP_PIECE, nbt);
        this.resourceLocation = new ResourceLocation(nbt.func_74779_i("Template"));
        this.rotation = Rotation.valueOf((String)nbt.func_74779_i("Rot"));
        this.build(template);
    }

    public GhostShipPiece(TemplateManager template, BlockPos pos, Rotation rot) {
        super(ModStructures.Pieces.GHOST_SHIP_PIECE, 0);
        this.rotation = rot;
        this.field_186178_c = pos;
        this.resourceLocation = new ResourceLocation("mineminenomi", "unaligned/ghost_ship");
        this.build(template);
    }

    protected void func_143011_b(CompoundNBT nbt) {
        super.func_143011_b(nbt);
        nbt.func_74778_a("Template", this.resourceLocation.toString());
        nbt.func_74778_a("Rot", this.rotation.name());
    }

    private void build(TemplateManager templateManager) {
        Template template = templateManager.func_200220_a(this.resourceLocation);
        PlacementSettings placementsettings = new PlacementSettings().func_186220_a(this.rotation).func_186214_a(Mirror.NONE).func_215222_a((StructureProcessor)BlockIgnoreStructureProcessor.field_215206_c);
        this.func_186173_a(template, this.field_186178_c, placementsettings);
    }

    protected void func_186175_a(String function, BlockPos pos, IServerWorld world, Random rand, MutableBoundingBox sbb) {
        if (function.equals("captain_chest")) {
            StructuresHelper.spawnLoot((IWorld)world, pos, ModLootTables.GHOST_SHIP_CAPTAIN_CHEST);
        }
        if (function.equals("supplies_chest")) {
            StructuresHelper.spawnLoot((IWorld)world, pos, ModLootTables.GHOST_SHIP_SUPPLIES_CHEST);
        }
        if (function.equals("mast_chest")) {
            StructuresHelper.spawnLoot((IWorld)world, pos, ModLootTables.GHOST_SHIP_CAPTAIN_CHEST);
        }
        if (function.equals("deck_spawn")) {
            StructuresHelper.spawnMobs((IWorld)world, pos, StructuresHelper.StructureFaction.PIRATE, StructuresHelper.StructureSpawnType.GRUNT, 5);
        }
        if (function.equals("captain_room_spawn")) {
            StructuresHelper.spawnMobs((IWorld)world, pos, StructuresHelper.StructureFaction.PIRATE, StructuresHelper.StructureSpawnType.BRUTE, 2);
        }
        if (function.equals("cannons_spawn")) {
            StructuresHelper.spawnMobs((IWorld)world, pos, StructuresHelper.StructureFaction.PIRATE, StructuresHelper.StructureSpawnType.GRUNT, 5);
        }
    }
}

