/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.world.features.structures.largebase.bandit;

import java.util.Random;
import net.minecraft.block.Blocks;
import net.minecraft.util.Rotation;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import xyz.pixelatedw.mineminenomi.api.helpers.StructuresHelper;
import xyz.pixelatedw.mineminenomi.config.CommonConfig;
import xyz.pixelatedw.mineminenomi.world.features.structures.OPStructure;
import xyz.pixelatedw.mineminenomi.world.features.structures.largebase.bandit.BanditLargeBasePiece;
import xyz.pixelatedw.mineminenomi.wypi.WyDebug;

public class BanditLargeBaseStructure
extends OPStructure<NoFeatureConfig> {
    public BanditLargeBaseStructure() {
        super(NoFeatureConfig.field_236558_a_);
    }

    @Override
    public boolean biomeCheck(BiomeLoadingEvent event) {
        if (event.getCategory() == Biome.Category.OCEAN) {
            return false;
        }
        if (event.getName() == null) {
            return false;
        }
        boolean canSpawn = CommonConfig.INSTANCE.canSpawnLargeBases();
        if (!canSpawn) {
            return false;
        }
        return event.getCategory() == Biome.Category.FOREST || event.getCategory() == Biome.Category.JUNGLE || event.getCategory() == Biome.Category.TAIGA;
    }

    @Override
    public StructuresHelper.StructureFaction getFaction() {
        return StructuresHelper.StructureFaction.BANDIT;
    }

    protected boolean isFeatureChunk(ChunkGenerator chunkGenerator, BiomeProvider biomeSource, long seed, SharedSeedRandom chunkRandom, int chunkX, int chunkZ, Biome biome, ChunkPos chunkPos, NoFeatureConfig featureConfig) {
        boolean isChance;
        boolean superFlag = super.func_230363_a_(chunkGenerator, biomeSource, seed, chunkRandom, chunkX, chunkZ, biome, chunkPos, featureConfig);
        boolean bl = isChance = chunkRandom.nextDouble() * 100.0 < CommonConfig.INSTANCE.getChanceForLargeBasesSpawn();
        return superFlag && isChance;
    }

    public GenerationStage.Decoration func_236396_f_() {
        return GenerationStage.Decoration.SURFACE_STRUCTURES;
    }

    public Structure.IStartFactory<NoFeatureConfig> func_214557_a() {
        return Start::new;
    }

    public static class Start
    extends StructureStart<NoFeatureConfig> {
        public Start(Structure<NoFeatureConfig> structure, int chunkX, int chunkZ, MutableBoundingBox mutableBoundingBox, int reference, long seed) {
            super(structure, chunkX, chunkZ, mutableBoundingBox, reference, seed);
        }

        public void generatePieces(DynamicRegistries dynamicRegistryManager, ChunkGenerator chunkGenerator, TemplateManager templateManager, int chunkX, int chunkZ, Biome biomeIn, NoFeatureConfig config) {
            Rotation rotation = Rotation.func_222466_a((Random)this.field_214631_d);
            int x0 = (chunkX << 4) + 7;
            int z0 = (chunkZ << 4) + 7;
            int x1 = (chunkX + 1 << 4) + 7;
            int z1 = (chunkZ + 2 << 4) + 7;
            int surfaceY = chunkGenerator.func_222529_a(x1, z1, Heightmap.Type.WORLD_SURFACE_WG);
            BlockPos blockpos = new BlockPos(x0, surfaceY, z0);
            this.field_75075_a.add(new BanditLargeBasePiece(templateManager, blockpos, rotation));
            this.func_202500_a();
            StructuresHelper.SPAWNED_STRUCTURES.add(blockpos);
            WyDebug.debug("Bandit Large Base spawned at: /tp " + ((StructurePiece)this.field_75075_a.get((int)0)).func_74874_b().field_78897_a + " ~ " + ((StructurePiece)this.field_75075_a.get((int)0)).func_74874_b().field_78896_c);
        }

        public void func_230366_a_(ISeedReader pLevel, StructureManager pStructureManager, ChunkGenerator pChunkGenerator, Random pRandom, MutableBoundingBox pBox, ChunkPos pChunkPos) {
            super.func_230366_a_(pLevel, pStructureManager, pChunkGenerator, pRandom, pBox, pChunkPos);
            int i = this.field_75074_b.field_78895_b;
            for (int j = pBox.field_78897_a; j <= pBox.field_78893_d; ++j) {
                for (int k = pBox.field_78896_c; k <= pBox.field_78892_f; ++k) {
                    BlockPos blockpos1;
                    BlockPos blockpos = new BlockPos(j, i, k);
                    if (pLevel.func_175623_d(blockpos) || !this.field_75074_b.func_175898_b((Vector3i)blockpos)) continue;
                    boolean flag = false;
                    for (StructurePiece structurepiece : this.field_75075_a) {
                        if (!structurepiece.func_74874_b().func_175898_b((Vector3i)blockpos)) continue;
                        flag = true;
                        break;
                    }
                    if (!flag) continue;
                    for (int l = i - 1; l > 1 && (pLevel.func_175623_d(blockpos1 = new BlockPos(j, l, k)) || pLevel.func_180495_p(blockpos1).func_185904_a().func_76224_d()); --l) {
                        pLevel.func_180501_a(blockpos1, Blocks.field_150346_d.func_176223_P(), 2);
                    }
                }
            }
        }
    }
}

