/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.torohealth.bars;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Quaternion;
import net.torocraft.torohealth.ToroHealth;
import net.torocraft.torohealth.ToroHealthClient;
import net.torocraft.torohealth.bars.BarState;
import net.torocraft.torohealth.bars.BarStates;
import net.torocraft.torohealth.config.Config;
import net.torocraft.torohealth.util.EntityUtil;

public class HealthBarRenderer {
    private static final ResourceLocation GUI_BARS_TEXTURES = new ResourceLocation("torohealth:textures/gui/bars.png");
    private static final int DARK_GRAY = -2139062017;
    private static final float FULL_SIZE = 40.0f;

    private static Config.InWorld getConfig() {
        return ToroHealth.CONFIG.inWorld;
    }

    public static void renderInWorld(MatrixStack matrix, LivingEntity entity) {
        if (Config.Mode.NONE.equals((Object)HealthBarRenderer.getConfig().mode)) {
            return;
        }
        if (Config.Mode.WHEN_HOLDING_WEAPON.equals((Object)HealthBarRenderer.getConfig().mode) && !ToroHealthClient.IS_HOLDING_WEAPON) {
            return;
        }
        Minecraft client = Minecraft.func_71410_x();
        if (client.field_71439_g == entity) {
            return;
        }
        if (entity.func_70032_d((Entity)client.field_71439_g) > ToroHealth.CONFIG.inWorld.distance) {
            return;
        }
        Quaternion camera = client.func_175598_ae().func_229098_b_();
        if (ToroHealth.CONFIG.inWorld.onlyWhenLookingAt && ToroHealthClient.HUD.getEntity() != entity) {
            return;
        }
        if (ToroHealth.CONFIG.inWorld.onlyWhenHurt && entity.func_110143_aJ() >= entity.func_110138_aP()) {
            return;
        }
        if (entity.func_70032_d(client.func_175606_aa()) > ToroHealth.CONFIG.inWorld.distance) {
            return;
        }
        float f = entity.func_213302_cg() + 0.5f;
        matrix.func_227860_a_();
        matrix.func_227861_a_(0.0, (double)f, 0.0);
        matrix.func_227863_a_(camera);
        matrix.func_227862_a_(-0.025f, -0.025f, 0.025f);
        RenderSystem.disableLighting();
        RenderSystem.enableDepthTest();
        RenderSystem.disableAlphaTest();
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
        RenderSystem.shadeModel((int)7425);
        HealthBarRenderer.render(matrix, entity, 0.0, 0.0, 40.0f, true);
        RenderSystem.shadeModel((int)7424);
        RenderSystem.disableBlend();
        RenderSystem.enableAlphaTest();
        matrix.func_227865_b_();
    }

    public static void render(MatrixStack matrix, LivingEntity entity, double x, double y, float width, boolean inWorld) {
        EntityUtil.Relation relation = EntityUtil.determineRelation((Entity)entity);
        int color = relation.equals((Object)EntityUtil.Relation.FRIEND) ? ToroHealth.CONFIG.bar.friendColor : ToroHealth.CONFIG.bar.foeColor;
        int color2 = relation.equals((Object)EntityUtil.Relation.FRIEND) ? ToroHealth.CONFIG.bar.friendColorSecondary : ToroHealth.CONFIG.bar.foeColorSecondary;
        BarState state = BarStates.getState(entity);
        float percent = Math.min(1.0f, state.health / entity.func_110138_aP());
        float percent2 = state.previousHealthDisplay / entity.func_110138_aP();
        int zOffset = 0;
        Matrix4f m4f = matrix.func_227866_c_().func_227870_a_();
        HealthBarRenderer.drawBar(m4f, x, y, width, 1.0f, -2139062017, zOffset++, inWorld);
        HealthBarRenderer.drawBar(m4f, x, y, width, percent2, color2, zOffset++, inWorld);
        HealthBarRenderer.drawBar(m4f, x, y, width, percent, color, zOffset, inWorld);
        if (!inWorld) {
            if (ToroHealth.CONFIG.bar.damageNumberType.equals((Object)Config.NumberType.CUMULATIVE)) {
                HealthBarRenderer.drawDamageNumber(matrix, state.lastDmgCumulative, x, y, width);
            } else if (ToroHealth.CONFIG.bar.damageNumberType.equals((Object)Config.NumberType.LAST)) {
                HealthBarRenderer.drawDamageNumber(matrix, state.lastDmg, x, y, width);
            }
        }
    }

    public static void drawDamageNumber(MatrixStack matrix, int dmg, double x, double y, float width) {
        int i = Math.abs(Math.round(dmg));
        if (i == 0) {
            return;
        }
        String s = Integer.toString(i);
        Minecraft minecraft = Minecraft.func_71410_x();
        int sw = minecraft.field_71466_p.func_78256_a(s);
        int color = dmg < 0 ? ToroHealth.CONFIG.particle.healColor : ToroHealth.CONFIG.particle.damageColor;
        minecraft.field_71466_p.func_238421_b_(matrix, s, (float)((int)(x + (double)(width / 2.0f) - (double)sw)), (float)((int)y + 5), color);
    }

    private static void drawBar(Matrix4f matrix4f, double x, double y, float width, float percent, int color, int zOffset, boolean inWorld) {
        float c = 0.00390625f;
        int u = 0;
        int v = 65;
        int uw = MathHelper.func_76123_f((float)(92.0f * percent));
        int vh = 5;
        double size = percent * width;
        double h = inWorld ? 4.0 : 6.0;
        float r = (float)(color >> 24 & 0xFF) / 255.0f;
        float g = (float)(color >> 16 & 0xFF) / 255.0f;
        float b = (float)(color >> 8 & 0xFF) / 255.0f;
        float a = (float)(color & 0xFF) / 255.0f;
        Minecraft.func_71410_x().func_110434_K().func_110577_a(GUI_BARS_TEXTURES);
        RenderSystem.color4f((float)r, (float)g, (float)b, (float)a);
        float half = width / 2.0f;
        float zOffsetAmount = inWorld ? -0.1f : 0.1f;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_227888_a_(matrix4f, (float)((double)(-half) + x), (float)y, (float)zOffset * zOffsetAmount).func_225583_a_((float)u * c, (float)v * c).func_181675_d();
        buffer.func_227888_a_(matrix4f, (float)((double)(-half) + x), (float)(h + y), (float)zOffset * zOffsetAmount).func_225583_a_((float)u * c, (float)(v + vh) * c).func_181675_d();
        buffer.func_227888_a_(matrix4f, (float)((double)(-half) + size + x), (float)(h + y), (float)zOffset * zOffsetAmount).func_225583_a_((float)(u + uw) * c, (float)(v + vh) * c).func_181675_d();
        buffer.func_227888_a_(matrix4f, (float)((double)(-half) + size + x), (float)y, (float)zOffset * zOffsetAmount).func_225583_a_((float)(u + uw) * c, (float)v * c).func_181675_d();
        tessellator.func_78381_a();
    }
}

