/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.MineMineNoMi3.abilities;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MovingObjectPosition;
import xyz.pixelatedw.MineMineNoMi3.MainConfig;
import xyz.pixelatedw.MineMineNoMi3.api.WyHelper;
import xyz.pixelatedw.MineMineNoMi3.api.abilities.Ability;
import xyz.pixelatedw.MineMineNoMi3.api.math.WyMathHelper;
import xyz.pixelatedw.MineMineNoMi3.api.network.WyNetworkHelper;
import xyz.pixelatedw.MineMineNoMi3.entities.abilityprojectiles.BakuProjectiles;
import xyz.pixelatedw.MineMineNoMi3.helpers.DevilFruitsHelper;
import xyz.pixelatedw.MineMineNoMi3.lists.ListAttributes;
import xyz.pixelatedw.MineMineNoMi3.packets.PacketParticles;

public class BakuAbilities {
    public static Ability[] abilitiesArray = new Ability[]{new BakuMunch(), new BeroCannon(), new BakuTsuiho()};
    private static Block[] bakuPermittedBlocks = new Block[]{Blocks.field_150349_c, Blocks.field_150346_d, Blocks.field_150362_t, Blocks.field_150361_u, Blocks.field_150344_f, Blocks.field_150364_r, Blocks.field_150363_s, Blocks.field_150348_b, Blocks.field_150347_e, Blocks.field_150354_m, Blocks.field_150322_A, Blocks.field_150351_n, Blocks.field_150403_cj, Blocks.field_150435_aG, Blocks.field_150405_ch, Blocks.field_150434_aF, Blocks.field_150330_I};

    public static class BakuMunch
    extends Ability {
        public BakuMunch() {
            super(ListAttributes.BAKU_MUNCH);
        }

        @Override
        public void use(EntityPlayer player) {
            MovingObjectPosition mop;
            if (!this.isOnCooldown && (mop = WyHelper.rayTraceBlocks((Entity)player)) != null && player.func_70011_f((double)mop.field_72311_b, (double)mop.field_72312_c, (double)mop.field_72309_d) < 5.0 && MainConfig.enableGriefing) {
                boolean i = false;
                for (int x = -2; x < 2; ++x) {
                    for (int y = 0; y < 3; ++y) {
                        for (int z = -2; z < 2; ++z) {
                            int posX = mop.field_72311_b + x;
                            int posY = mop.field_72312_c - y;
                            int posZ = mop.field_72309_d + z;
                            Block tempBlock = player.field_70170_p.func_147439_a(posX, posY, posZ);
                            if (!DevilFruitsHelper.placeBlockIfAllowed(player.field_70170_p, posX, posY, posZ, Blocks.field_150350_a, "all", "restricted", "ignore liquids")) continue;
                            player.field_71071_by.func_70441_a(new ItemStack(tempBlock));
                            WyNetworkHelper.sendToAllAround(new PacketParticles("bakuMunch", posX, posY, posZ), player.field_71093_bK, posX, posY, posZ, 128.0);
                        }
                    }
                }
                super.use(player);
            }
        }
    }

    public static class BeroCannon
    extends Ability {
        public BeroCannon() {
            super(ListAttributes.BERO_CANNON);
        }

        @Override
        public void use(EntityPlayer player) {
            if (!this.isOnCooldown) {
                ArrayList<ItemStack> projectiles = new ArrayList<ItemStack>();
                for (ItemStack item : player.field_71071_by.field_70462_a) {
                    if (item == null || !(item.func_77973_b() instanceof ItemBlock) || !Arrays.stream(bakuPermittedBlocks).anyMatch(p -> p == ((ItemBlock)item.func_77973_b()).field_150939_a)) continue;
                    projectiles.add(item);
                }
                if (!projectiles.isEmpty()) {
                    this.projectile = new BakuProjectiles.BeroCannon(player.field_70170_p, (EntityLivingBase)player, this.attr);
                    ItemStack s = projectiles.stream().findFirst().orElse(null);
                    if (s.field_77994_a > 1) {
                        --s.field_77994_a;
                    } else {
                        WyHelper.removeStackFromInventory(player, s);
                    }
                    super.use(player);
                } else {
                    WyHelper.sendMsgToPlayer(player, "You don't have any blocks to use");
                }
            }
        }
    }

    public static class BakuTsuiho
    extends Ability {
        private List<ItemStack> projectiles = new ArrayList<ItemStack>();
        private List<Block> loadedProjectiles = new ArrayList<Block>();

        public BakuTsuiho() {
            super(ListAttributes.BAKU_TSUIHO);
        }

        @Override
        public void startCharging(EntityPlayer player) {
            this.loadedProjectiles.clear();
            this.projectiles.clear();
            for (ItemStack item : player.field_71071_by.field_70462_a) {
                if (item == null || !(item.func_77973_b() instanceof ItemBlock) || !Arrays.stream(bakuPermittedBlocks).anyMatch(p -> p == ((ItemBlock)item.func_77973_b()).field_150939_a)) continue;
                this.projectiles.add(item);
            }
            if (!this.projectiles.isEmpty()) {
                super.startCharging(player);
            } else {
                WyHelper.sendMsgToPlayer(player, "You don't have any blocks to use");
            }
        }

        @Override
        public void duringCharging(EntityPlayer player, int chargeTime) {
            if (!this.projectiles.isEmpty()) {
                ItemStack s;
                if (chargeTime % 20 == 0 && (s = (ItemStack)this.projectiles.stream().findAny().orElse(null)) != null) {
                    if (s.field_77994_a > 1) {
                        --s.field_77994_a;
                    } else {
                        WyHelper.removeStackFromInventory(player, s);
                        this.projectiles.remove(s);
                    }
                    this.loadedProjectiles.add(((ItemBlock)s.func_77973_b()).field_150939_a);
                }
            } else {
                this.endCharging(player);
            }
        }

        @Override
        public void endCharging(EntityPlayer player) {
            for (int j = 0; j < this.loadedProjectiles.size(); ++j) {
                BakuProjectiles.BeroCannon beroCannon = new BakuProjectiles.BeroCannon(player.field_70170_p, (EntityLivingBase)player, ListAttributes.BERO_CANNON);
                int distanceBetweenProjectiles = this.loadedProjectiles.size() / 7;
                beroCannon.func_70012_b(player.field_70165_t + WyMathHelper.randomWithRange(-distanceBetweenProjectiles, distanceBetweenProjectiles) + player.field_70170_p.field_73012_v.nextDouble(), player.field_70163_u + 0.3 + WyMathHelper.randomWithRange(0, distanceBetweenProjectiles) + player.field_70170_p.field_73012_v.nextDouble(), player.field_70161_v + WyMathHelper.randomWithRange(-distanceBetweenProjectiles, distanceBetweenProjectiles) + player.field_70170_p.field_73012_v.nextDouble(), 0.0f, 0.0f);
                player.field_70170_p.func_72838_d((Entity)beroCannon);
            }
            super.endCharging(player);
        }
    }

    public static class BakuBakuFactory
    extends Ability {
        public BakuBakuFactory() {
            super(ListAttributes.BAKU_BAKU_FACTORY);
        }

        @Override
        public void use(EntityPlayer player) {
            super.use(player);
        }
    }
}

