/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.MineMineNoMi3.abilities;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import xyz.pixelatedw.MineMineNoMi3.Values;
import xyz.pixelatedw.MineMineNoMi3.api.WyHelper;
import xyz.pixelatedw.MineMineNoMi3.api.abilities.Ability;
import xyz.pixelatedw.MineMineNoMi3.api.network.WyNetworkHelper;
import xyz.pixelatedw.MineMineNoMi3.data.ExtendedEntityData;
import xyz.pixelatedw.MineMineNoMi3.entities.abilityprojectiles.BaneProjectiles;
import xyz.pixelatedw.MineMineNoMi3.lists.ListAttributes;
import xyz.pixelatedw.MineMineNoMi3.packets.PacketPlayer;

public class BaneAbilities {
    public static Ability[] abilitiesArray;

    private static void motion(String c, double x, double y, double z, EntityPlayer p) {
        WyNetworkHelper.sendTo(new PacketPlayer("motion" + c, x, y, z), (EntityPlayerMP)p);
    }

    static {
        Values.abilityWebAppExtraParams.put("springhopper", new String[]{"desc", "Turning the userps legs into springs, which launches them into the air."});
        Values.abilityWebAppExtraParams.put("springdeathknock", new String[]{"desc", "By turning the user's arm into a spring and compressing it, they can launch a powerful punch."});
        Values.abilityWebAppExtraParams.put("springsnipe", new String[]{"desc", "Turning the user's forelegs into springs, they can launch themselves directly at the opponent."});
        abilitiesArray = new Ability[]{new SpringDeathKnock(), new SpringSnipe(), new SpringHopper()};
    }

    public static class SpringHopper
    extends Ability {
        public SpringHopper() {
            super(ListAttributes.SPRING_HOPPER);
        }

        @Override
        public void endCharging(EntityPlayer player) {
            WyHelper.Direction dir = WyHelper.get8Directions((Entity)player);
            if (player.field_70122_E) {
                BaneAbilities.motion("+", 0.0, 1.7, 0.0, player);
            } else {
                BaneAbilities.motion("+", 0.0, 1.502857142857143, 0.0, player);
            }
            if (dir == WyHelper.Direction.NORTH) {
                BaneAbilities.motion("-", 0.0, 0.0, 1.9, player);
            }
            if (dir == WyHelper.Direction.NORTH_WEST) {
                BaneAbilities.motion("-", 1.9, 0.0, 1.9, player);
            }
            if (dir == WyHelper.Direction.SOUTH) {
                BaneAbilities.motion("+", 0.0, 0.0, 1.9, player);
            }
            if (dir == WyHelper.Direction.NORTH_EAST) {
                BaneAbilities.motion("-", 0.0, 0.0, 1.9, player);
                BaneAbilities.motion("+", 1.9, 0.0, 0.0, player);
            }
            if (dir == WyHelper.Direction.WEST) {
                BaneAbilities.motion("-", 1.9, 0.0, 0.0, player);
            }
            if (dir == WyHelper.Direction.SOUTH_WEST) {
                BaneAbilities.motion("+", 0.0, 0.0, 1.9, player);
                BaneAbilities.motion("-", 1.9, 0.0, 0.0, player);
            }
            if (dir == WyHelper.Direction.EAST) {
                BaneAbilities.motion("+", 1.9, 0.0, 0.0, player);
            }
            if (dir == WyHelper.Direction.SOUTH_EAST) {
                BaneAbilities.motion("+", 1.9, 0.0, 1.9, player);
            }
            super.endCharging(player);
        }
    }

    public static class SpringSnipe
    extends Ability {
        public SpringSnipe() {
            super(ListAttributes.SPRING_SNIPE);
        }

        @Override
        public void endCharging(EntityPlayer player) {
            double mX = (double)(-MathHelper.func_76126_a((float)(player.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(player.field_70125_A / 180.0f * (float)Math.PI))) * 0.4;
            double mZ = (double)(MathHelper.func_76134_b((float)(player.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(player.field_70125_A / 180.0f * (float)Math.PI))) * 0.4;
            double mY = (double)(-MathHelper.func_76126_a((float)((player.field_70125_A + 0.0f) / 180.0f * (float)Math.PI))) * 0.4;
            double f2 = MathHelper.func_76133_a((double)(mX * mX + mY * mY + mZ * mZ));
            mX /= f2;
            mY /= f2;
            mZ /= f2;
            mX += player.field_70170_p.field_73012_v.nextGaussian() * (double)0.0075f * 1.0;
            mY += player.field_70170_p.field_73012_v.nextGaussian() * (double)0.0075f * 1.0;
            mZ += player.field_70170_p.field_73012_v.nextGaussian() * (double)0.0075f * 1.0;
            BaneAbilities.motion("=", mX *= 8.0, mY *= 3.0, mZ *= 8.0, player);
            super.endCharging(player);
        }

        @Override
        public void duringCooldown(EntityPlayer player, int currentCooldown) {
            ExtendedEntityData props = ExtendedEntityData.get((EntityLivingBase)player);
            if (currentCooldown / 20 > ListAttributes.SPRING_SNIPE.getAbilityCooldown() / 20 - 3) {
                for (EntityLivingBase e : WyHelper.getEntitiesNear((Entity)player, 1.6)) {
                    e.func_70097_a(DamageSource.func_76365_a((EntityPlayer)player), 8.0f * props.getDamageMultiplier());
                }
            }
        }
    }

    public static class SpringDeathKnock
    extends Ability {
        public SpringDeathKnock() {
            super(ListAttributes.SPRING_DEATH_KNOCK);
        }

        @Override
        public void use(EntityPlayer player) {
            this.projectile = new BaneProjectiles.SpringDeathKnock(player.field_70170_p, (EntityLivingBase)player, this.attr);
            super.use(player);
        }
    }
}

