/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.MineMineNoMi3.abilities;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import xyz.pixelatedw.MineMineNoMi3.Values;
import xyz.pixelatedw.MineMineNoMi3.api.WyHelper;
import xyz.pixelatedw.MineMineNoMi3.api.abilities.Ability;
import xyz.pixelatedw.MineMineNoMi3.entities.abilityprojectiles.BariProjectiles;
import xyz.pixelatedw.MineMineNoMi3.lists.ListAttributes;
import xyz.pixelatedw.MineMineNoMi3.lists.ListMisc;

public class BariAbilities {
    public static Ability[] abilitiesArray;

    static {
        Values.abilityWebAppExtraParams.put("barrier", new String[]{"desc", "The user creates an impenetrable wall that shields them from attacks."});
        Values.abilityWebAppExtraParams.put("barrierball", new String[]{"desc", "The user creates a spherical barrier around them, shielding them from attacks."});
        Values.abilityWebAppExtraParams.put("barriercrash", new String[]{"desc", "Launches a barrier towards the opponent, smashing it against them."});
        Values.abilityWebAppExtraParams.put("baribarinopistol", new String[]{"desc", "The user shapes a barrier aroud their fist, which greatly increases the power of a punch."});
        Values.abilityWebAppExtraParams.put("barrierbilitystairs", new String[]{"desc", "By shaping the Barrier, the user can create stairs."});
        abilitiesArray = new Ability[]{new Barrier(), new BarrierBall(), new BarrierCrash(), new BariBariNoPistol(), new BarrierbilityStairs()};
    }

    public static class Barrier
    extends Ability {
        private List<int[]> blockList = new ArrayList<int[]>();

        public Barrier() {
            super(ListAttributes.BARRIER);
        }

        @Override
        public void passive(EntityPlayer player) {
            if (!this.isOnCooldown) {
                if (this.blockList.isEmpty()) {
                    if (WyHelper.get4Directions((Entity)player) == WyHelper.Direction.NORTH) {
                        this.blockList = WyHelper.createFilledCube(player.field_70170_p, player.field_70165_t, player.field_70163_u, player.field_70161_v - 3.0, new int[]{3, 4, 1}, ListMisc.Barrier, "air", "foliage", "nogrief");
                    }
                    if (WyHelper.get4Directions((Entity)player) == WyHelper.Direction.SOUTH) {
                        this.blockList = WyHelper.createFilledCube(player.field_70170_p, player.field_70165_t, player.field_70163_u, player.field_70161_v + 3.0, new int[]{3, 4, 1}, ListMisc.Barrier, "air", "foliage", "nogrief");
                    }
                    if (WyHelper.get4Directions((Entity)player) == WyHelper.Direction.EAST) {
                        this.blockList = WyHelper.createFilledCube(player.field_70170_p, player.field_70165_t + 3.0, player.field_70163_u, player.field_70161_v, new int[]{1, 4, 3}, ListMisc.Barrier, "air", "foliage", "nogrief");
                    }
                    if (WyHelper.get4Directions((Entity)player) == WyHelper.Direction.WEST) {
                        this.blockList = WyHelper.createFilledCube(player.field_70170_p, player.field_70165_t - 3.0, player.field_70163_u, player.field_70161_v, new int[]{1, 4, 3}, ListMisc.Barrier, "air", "foliage", "nogrief");
                    }
                }
                super.passive(player);
            }
        }

        @Override
        public void endPassive(EntityPlayer player) {
            for (int[] blockPos : this.blockList) {
                if (player.field_70170_p.func_147439_a(blockPos[0], blockPos[1], blockPos[2]) != ListMisc.Barrier) continue;
                player.field_70170_p.func_147449_b(blockPos[0], blockPos[1], blockPos[2], Blocks.field_150350_a);
            }
            this.blockList = new ArrayList<int[]>();
            this.startCooldown();
            this.startExtUpdate(player);
        }
    }

    public static class BarrierBall
    extends Ability {
        private List<int[]> blockList = new ArrayList<int[]>();

        public BarrierBall() {
            super(ListAttributes.BARRIER_BALL);
        }

        @Override
        public void passive(EntityPlayer player) {
            if (!this.isOnCooldown) {
                if (this.blockList.isEmpty()) {
                    MovingObjectPosition mop = WyHelper.rayTraceBlocks((Entity)player);
                    World world = player.field_70170_p;
                    if (player.func_70093_af()) {
                        this.blockList.addAll(WyHelper.createEmptySphere(world, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v, 5, ListMisc.Barrier, "air", "foliage", "nogrief"));
                    } else if (mop != null && world.func_147439_a(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d) != Blocks.field_150350_a) {
                        this.blockList.addAll(WyHelper.createEmptySphere(world, mop.field_72311_b, mop.field_72312_c, mop.field_72309_d, 5, ListMisc.Barrier, "air", "foliage", "nogrief"));
                    }
                }
                super.passive(player);
            }
        }

        @Override
        public void endPassive(EntityPlayer player) {
            for (int[] blockPos : this.blockList) {
                if (player.field_70170_p.func_147439_a(blockPos[0], blockPos[1], blockPos[2]) != ListMisc.Barrier) continue;
                player.field_70170_p.func_147449_b(blockPos[0], blockPos[1], blockPos[2], Blocks.field_150350_a);
            }
            this.blockList = new ArrayList<int[]>();
            this.startCooldown();
            this.startExtUpdate(player);
        }
    }

    public static class BarrierCrash
    extends Ability {
        public BarrierCrash() {
            super(ListAttributes.BARRIER_CRASH);
        }

        @Override
        public void use(EntityPlayer player) {
            this.projectile = new BariProjectiles.BarrierCrash(player.field_70170_p, (EntityLivingBase)player, this.attr);
            super.use(player);
        }
    }

    public static class BariBariNoPistol
    extends Ability {
        public BariBariNoPistol() {
            super(ListAttributes.BARI_BARI_NO_PISTOL);
        }

        @Override
        public void hitEntity(EntityPlayer player, EntityLivingBase target) {
            if (!this.isOnCooldown) {
                super.hitEntity(player, target);
                target.func_70097_a(DamageSource.func_76365_a((EntityPlayer)player), 10.0f);
            }
        }
    }

    public static class BarrierbilityStairs
    extends Ability {
        private List<int[]> blockList = new ArrayList<int[]>();

        public BarrierbilityStairs() {
            super(ListAttributes.BARRIERBILITY_STAIRS);
        }

        public void fillBlocksList(List<int[]> entityList) {
            this.blockList.addAll(entityList);
        }

        @Override
        public void passive(EntityPlayer player) {
            if (!this.isOnCooldown) {
                if (this.blockList.isEmpty()) {
                    player.field_70170_p.func_72838_d((Entity)new BariProjectiles.BarrierbilityStairs(player.field_70170_p, (EntityLivingBase)player, this.attr));
                }
                super.passive(player);
            }
        }

        @Override
        public void endPassive(EntityPlayer player) {
            for (int[] blockPos : this.blockList) {
                if (player.field_70170_p.func_147439_a(blockPos[0], blockPos[1], blockPos[2]) != ListMisc.Barrier) continue;
                player.field_70170_p.func_147449_b(blockPos[0], blockPos[1], blockPos[2], Blocks.field_150350_a);
            }
            this.blockList = new ArrayList<int[]>();
        }
    }
}

