/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.MineMineNoMi3.abilities;

import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import xyz.pixelatedw.MineMineNoMi3.Values;
import xyz.pixelatedw.MineMineNoMi3.api.WyHelper;
import xyz.pixelatedw.MineMineNoMi3.api.abilities.Ability;
import xyz.pixelatedw.MineMineNoMi3.api.network.WyNetworkHelper;
import xyz.pixelatedw.MineMineNoMi3.data.ExtendedEntityData;
import xyz.pixelatedw.MineMineNoMi3.entities.abilityprojectiles.CyborgProjectiles;
import xyz.pixelatedw.MineMineNoMi3.lists.ListAttributes;
import xyz.pixelatedw.MineMineNoMi3.packets.PacketSync;

public class CyborgAbilities {
    public static final Ability FRESH_FIRE;
    public static final Ability COLA_OVERDRIVE;
    public static final Ability RADICAL_BEAM;
    public static final Ability STRONG_RIGHT;
    public static final Ability COUP_DE_VENT;
    public static Ability[] abilitiesArray;

    static {
        Values.abilityWebAppExtraParams.put("freshfire", new String[]{"desc", "The user heats up and breathes fire like a flamethrower at the opponent.", "dorikiRequiredForCyborgs", "0"});
        Values.abilityWebAppExtraParams.put("colaoverdrive", new String[]{"desc", "The user absorbs all of their cola at once to boost their physical abilities.", "dorikiRequiredForCyborgs", "0"});
        Values.abilityWebAppExtraParams.put("radicalbeam", new String[]{"desc", "After charging, the user launches a powerful beam of energy at the opponent.", "dorikiRequiredForCyborgs", "0"});
        Values.abilityWebAppExtraParams.put("strongright", new String[]{"desc", "The user punches the opponent with a metal fist.", "dorikiRequiredForCyborgs", "0"});
        Values.abilityWebAppExtraParams.put("coupdevent", new String[]{"desc", "Launches a powerful blast of compressed air that blows the opponent away.", "dorikiRequiredForCyborgs", "0"});
        FRESH_FIRE = new FreshFire();
        COLA_OVERDRIVE = new ColaOverdrive();
        RADICAL_BEAM = new RadicalBeam();
        STRONG_RIGHT = new StrongRight();
        COUP_DE_VENT = new CoupDeVent();
        abilitiesArray = new Ability[]{FRESH_FIRE, COLA_OVERDRIVE, RADICAL_BEAM, STRONG_RIGHT, COUP_DE_VENT};
    }

    public static class ColaOverdrive
    extends Ability {
        public ColaOverdrive() {
            super(ListAttributes.COLA_OVERDRIVE);
        }

        @Override
        public void use(EntityPlayer player) {
            ExtendedEntityData props = ExtendedEntityData.get((EntityLivingBase)player);
            if (!this.isOnCooldown && props.getCola() > 0) {
                double r = props.getCola() / props.getMaxCola() * 100;
                props.setCola(0);
                player.func_70606_j((float)((double)player.func_110143_aJ() + r / 100.0 * player.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111125_b()));
                WyNetworkHelper.sendTo(new PacketSync(props), (EntityPlayerMP)player);
                super.use(player);
            } else if (props.getCola() <= 0) {
                WyHelper.sendMsgToPlayer(player, "Not enough Cola !");
            }
        }
    }

    public static class FreshFire
    extends Ability {
        public FreshFire() {
            super(ListAttributes.FRESH_FIRE);
        }

        @Override
        public void use(EntityPlayer player) {
            ExtendedEntityData props = ExtendedEntityData.get((EntityLivingBase)player);
            if (!this.isOnCooldown && props.getCola() >= 5) {
                for (int i = 0; i < 100; ++i) {
                    double offsetX = ((double)new Random().nextInt(50) + 1.0 - 25.0) / 20.0;
                    double offsetY = ((double)new Random().nextInt(50) + 1.0 - 25.0) / 20.0;
                    double offsetZ = ((double)new Random().nextInt(50) + 1.0 - 25.0) / 20.0;
                    this.projectile = new CyborgProjectiles.FreshFire(player.field_70170_p, (EntityLivingBase)player, this.attr);
                    this.projectile.func_70012_b(player.field_70165_t + offsetX, player.field_70163_u + 2.0 + offsetY, player.field_70161_v + offsetZ, player.field_70726_aT, player.field_71109_bG);
                    player.field_70170_p.func_72838_d((Entity)this.projectile);
                }
                props.alterCola(-5);
                WyNetworkHelper.sendTo(new PacketSync(props), (EntityPlayerMP)player);
                super.use(player);
            } else if (props.getCola() < 5) {
                WyHelper.sendMsgToPlayer(player, "Not enough Cola !");
            }
        }
    }

    public static class RadicalBeam
    extends Ability {
        public RadicalBeam() {
            super(ListAttributes.RADICAL_BEAM);
        }

        @Override
        public void use(EntityPlayer player) {
            ExtendedEntityData props = ExtendedEntityData.get((EntityLivingBase)player);
            if (!player.field_70170_p.field_72995_K) {
                if (!this.isOnCooldown && props.getCola() >= 15) {
                    this.projectile = new CyborgProjectiles.RadicalBeam(player.field_70170_p, (EntityLivingBase)player, this.attr);
                    player.field_70170_p.func_72838_d((Entity)this.projectile);
                    props.alterCola(-15);
                    WyNetworkHelper.sendTo(new PacketSync(props), (EntityPlayerMP)player);
                    super.use(player);
                } else if (props.getCola() < 15) {
                    WyHelper.sendMsgToPlayer(player, "Not enough Cola !");
                }
            }
        }
    }

    public static class StrongRight
    extends Ability {
        public StrongRight() {
            super(ListAttributes.STRONG_RIGHT);
        }

        @Override
        public void use(EntityPlayer player) {
            ExtendedEntityData props = ExtendedEntityData.get((EntityLivingBase)player);
            if (!player.field_70170_p.field_72995_K) {
                if (!this.isOnCooldown && props.getCola() >= 10) {
                    this.projectile = new CyborgProjectiles.StrongRight(player.field_70170_p, (EntityLivingBase)player, this.attr);
                    player.field_70170_p.func_72838_d((Entity)this.projectile);
                    props.alterCola(-10);
                    WyNetworkHelper.sendTo(new PacketSync(props), (EntityPlayerMP)player);
                    super.use(player);
                } else if (props.getCola() < 10) {
                    WyHelper.sendMsgToPlayer(player, "Not enough Cola !");
                }
            }
        }
    }

    public static class CoupDeVent
    extends Ability {
        public CoupDeVent() {
            super(ListAttributes.COUP_DE_VENT);
        }

        @Override
        public void startCharging(EntityPlayer player) {
            ExtendedEntityData props = ExtendedEntityData.get((EntityLivingBase)player);
            if (!this.isOnCooldown && props.getCola() >= 25) {
                super.startCharging(player);
            } else if (props.getCola() < 25) {
                WyHelper.sendMsgToPlayer(player, "Not enough Cola !");
            }
        }

        @Override
        public void duringCharging(EntityPlayer player, int currentCharge) {
            player.func_70690_d(new PotionEffect(Potion.field_76421_d.field_76415_H, 10, 1000));
            player.func_70690_d(new PotionEffect(Potion.field_76419_f.field_76415_H, 10, 1000));
        }

        @Override
        public void endCharging(EntityPlayer player) {
            ExtendedEntityData props = ExtendedEntityData.get((EntityLivingBase)player);
            props.alterCola(-25);
            this.isCharging = false;
            this.isOnCooldown = true;
            for (int i = 0; i < 100; ++i) {
                double offsetX = ((double)new Random().nextInt(50) + 1.0 - 25.0) / 20.0;
                double offsetY = ((double)new Random().nextInt(50) + 1.0 - 25.0) / 20.0;
                double offsetZ = ((double)new Random().nextInt(50) + 1.0 - 25.0) / 20.0;
                this.projectile = new CyborgProjectiles.CoupDeVent(player.field_70170_p, (EntityLivingBase)player, this.attr);
                this.projectile.func_70012_b(player.field_70165_t + offsetX, player.field_70163_u + 2.0 + offsetY, player.field_70161_v + offsetZ, player.field_70726_aT, player.field_71109_bG);
                player.field_70170_p.func_72838_d((Entity)this.projectile);
            }
            WyNetworkHelper.sendTo(new PacketSync(props), (EntityPlayerMP)player);
            this.startCooldown();
            this.startExtUpdate(player);
        }
    }
}

