/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.MineMineNoMi3.abilities;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityPotion;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import xyz.pixelatedw.MineMineNoMi3.api.WyHelper;
import xyz.pixelatedw.MineMineNoMi3.api.abilities.Ability;
import xyz.pixelatedw.MineMineNoMi3.api.abilities.extra.AbilityExplosion;
import xyz.pixelatedw.MineMineNoMi3.api.math.WyMathHelper;
import xyz.pixelatedw.MineMineNoMi3.api.network.WyNetworkHelper;
import xyz.pixelatedw.MineMineNoMi3.lists.ListAttributes;
import xyz.pixelatedw.MineMineNoMi3.lists.ListMisc;
import xyz.pixelatedw.MineMineNoMi3.packets.PacketBrokenItemParticles;
import xyz.pixelatedw.MineMineNoMi3.packets.PacketParticles;

public class DoctorAbilities {
    public static final Ability FIRST_AID = new FirstAid();
    public static final Ability MEDIC_BAG_EXPLOSION = new MedicBagExplosion();
    public static final Ability FAILED_EXPERIMENT = new FailedExperiment();
    public static Ability[] abilitiesArray = new Ability[]{FIRST_AID, MEDIC_BAG_EXPLOSION, FAILED_EXPERIMENT};

    public static class FirstAid
    extends Ability {
        public FirstAid() {
            super(ListAttributes.FIRST_AID);
        }

        @Override
        public void hitEntity(EntityPlayer player, EntityLivingBase target) {
            if (player.func_82169_q(2) == null || player.func_82169_q(2).func_77973_b() != ListMisc.MedicBag) {
                WyHelper.sendMsgToPlayer(player, "You need a medic bag equipped to use this ability !");
                return;
            }
            target.func_70606_j(target.func_110143_aJ() + 10.0f);
            AbilityExplosion explosion = WyHelper.newExplosion((Entity)player, target.field_70165_t, target.field_70163_u, target.field_70161_v, 2.0);
            explosion.setExplosionSound(false);
            explosion.setDamageOwner(false);
            explosion.setDestroyBlocks(false);
            explosion.setDamageEntities(false);
            explosion.setSmokeParticles("firstAid");
            explosion.doExplosion();
            int damage = player.func_82169_q(2).func_77960_j() + 10 <= player.func_82169_q(2).func_77958_k() ? 10 : player.func_82169_q(2).func_77958_k() - player.func_82169_q(2).func_77960_j();
            player.func_82169_q(2).func_77972_a(damage, (EntityLivingBase)player);
            if (player.func_82169_q(2).func_77960_j() >= player.func_82169_q(2).func_77958_k()) {
                WyNetworkHelper.sendTo(new PacketBrokenItemParticles(player.func_82169_q(2)), (EntityPlayerMP)player);
                WyHelper.removeStackFromArmorSlots(player, player.func_82169_q(2));
            }
            super.hitEntity(player, target);
        }
    }

    public static class MedicBagExplosion
    extends Ability {
        public MedicBagExplosion() {
            super(ListAttributes.MEDIC_BAG_EXPLOSION);
        }

        @Override
        public void use(EntityPlayer player) {
            if (this.isOnCooldown()) {
                return;
            }
            if (player.func_82169_q(2) == null || player.func_82169_q(2).func_77973_b() != ListMisc.MedicBag) {
                WyHelper.sendMsgToPlayer(player, "You need a medic bag equipped to use this ability !");
                return;
            }
            player.func_70606_j(player.func_110138_aP());
            for (EntityLivingBase entity : WyHelper.getEntitiesNear((Entity)player, 10.0)) {
                int effect = (int)WyMathHelper.randomWithRange(0, 6);
                switch (effect) {
                    case 0: {
                        entity.func_70690_d(new PotionEffect(Potion.field_76440_q.field_76415_H, 200, 1));
                    }
                    case 1: {
                        entity.func_70690_d(new PotionEffect(Potion.field_76431_k.field_76415_H, 200, 1));
                    }
                    case 2: {
                        entity.func_70690_d(new PotionEffect(Potion.field_76419_f.field_76415_H, 200, 1));
                    }
                    case 3: {
                        entity.func_70690_d(new PotionEffect(Potion.field_76421_d.field_76415_H, 200, 1));
                    }
                    case 4: {
                        entity.func_70690_d(new PotionEffect(Potion.field_76436_u.field_76415_H, 200, 1));
                    }
                    case 5: {
                        entity.func_70690_d(new PotionEffect(Potion.field_82731_v.field_76415_H, 200, 1));
                    }
                    case 6: {
                        entity.func_70690_d(new PotionEffect(Potion.field_76437_t.field_76415_H, 200, 1));
                    }
                }
            }
            WyNetworkHelper.sendToAllAround(new PacketParticles("medicBagExplosion", (EntityLivingBase)player), player.field_71093_bK, player.field_70165_t, player.field_70163_u, player.field_70161_v, 128.0);
            int damage = player.func_82169_q(2).func_77960_j() + 100 <= player.func_82169_q(2).func_77958_k() ? 100 : player.func_82169_q(2).func_77958_k() - player.func_82169_q(2).func_77960_j();
            player.func_82169_q(2).func_77972_a(damage, (EntityLivingBase)player);
            if (player.func_82169_q(2).func_77960_j() >= player.func_82169_q(2).func_77958_k()) {
                WyNetworkHelper.sendTo(new PacketBrokenItemParticles(player.func_82169_q(2)), (EntityPlayerMP)player);
                WyHelper.removeStackFromArmorSlots(player, player.func_82169_q(2));
            }
            super.use(player);
        }
    }

    public static class FailedExperiment
    extends Ability {
        public FailedExperiment() {
            super(ListAttributes.FAILED_EXPERIMENT);
        }

        @Override
        public void startCharging(EntityPlayer player) {
            if (this.isOnCooldown()) {
                return;
            }
            if (player.func_82169_q(2) == null || player.func_82169_q(2).func_77973_b() != ListMisc.MedicBag) {
                WyHelper.sendMsgToPlayer(player, "You need a medic bag equipped to use this ability !");
                return;
            }
            super.startCharging(player);
        }

        @Override
        public void endCharging(EntityPlayer player) {
            EntityPotion entitypotion = new EntityPotion(player.field_70170_p, (EntityLivingBase)player, 32732);
            entitypotion.field_70125_A -= -20.0f;
            int potionType = (int)WyMathHelper.randomWithRange(0, 3);
            switch (potionType) {
                case 0: {
                    entitypotion.func_82340_a(32698);
                    break;
                }
                case 1: {
                    entitypotion.func_82340_a(32660);
                    break;
                }
                case 2: {
                    entitypotion.func_82340_a(32696);
                }
            }
            player.field_70170_p.func_72838_d((Entity)entitypotion);
            int damage = player.func_82169_q(2).func_77960_j() + 10 <= player.func_82169_q(2).func_77958_k() ? 10 : player.func_82169_q(2).func_77958_k() - player.func_82169_q(2).func_77960_j();
            player.func_82169_q(2).func_77972_a(damage, (EntityLivingBase)player);
            if (player.func_82169_q(2).func_77960_j() >= player.func_82169_q(2).func_77958_k()) {
                WyNetworkHelper.sendTo(new PacketBrokenItemParticles(player.func_82169_q(2)), (EntityPlayerMP)player);
                WyHelper.removeStackFromArmorSlots(player, player.func_82169_q(2));
            }
            super.endCharging(player);
        }
    }
}

