/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.MineMineNoMi3.abilities;

import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import xyz.pixelatedw.MineMineNoMi3.Values;
import xyz.pixelatedw.MineMineNoMi3.api.WyHelper;
import xyz.pixelatedw.MineMineNoMi3.api.abilities.Ability;
import xyz.pixelatedw.MineMineNoMi3.api.network.WyNetworkHelper;
import xyz.pixelatedw.MineMineNoMi3.data.ExtendedEntityData;
import xyz.pixelatedw.MineMineNoMi3.entities.abilityprojectiles.DokuProjectiles;
import xyz.pixelatedw.MineMineNoMi3.helpers.DevilFruitsHelper;
import xyz.pixelatedw.MineMineNoMi3.lists.ListAttributes;
import xyz.pixelatedw.MineMineNoMi3.lists.ListMisc;
import xyz.pixelatedw.MineMineNoMi3.packets.PacketNewAABB;
import xyz.pixelatedw.MineMineNoMi3.packets.PacketParticles;
import xyz.pixelatedw.MineMineNoMi3.packets.PacketSync;
import xyz.pixelatedw.MineMineNoMi3.packets.PacketSyncInfo;

public class DokuAbilities {
    public static Ability[] abilitiesArray;

    static {
        Values.abilityWebAppExtraParams.put("hydra", new String[]{"desc", "Launches a dragon made out of liqiud poison at the opponent."});
        Values.abilityWebAppExtraParams.put("chloroball", new String[]{"desc", "The user spits a bubble made of poison towards the enemy, which leaves poison on the ground."});
        Values.abilityWebAppExtraParams.put("dokufugu", new String[]{"desc", "Shoots multiple poisonous bullets at the opponent."});
        Values.abilityWebAppExtraParams.put("dokugumo", new String[]{"desc", "Creates a dense cloud of poisonous smoke, which moves along with the user and poisons and blinds everyone inside."});
        Values.abilityWebAppExtraParams.put("venomroad", new String[]{"desc", "The user fires a Hydra at the target location and transports there through its path."});
        Values.abilityWebAppExtraParams.put("venomdemon", new String[]{"desc", "The user coats himself in layers of strong corrosive venom, becoming a Venom Demon and leaving a highly poisonou trail."});
        abilitiesArray = new Ability[]{new Hydra(), new ChloroBall(), new DokuFugu(), new VenomRoad(), new DokuGumo(), new VenomDemon()};
    }

    public static class Hydra
    extends Ability {
        public Hydra() {
            super(ListAttributes.HYDRA);
        }

        @Override
        public void use(EntityPlayer player) {
            this.projectile = new DokuProjectiles.Hydra(player.field_70170_p, (EntityLivingBase)player, this.attr);
            super.use(player);
        }
    }

    public static class ChloroBall
    extends Ability {
        public ChloroBall() {
            super(ListAttributes.CHLORO_BALL);
        }

        @Override
        public void use(EntityPlayer player) {
            this.projectile = new DokuProjectiles.ChloroBall(player.field_70170_p, (EntityLivingBase)player, this.attr);
            super.use(player);
        }
    }

    public static class VenomRoad
    extends Ability {
        public VenomRoad() {
            super(ListAttributes.VENOM_ROAD);
        }

        @Override
        public void use(EntityPlayer player) {
            this.projectile = new DokuProjectiles.VenomRoad(player.field_70170_p, (EntityLivingBase)player, this.attr);
            super.use(player);
        }
    }

    public static class DokuFugu
    extends Ability {
        public DokuFugu() {
            super(ListAttributes.DOKU_FUGU);
        }

        @Override
        public void use(EntityPlayer player) {
            this.projectile = new DokuProjectiles.ChloroBall(player.field_70170_p, (EntityLivingBase)player, this.attr);
            super.use(player);
        }
    }

    public static class VenomDemon
    extends Ability {
        public VenomDemon() {
            super(ListAttributes.VENOM_DEMON);
        }

        @Override
        public void startPassive(EntityPlayer player) {
            ExtendedEntityData props = ExtendedEntityData.get((EntityLivingBase)player);
            if (props.getZoanPoint().isEmpty()) {
                props.setZoanPoint("n/a");
            }
            WyNetworkHelper.sendTo(new PacketNewAABB(1.5f, 3.5f), (EntityPlayerMP)player);
            props.setZoanPoint("venomDemon");
            WyNetworkHelper.sendTo(new PacketSync(props), (EntityPlayerMP)player);
            WyNetworkHelper.sendToAll(new PacketSyncInfo(player.getDisplayName(), props));
        }

        @Override
        public void duringPassive(EntityPlayer player, int passiveTimer) {
            if (passiveTimer >= 800) {
                this.setPassiveActive(false);
                this.setCooldownActive(true);
                this.endPassive(player);
            }
            if (!WyHelper.isBlockNearby((EntityLivingBase)player, 2, new Block[]{Blocks.field_150355_j, Blocks.field_150358_i, ListMisc.KairosekiOre, ListMisc.KairosekiBlock, ListMisc.KairosekiBars})) {
                for (int x = -1; x < 1; ++x) {
                    for (int z = -1; z < 1; ++z) {
                        DevilFruitsHelper.placeBlockIfAllowed(player.field_70170_p, (int)player.field_70165_t + x, (int)player.field_70163_u, (int)player.field_70161_v + z, ListMisc.DemonPoison, "core", "foliage", "air");
                    }
                }
            }
            WyNetworkHelper.sendToAllAround(new PacketParticles("venomDemon", (EntityLivingBase)player), player.field_71093_bK, player.field_70165_t, player.field_70163_u, player.field_70161_v, 128.0);
        }

        @Override
        public void endPassive(EntityPlayer player) {
            ExtendedEntityData props = ExtendedEntityData.get((EntityLivingBase)player);
            WyNetworkHelper.sendTo(new PacketNewAABB(0.6f, 1.8f), (EntityPlayerMP)player);
            props.setZoanPoint("n/a");
            WyNetworkHelper.sendTo(new PacketSync(props), (EntityPlayerMP)player);
            WyNetworkHelper.sendToAll(new PacketSyncInfo(player.getDisplayName(), props));
            this.startCooldown();
            this.startExtUpdate(player);
        }
    }

    public static class DokuGumo
    extends Ability {
        public DokuGumo() {
            super(ListAttributes.DOKU_GUMO);
        }

        @Override
        public void duringPassive(EntityPlayer player, int passiveTimer) {
            if (passiveTimer > 400) {
                this.setPassiveActive(false);
                this.startCooldown();
                this.startExtUpdate(player);
            }
            WyNetworkHelper.sendToAllAround(new PacketParticles("dokuGumo", (EntityLivingBase)player), player.field_71093_bK, player.field_70165_t, player.field_70163_u, player.field_70161_v, 128.0);
            for (EntityLivingBase enemy : WyHelper.getEntitiesNear((Entity)player, 10.0)) {
                if (!enemy.func_82165_m(Potion.field_76440_q.field_76415_H)) {
                    enemy.func_70690_d(new PotionEffect(Potion.field_76440_q.field_76415_H, 200, 0));
                }
                if (!enemy.func_82165_m(Potion.field_76436_u.field_76415_H)) {
                    enemy.func_70690_d(new PotionEffect(Potion.field_76436_u.field_76415_H, 200, 1));
                }
                if (enemy.func_82165_m(Potion.field_76437_t.field_76415_H)) continue;
                enemy.func_70690_d(new PotionEffect(Potion.field_76437_t.field_76415_H, 200, 1));
            }
        }

        @Override
        public void endPassive(EntityPlayer player) {
            this.startCooldown();
            this.startExtUpdate(player);
        }
    }
}

