/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.MineMineNoMi3.abilities;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import xyz.pixelatedw.MineMineNoMi3.MainConfig;
import xyz.pixelatedw.MineMineNoMi3.Values;
import xyz.pixelatedw.MineMineNoMi3.api.WyHelper;
import xyz.pixelatedw.MineMineNoMi3.api.abilities.Ability;
import xyz.pixelatedw.MineMineNoMi3.entities.abilityprojectiles.DoruProjectiles;
import xyz.pixelatedw.MineMineNoMi3.lists.ListAttributes;
import xyz.pixelatedw.MineMineNoMi3.lists.ListMisc;

public class DoruAbilities {
    public static Ability[] abilitiesArray;

    static {
        Values.abilityWebAppExtraParams.put("candlewall", new String[]{"desc", "Creates a wax wall to protect the user."});
        Values.abilityWebAppExtraParams.put("candlehouse", new String[]{"desc", "Creates a big house-like structure made of wax, to protect the user."});
        Values.abilityWebAppExtraParams.put("dorudoruartsmori", new String[]{"desc", "The user fires a harpoon made of wax at the opponent."});
        Values.abilityWebAppExtraParams.put("dorudoruartsken", new String[]{"desc", "The user uses hardened wax to create a sword."});
        Values.abilityWebAppExtraParams.put("candlelock", new String[]{"desc", "Traps the opponent's feet in hardened wax, which makes them unable to move."});
        abilitiesArray = new Ability[]{new DoruDoruArtsMori(), new DoruDoruArtsKen(), new CandleWall(), new CandleHouse(), new CandleLock()};
    }

    public static class DoruDoruArtsMori
    extends Ability {
        public DoruDoruArtsMori() {
            super(ListAttributes.DORU_DORU_ARTS_MORI);
        }

        @Override
        public void use(EntityPlayer player) {
            this.projectile = new DoruProjectiles.DoruDoruArtsMori(player.field_70170_p, (EntityLivingBase)player, this.attr);
            super.use(player);
        }
    }

    public static class CandleWall
    extends Ability {
        public CandleWall() {
            super(ListAttributes.CANDLE_WALL);
        }

        @Override
        public void use(EntityPlayer player) {
            if (!this.isOnCooldown) {
                if (MainConfig.enableGriefing) {
                    if (WyHelper.get4Directions((Entity)player) == WyHelper.Direction.NORTH) {
                        WyHelper.createFilledCube(player.field_70170_p, player.field_70165_t, player.field_70163_u, player.field_70161_v - 3.0, new int[]{3, 4, 1}, ListMisc.WaxBlock, "air", "foliage");
                    }
                    if (WyHelper.get4Directions((Entity)player) == WyHelper.Direction.SOUTH) {
                        WyHelper.createFilledCube(player.field_70170_p, player.field_70165_t, player.field_70163_u, player.field_70161_v + 3.0, new int[]{3, 4, 1}, ListMisc.WaxBlock, "air", "foliage");
                    }
                    if (WyHelper.get4Directions((Entity)player) == WyHelper.Direction.EAST) {
                        WyHelper.createFilledCube(player.field_70170_p, player.field_70165_t + 3.0, player.field_70163_u, player.field_70161_v, new int[]{1, 4, 3}, ListMisc.WaxBlock, "air", "foliage");
                    }
                    if (WyHelper.get4Directions((Entity)player) == WyHelper.Direction.WEST) {
                        WyHelper.createFilledCube(player.field_70170_p, player.field_70165_t - 3.0, player.field_70163_u, player.field_70161_v, new int[]{1, 4, 3}, ListMisc.WaxBlock, "air", "foliage");
                    }
                }
                super.use(player);
            }
        }
    }

    public static class CandleHouse
    extends Ability {
        public CandleHouse() {
            super(ListAttributes.CANDLE_HOUSE);
        }

        @Override
        public void use(EntityPlayer player) {
            if (!this.isOnCooldown) {
                if (MainConfig.enableGriefing) {
                    int z;
                    int i;
                    for (int y = 0; y <= 3; ++y) {
                        for (i = 0; i < 1; ++i) {
                            for (z = -5; z < 5; ++z) {
                                player.field_70170_p.func_147449_b((int)player.field_70165_t + 6 - i, (int)player.field_70163_u + y, (int)player.field_70161_v - z, ListMisc.WaxBlock);
                            }
                        }
                        for (i = 0; i < 1; ++i) {
                            for (z = -5; z < 5; ++z) {
                                player.field_70170_p.func_147449_b((int)player.field_70165_t - 5 - i, (int)player.field_70163_u + y, (int)player.field_70161_v - z, ListMisc.WaxBlock);
                            }
                        }
                        for (i = -5; i < 5; ++i) {
                            for (z = 0; z < 1; ++z) {
                                player.field_70170_p.func_147449_b((int)player.field_70165_t - i, (int)player.field_70163_u + y, (int)player.field_70161_v + 6 - z, ListMisc.WaxBlock);
                            }
                        }
                        for (i = -5; i < 5; ++i) {
                            for (z = 0; z < 1; ++z) {
                                player.field_70170_p.func_147449_b((int)player.field_70165_t - i, (int)player.field_70163_u + y, (int)player.field_70161_v - 5 - z, ListMisc.WaxBlock);
                            }
                        }
                    }
                    for (int x = -5; x < 5; ++x) {
                        for (i = 0; i < 1; ++i) {
                            for (z = -5; z < 5; ++z) {
                                player.field_70170_p.func_147449_b((int)player.field_70165_t - x, (int)player.field_70163_u + 4 + i, (int)player.field_70161_v - z, ListMisc.WaxBlock);
                            }
                        }
                    }
                }
                super.use(player);
            }
        }
    }

    public static class DoruDoruArtsKen
    extends Ability {
        public DoruDoruArtsKen() {
            super(ListAttributes.DORU_DORU_ARTS_KEN);
        }

        @Override
        public void startPassive(EntityPlayer player) {
            if (player.field_71071_by.func_70448_g() == null) {
                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, new ItemStack((Item)ListMisc.DoruDoruArtsKen));
            } else {
                WyHelper.sendMsgToPlayer(player, "Cannot equip " + this.getAttribute().getAttributeName() + " while holding another item in hand !");
                this.passive(player);
            }
        }

        @Override
        public void endPassive(EntityPlayer player) {
            player.field_71071_by.func_146027_a((Item)ListMisc.DoruDoruArtsKen, -1);
        }
    }

    public static class CandleLock
    extends Ability {
        public CandleLock() {
            super(ListAttributes.CANDLE_LOCK);
        }

        @Override
        public void use(EntityPlayer player) {
            this.projectile = new DoruProjectiles.CandleLock(player.field_70170_p, (EntityLivingBase)player, this.attr);
            super.use(player);
        }
    }
}

