/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.MineMineNoMi3.abilities;

import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import xyz.pixelatedw.MineMineNoMi3.Values;
import xyz.pixelatedw.MineMineNoMi3.api.WyHelper;
import xyz.pixelatedw.MineMineNoMi3.api.abilities.Ability;
import xyz.pixelatedw.MineMineNoMi3.api.network.WyNetworkHelper;
import xyz.pixelatedw.MineMineNoMi3.entities.abilityprojectiles.FishKarateProjectiles;
import xyz.pixelatedw.MineMineNoMi3.lists.ListAttributes;
import xyz.pixelatedw.MineMineNoMi3.packets.PacketParticles;

public class FishKarateAbilities {
    public static final Ability UCHIMIZU;
    public static final Ability MURASAME;
    public static final Ability KACHIAGE_HAISOKU;
    public static final Ability SAMEHADA_SHOTEI;
    public static final Ability KARAKUSAGAWARA_SEIKEN;
    public static Ability[] abilitiesArray;

    static {
        Values.abilityWebAppExtraParams.put("uchimizu", new String[]{"desc", "The user hurls big and fast water droplets at the opponent.", "dorikiRequiredForFishman", "800"});
        Values.abilityWebAppExtraParams.put("murasame", new String[]{"desc", "The user fires densely compressed shark-shaped waterbullet at the opponent.", "dorikiRequiredForFishman", "2000"});
        Values.abilityWebAppExtraParams.put("samehadashotei", new String[]{"desc", "The user concentrates their power to their palms, protecting themselves from attacks.", "dorikiRequiredForFishman", "3000"});
        Values.abilityWebAppExtraParams.put("karakusagawaraseiken", new String[]{"desc", "The user punches the air, which sends a shockwave through water vapor in the air.", "dorikiRequiredForFishman", "7500"});
        Values.abilityWebAppExtraParams.put("kachiagehaisoku", new String[]{"desc", "The user delivers a powerful kick to the opponent's chin.", "dorikiRequiredForFishman", "2500"});
        UCHIMIZU = new Uchimizu();
        MURASAME = new Murasame();
        KACHIAGE_HAISOKU = new KachiageHaisoku();
        SAMEHADA_SHOTEI = new SamehadaShotei();
        KARAKUSAGAWARA_SEIKEN = new KarakusagawaraSeiken();
        abilitiesArray = new Ability[]{UCHIMIZU, MURASAME, SAMEHADA_SHOTEI, KARAKUSAGAWARA_SEIKEN, KACHIAGE_HAISOKU};
    }

    public static class KarakusagawaraSeiken
    extends Ability {
        public KarakusagawaraSeiken() {
            super(ListAttributes.KARAKUSAGAWARA_SEIKEN);
        }

        @Override
        public void use(EntityPlayer player) {
            if (!this.isOnCooldown) {
                for (EntityLivingBase elb : WyHelper.getEntitiesNear((Entity)player, 10.0)) {
                    elb.func_70097_a(DamageSource.func_76365_a((EntityPlayer)player), 20.0f);
                }
                super.use(player);
            }
        }
    }

    public static class SamehadaShotei
    extends Ability {
        public SamehadaShotei() {
            super(ListAttributes.SAMEHADA_SHOTEI);
        }

        @Override
        public void startPassive(EntityPlayer player) {
            super.startPassive(player);
        }

        @Override
        public void duringPassive(EntityPlayer player, int passiveTimer) {
            WyNetworkHelper.sendToAllAround(new PacketParticles("samehada", (EntityLivingBase)player), player.field_71093_bK, player.field_70165_t, player.field_70163_u, player.field_70161_v, 128.0);
            if (passiveTimer > 800) {
                this.setPassiveActive(false);
                this.startCooldown();
                this.startExtUpdate(player);
                super.endPassive(player);
            }
        }

        @Override
        public void endPassive(EntityPlayer player) {
            this.startCooldown();
            this.startExtUpdate(player);
        }
    }

    public static class KachiageHaisoku
    extends Ability {
        public KachiageHaisoku() {
            super(ListAttributes.KACHIAGE_HAISOKU);
        }

        @Override
        public void hitEntity(EntityPlayer player, EntityLivingBase target) {
            super.hitEntity(player, target);
            int damage = 10;
            if (player.func_70055_a(Material.field_151586_h)) {
                damage = 40;
            }
            target.func_70097_a(DamageSource.func_76365_a((EntityPlayer)player), (float)damage);
        }
    }

    public static class Murasame
    extends Ability {
        public Murasame() {
            super(ListAttributes.MURASAME);
        }

        @Override
        public void use(EntityPlayer player) {
            this.projectile = new FishKarateProjectiles.Soshark(player.field_70170_p, (EntityLivingBase)player, this.attr);
            super.use(player);
        }
    }

    public static class Uchimizu
    extends Ability {
        public Uchimizu() {
            super(ListAttributes.UCHIMIZU);
        }

        @Override
        public void use(EntityPlayer player) {
            this.projectile = new FishKarateProjectiles.Uchimizu(player.field_70170_p, (EntityLivingBase)player, this.attr);
            super.use(player);
        }
    }
}

