/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.MineMineNoMi3.abilities;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import xyz.pixelatedw.MineMineNoMi3.MainConfig;
import xyz.pixelatedw.MineMineNoMi3.Values;
import xyz.pixelatedw.MineMineNoMi3.abilities.HakiAbilities;
import xyz.pixelatedw.MineMineNoMi3.api.WyHelper;
import xyz.pixelatedw.MineMineNoMi3.api.abilities.Ability;
import xyz.pixelatedw.MineMineNoMi3.api.abilities.AbilityProjectile;
import xyz.pixelatedw.MineMineNoMi3.api.abilities.extra.AbilityProperties;
import xyz.pixelatedw.MineMineNoMi3.api.math.WyMathHelper;
import xyz.pixelatedw.MineMineNoMi3.api.network.WyNetworkHelper;
import xyz.pixelatedw.MineMineNoMi3.data.ExtendedEntityData;
import xyz.pixelatedw.MineMineNoMi3.entities.abilityprojectiles.GomuProjectiles;
import xyz.pixelatedw.MineMineNoMi3.lists.ListAttributes;
import xyz.pixelatedw.MineMineNoMi3.lists.ListExtraAttributes;
import xyz.pixelatedw.MineMineNoMi3.packets.PacketParticles;
import xyz.pixelatedw.MineMineNoMi3.packets.PacketSync;
import xyz.pixelatedw.MineMineNoMi3.packets.PacketSyncInfo;

public class GomuAbilities {
    public static Ability[] abilitiesArray;

    static {
        Values.abilityWebAppExtraParams.put("gomugomunopistol", new String[]{"desc", "The user stretches their arm to hit the opponent."});
        Values.abilityWebAppExtraParams.put("gomugomunobazooka", new String[]{"desc", "The user stretches their arms to send the opponent flying by hitting them with both palms"});
        Values.abilityWebAppExtraParams.put("gearsecond", new String[]{"desc", "By speding up their blood flow, the user gains strength, speed and mobility."});
        Values.abilityWebAppExtraParams.put("gearthird", new String[]{"desc", "By blowing air and inflating their body, the user's attacks get bigger and gain incredible strength."});
        Values.abilityWebAppExtraParams.put("gearforth", new String[]{"desc", "The user inflates their muscle structure to tremendously increase the power of their attacks."});
        abilitiesArray = new Ability[]{new GomuGomuNoPistol(), new GomuGomuNoBazooka(), new GomuGomuNoRocket(), new GomuGomuNoGatling(), new GearSecond(), new GearThird(), new GearForth()};
    }

    public static class GomuGomuNoPistol
    extends Ability {
        public GomuGomuNoPistol() {
            super(ListAttributes.GOMU_GOMU_NO_PISTOL);
        }

        @Override
        public void use(EntityPlayer player) {
            ExtendedEntityData props = ExtendedEntityData.get((EntityLivingBase)player);
            switch (props.getGear()) {
                case 1: {
                    if (MainConfig.enableAnimeScreaming) {
                        this.attr.setAbilityDisplayName("Gomu Gomu no Pistol");
                    }
                    this.projectile = new GomuProjectiles.GomuGomuNoPistol(player.field_70170_p, (EntityLivingBase)player, ListExtraAttributes.GOMU_GOMU_NO_PISTOL);
                    this.attr.setAbilityCooldown(8.0);
                    this.attr.setProjectileDamage(20.0f);
                    break;
                }
                case 2: {
                    if (MainConfig.enableAnimeScreaming) {
                        this.attr.setAbilityDisplayName("Gomu Gomu no Jet Pistol");
                    }
                    this.projectile = new GomuProjectiles.GomuGomuNoJetPistol(player.field_70170_p, (EntityLivingBase)player, ListExtraAttributes.GOMU_GOMU_NO_JET_PISTOL);
                    this.attr.setAbilityCooldown(5.0);
                    this.attr.setProjectileDamage(40.0f);
                    break;
                }
                case 3: {
                    if (MainConfig.enableAnimeScreaming) {
                        this.attr.setAbilityDisplayName("Gomu Gomu no Elephant Gun");
                    }
                    this.projectile = new GomuProjectiles.GomuGomuNoElephantGun(player.field_70170_p, (EntityLivingBase)player, ListExtraAttributes.GOMU_GOMU_NO_ELEPHANT_GUN);
                    this.attr.setAbilityCooldown(15.0);
                    this.attr.setProjectileDamage(65.0f);
                    break;
                }
                case 4: {
                    if (MainConfig.enableAnimeScreaming) {
                        this.attr.setAbilityDisplayName("Gomu Gomu no Kong Gun");
                    }
                    this.projectile = new GomuProjectiles.GomuGomuNoKongGun(player.field_70170_p, (EntityLivingBase)player, ListExtraAttributes.GOMU_GOMU_NO_KONG_GUN);
                    this.attr.setAbilityCooldown(30.0);
                    this.attr.setProjectileDamage(120.0f);
                }
            }
            super.use(player);
        }
    }

    public static class GomuGomuNoBazooka
    extends Ability {
        public GomuGomuNoBazooka() {
            super(ListAttributes.GOMU_GOMU_NO_BAZOOKA);
        }

        @Override
        public void startCharging(EntityPlayer player) {
            ExtendedEntityData props = ExtendedEntityData.get((EntityLivingBase)player);
            if (MainConfig.enableAnimeScreaming) {
                switch (props.getGear()) {
                    case 1: {
                        this.attr.setAbilityDisplayName("Gomu Gomu no Bazooka");
                        break;
                    }
                    case 2: {
                        this.attr.setAbilityDisplayName("Gomu Gomu no Jet Bazooka");
                        this.attr.setProjectileDamage(60.0f);
                        break;
                    }
                    case 3: {
                        this.attr.setAbilityDisplayName("Gomu Gomu no Grizzly Magnum");
                        this.attr.setProjectileDamage(75.0f);
                        break;
                    }
                    case 4: {
                        this.attr.setAbilityDisplayName("Gomu Gomu no Leo Bazooka");
                        this.attr.setProjectileDamage(160.0f);
                    }
                }
            }
            super.startCharging(player);
        }

        @Override
        public void endCharging(EntityPlayer player) {
            ExtendedEntityData props = ExtendedEntityData.get((EntityLivingBase)player);
            switch (props.getGear()) {
                case 1: {
                    this.projectile = new GomuProjectiles.GomuGomuNoBazooka(player.field_70170_p, (EntityLivingBase)player, ListExtraAttributes.GOMU_GOMU_NO_BAZOOKA);
                    this.attr.setAbilityCooldown(12.0);
                    this.attr.setProjectileDamage(40.0f);
                    this.attr.setAbilityCharges(18);
                    break;
                }
                case 2: {
                    this.projectile = new GomuProjectiles.GomuGomuNoJetBazooka(player.field_70170_p, (EntityLivingBase)player, ListExtraAttributes.GOMU_GOMU_NO_JET_BAZOOKA);
                    this.attr.setAbilityCooldown(6.0);
                    this.attr.setAbilityCharges(13);
                    this.attr.setProjectileDamage(40.0f);
                    break;
                }
                case 3: {
                    this.projectile = new GomuProjectiles.GomuGomuNoGrizzlyMagnum(player.field_70170_p, (EntityLivingBase)player, ListExtraAttributes.GOMU_GOMU_NO_GRIZZLY_MAGNUM);
                    this.attr.setAbilityCooldown(20.0);
                    this.attr.setAbilityCharges(40);
                    this.attr.setProjectileDamage(40.0f);
                    break;
                }
                case 4: {
                    this.projectile = new GomuProjectiles.GomuGomuNoLeoBazooka(player.field_70170_p, (EntityLivingBase)player, ListExtraAttributes.GOMU_GOMU_NO_LEO_BAZOOKA);
                    this.attr.setAbilityCooldown(30.0);
                    this.attr.setProjectileDamage(40.0f);
                    this.attr.setAbilityCharges(40);
                }
            }
            super.endCharging(player);
        }
    }

    public static class GomuGomuNoRocket
    extends Ability {
        public GomuGomuNoRocket() {
            super(ListAttributes.GOMU_GOMU_NO_ROCKET);
        }

        @Override
        public void use(EntityPlayer player) {
            this.projectile = new GomuProjectiles.GomuGomuNoRocket(player.field_70170_p, (EntityLivingBase)player, ListAttributes.GOMU_GOMU_NO_ROCKET);
            super.use(player);
        }
    }

    public static class GomuGomuNoGatling
    extends Ability {
        public GomuGomuNoGatling() {
            super(ListAttributes.GOMU_GOMU_NO_GATLING);
        }

        @Override
        public void use(EntityPlayer player) {
            if (!this.isOnCooldown) {
                ExtendedEntityData props = ExtendedEntityData.get((EntityLivingBase)player);
                int type = 0;
                int projectileSpace = 3;
                switch (props.getGear()) {
                    case 1: {
                        type = 0;
                        if (MainConfig.enableAnimeScreaming) {
                            this.attr.setAbilityDisplayName("Gomu Gomu no Gatling");
                        }
                        this.attr.setAbilityCooldown(5.0);
                        this.attr.setProjectileDamage(45.0f);
                        break;
                    }
                    case 2: {
                        type = 1;
                        if (MainConfig.enableAnimeScreaming) {
                            this.attr.setAbilityDisplayName("Gomu Gomu no Jet Gatling");
                        }
                        this.attr.setAbilityCooldown(5.0);
                        this.attr.setProjectileDamage(65.0f);
                        break;
                    }
                    case 3: {
                        type = 2;
                        projectileSpace = 7;
                        if (MainConfig.enableAnimeScreaming) {
                            this.attr.setAbilityDisplayName("Gomu Gomu no Elephant Gatling");
                        }
                        this.attr.setAbilityCooldown(5.0);
                        this.attr.setProjectileDamage(100.0f);
                        break;
                    }
                    case 4: {
                        type = 3;
                        projectileSpace = 7;
                        if (MainConfig.enableAnimeScreaming) {
                            this.attr.setAbilityDisplayName("Gomu Gomu no Kong Organ");
                        }
                        this.attr.setAbilityCooldown(5.0);
                        this.attr.setProjectileDamage(180.0f);
                    }
                }
                for (int j = 0; j < 25; ++j) {
                    AbilityProjectile proj = null;
                    if (type == 0) {
                        proj = new GomuProjectiles.GomuGomuNoGatling(player.field_70170_p, (EntityLivingBase)player, ListExtraAttributes.GOMU_GOMU_NO_GATLING);
                    } else if (type == 1) {
                        proj = new GomuProjectiles.GomuGomuNoJetGatling(player.field_70170_p, (EntityLivingBase)player, ListExtraAttributes.GOMU_GOMU_NO_JET_GATLING);
                    } else if (type == 2) {
                        proj = new GomuProjectiles.GomuGomuNoElephantGatling(player.field_70170_p, (EntityLivingBase)player, ListExtraAttributes.GOMU_GOMU_NO_ELEPHANT_GATLING);
                    } else if (type == 3) {
                        proj = new GomuProjectiles.GomuGomuNoKongOrgan(player.field_70170_p, (EntityLivingBase)player, ListExtraAttributes.GOMU_GOMU_NO_KONG_ORGAN);
                    }
                    proj.func_70012_b(player.field_70165_t + WyMathHelper.randomWithRange(-projectileSpace, projectileSpace) + player.field_70170_p.field_73012_v.nextDouble(), player.field_70163_u + 0.3 + WyMathHelper.randomWithRange(0, projectileSpace) + player.field_70170_p.field_73012_v.nextDouble(), player.field_70161_v + WyMathHelper.randomWithRange(-projectileSpace, projectileSpace) + player.field_70170_p.field_73012_v.nextDouble(), 0.0f, 0.0f);
                    player.field_70170_p.func_72838_d((Entity)proj);
                }
                super.use(player);
            }
        }
    }

    public static class GearSecond
    extends Ability {
        public GearSecond() {
            super(ListAttributes.GEAR_SECOND);
        }

        @Override
        public void startPassive(EntityPlayer player) {
            ExtendedEntityData props = ExtendedEntityData.get((EntityLivingBase)player);
            props.setGear(2);
            WyNetworkHelper.sendTo(new PacketSync(props), (EntityPlayerMP)player);
        }

        @Override
        public void duringPassive(EntityPlayer player, int passiveTimer) {
            ExtendedEntityData props = ExtendedEntityData.get((EntityLivingBase)player);
            player.func_70690_d(new PotionEffect(Potion.field_76424_c.field_76415_H, 40, 6, false));
            WyNetworkHelper.sendToAllAround(new PacketParticles("gearSecond", (EntityLivingBase)player), player.field_71093_bK, player.field_70165_t, player.field_70163_u, player.field_70161_v, 128.0);
            if (passiveTimer >= 1200) {
                props.setGear(1);
                WyNetworkHelper.sendTo(new PacketSync(props), (EntityPlayerMP)player);
                this.setPassiveActive(false);
                this.use(player);
            }
        }

        @Override
        public void endPassive(EntityPlayer player) {
            ExtendedEntityData props = ExtendedEntityData.get((EntityLivingBase)player);
            props.setGear(1);
            WyNetworkHelper.sendTo(new PacketSync(props), (EntityPlayerMP)player);
            this.use(player);
        }
    }

    public static class GearThird
    extends Ability {
        public GearThird() {
            super(ListAttributes.GEAR_THIRD);
        }

        @Override
        public void startPassive(EntityPlayer player) {
            ExtendedEntityData props = ExtendedEntityData.get((EntityLivingBase)player);
            props.setGear(3);
            WyNetworkHelper.sendTo(new PacketSync(props), (EntityPlayerMP)player);
        }

        @Override
        public void duringPassive(EntityPlayer player, int passiveTimer) {
            ExtendedEntityData props = ExtendedEntityData.get((EntityLivingBase)player);
            if (passiveTimer >= 1200) {
                props.setGear(1);
                WyNetworkHelper.sendTo(new PacketSync(props), (EntityPlayerMP)player);
                this.setPassiveActive(false);
                this.use(player);
            }
        }

        @Override
        public void endPassive(EntityPlayer player) {
            ExtendedEntityData props = ExtendedEntityData.get((EntityLivingBase)player);
            props.setGear(1);
            WyNetworkHelper.sendTo(new PacketSync(props), (EntityPlayerMP)player);
            this.use(player);
        }
    }

    public static class GearForth
    extends Ability {
        public GearForth() {
            super(ListAttributes.GEAR_FOURTH);
        }

        @Override
        public void passive(EntityPlayer player) {
            ExtendedEntityData props = ExtendedEntityData.get((EntityLivingBase)player);
            AbilityProperties abilityProps = AbilityProperties.get(player);
            if (!this.isOnCooldown && (props.getZoanPoint().equalsIgnoreCase("n/a") || props.getZoanPoint().equalsIgnoreCase("luffy"))) {
                if (!abilityProps.hasHakiAbility(HakiAbilities.BUSOSHOKU_HAKI_HARDENING)) {
                    WyHelper.sendMsgToPlayer(player, "You must have Bososhoku Haki to use Gomu Gear 4");
                    return;
                }
                super.passive(player);
            }
        }

        @Override
        public void startPassive(EntityPlayer player) {
            ExtendedEntityData props = ExtendedEntityData.get((EntityLivingBase)player);
            if (props.getZoanPoint().isEmpty()) {
                props.setZoanPoint("n/a");
            }
            props.setZoanPoint("luffy");
            props.setGear(4);
            WyNetworkHelper.sendTo(new PacketSync(props), (EntityPlayerMP)player);
            WyNetworkHelper.sendToAll(new PacketSyncInfo(player.getDisplayName(), props));
        }

        @Override
        public void duringPassive(EntityPlayer player, int passiveTimer) {
            ExtendedEntityData props = ExtendedEntityData.get((EntityLivingBase)player);
            player.func_70690_d(new PotionEffect(Potion.field_76430_j.field_76415_H, 25, 2, false));
            WyNetworkHelper.sendToAllAround(new PacketParticles("gearSecond", (EntityLivingBase)player), player.field_71093_bK, player.field_70165_t, player.field_70163_u, player.field_70161_v, 128.0);
            if (passiveTimer >= 1200) {
                props.setGear(1);
                props.setZoanPoint("n/a");
                WyNetworkHelper.sendTo(new PacketSync(props), (EntityPlayerMP)player);
                WyNetworkHelper.sendToAll(new PacketSyncInfo(player.getDisplayName(), props));
                this.setPassiveActive(false);
                this.use(player);
            }
        }

        @Override
        public void endPassive(EntityPlayer player) {
            ExtendedEntityData props = ExtendedEntityData.get((EntityLivingBase)player);
            props.setZoanPoint("n/a");
            props.setGear(1);
            WyNetworkHelper.sendTo(new PacketSync(props), (EntityPlayerMP)player);
            WyNetworkHelper.sendToAll(new PacketSyncInfo(player.getDisplayName(), props));
            this.use(player);
        }
    }
}

