/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.MineMineNoMi3.abilities;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.util.MovingObjectPosition;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import xyz.pixelatedw.MineMineNoMi3.MainConfig;
import xyz.pixelatedw.MineMineNoMi3.Values;
import xyz.pixelatedw.MineMineNoMi3.api.WyHelper;
import xyz.pixelatedw.MineMineNoMi3.api.abilities.Ability;
import xyz.pixelatedw.MineMineNoMi3.api.abilities.extra.AbilityExplosion;
import xyz.pixelatedw.MineMineNoMi3.api.abilities.extra.AbilityProperties;
import xyz.pixelatedw.MineMineNoMi3.api.math.WyMathHelper;
import xyz.pixelatedw.MineMineNoMi3.api.network.PacketAbilitySync;
import xyz.pixelatedw.MineMineNoMi3.api.network.WyNetworkHelper;
import xyz.pixelatedw.MineMineNoMi3.api.telemetry.WyTelemetry;
import xyz.pixelatedw.MineMineNoMi3.entities.abilityprojectiles.GoroProjectiles;
import xyz.pixelatedw.MineMineNoMi3.lists.ListAttributes;
import xyz.pixelatedw.MineMineNoMi3.lists.ListExtraAttributes;
import xyz.pixelatedw.MineMineNoMi3.lists.ListMisc;
import xyz.pixelatedw.MineMineNoMi3.packets.PacketParticles;
import xyz.pixelatedw.MineMineNoMi3.packets.PacketPlayer;

public class GoroAbilities {
    public static Ability[] abilitiesArray;

    private static boolean hasTomoeDrumsEquipped(EntityPlayer player) {
        return player.func_71124_b(3) != null && player.func_71124_b(3).func_77973_b() == ListMisc.TomoeDrums;
    }

    static {
        Values.abilityWebAppExtraParams.put("elthor", new String[]{"desc", "Focuses the user's electricity to strike the opponent with lightning from above."});
        Values.abilityWebAppExtraParams.put("voltvari", new String[]{"desc", "Creates a concentrated ball of lightning, which varies in power."});
        Values.abilityWebAppExtraParams.put("raigo", new String[]{"desc", "Creates a huge cloud filled with electricity, which causes massive damage."});
        Values.abilityWebAppExtraParams.put("kari", new String[]{"desc", "Creates an electrical current around the user, which then explodes."});
        Values.abilityWebAppExtraParams.put("sango", new String[]{"desc", "Launches a huge concentrated chunk of electricity at the opponent."});
        abilitiesArray = new Ability[]{new ElThor(), new VoltVari(), new Raigo(), new Kari(), new Sango(), new SparkStep()};
    }

    public static class SparkStep
    extends Ability {
        public SparkStep() {
            super(ListAttributes.SPARK_STEP);
        }

        @Override
        public void use(EntityPlayer player) {
            if (!this.isOnCooldown) {
                if (WyHelper.rayTraceBlocks((Entity)player) != null) {
                    MovingObjectPosition blockTracer = WyHelper.rayTraceBlocks((Entity)player);
                    int[] blockLocation = new int[]{blockTracer.field_72311_b, blockTracer.field_72312_c, blockTracer.field_72309_d};
                    while (player.func_130014_f_().func_147439_a(blockLocation[0], blockLocation[1], blockLocation[2]) != Blocks.field_150350_a) {
                        blockLocation[1] = blockLocation[1] + 1;
                    }
                    EnderTeleportEvent event = new EnderTeleportEvent((EntityLivingBase)player, (double)blockLocation[0], (double)blockLocation[1], (double)blockLocation[2], 0.0f);
                    WyNetworkHelper.sendToAllAround(new PacketParticles("elThor", (EntityLivingBase)player), player.field_71093_bK, player.field_70165_t, player.field_70163_u, player.field_70161_v, 128.0);
                    player.func_70634_a(event.targetX, event.targetY + 1.0, event.targetZ);
                    WyNetworkHelper.sendToAllAround(new PacketParticles("elThor", (EntityLivingBase)player), player.field_71093_bK, player.field_70165_t, player.field_70163_u, player.field_70161_v, 128.0);
                    player.field_70143_R = 0.0f;
                }
                super.use(player);
            }
        }
    }

    public static class Sango
    extends Ability {
        public Sango() {
            super(ListAttributes.SANGO);
        }

        @Override
        public void use(EntityPlayer player) {
            this.projectile = new GoroProjectiles.Sango(player.field_70170_p, (EntityLivingBase)player, this.attr);
            super.use(player);
        }
    }

    public static class Kari
    extends Ability {
        public Kari() {
            super(ListAttributes.KARI);
        }

        @Override
        public void startCharging(EntityPlayer player) {
            if (!this.isOnCooldown) {
                WyNetworkHelper.sendToAllAround(new PacketParticles("kari", (EntityLivingBase)player), player.field_71093_bK, player.field_70165_t, player.field_70163_u, player.field_70161_v, 128.0);
            }
            super.startCharging(player);
        }

        @Override
        public void endCharging(EntityPlayer player) {
            super.endCharging(player);
        }
    }

    public static class Raigo
    extends Ability {
        public Raigo() {
            super(ListAttributes.RAIGO);
        }

        @Override
        public void use(EntityPlayer player) {
            MovingObjectPosition mop;
            if (!this.isOnCooldown && (mop = WyHelper.rayTraceBlocks((Entity)player)) != null) {
                double x = mop.field_72311_b;
                double y = mop.field_72312_c;
                double z = mop.field_72309_d;
                WyNetworkHelper.sendToAllAround(new PacketParticles("raigo", x, player.field_70163_u, z), player.field_71093_bK, x, y, z, 128.0);
                GoroProjectiles.Raigo raigo = new GoroProjectiles.Raigo(player.field_70170_p, (EntityLivingBase)player, ListAttributes.RAIGO);
                raigo.func_70012_b(x, y + 90.0, z, 0.0f, 0.0f);
                raigo.field_70159_w = 0.0;
                raigo.field_70179_y = 0.0;
                raigo.field_70181_x = -1.4;
                player.field_70170_p.func_72838_d((Entity)raigo);
            }
            super.use(player);
        }
    }

    public static class VoltVari
    extends Ability {
        private int power = 0;

        public VoltVari() {
            super(ListAttributes.VOLT_VARI);
        }

        @Override
        public void startCharging(EntityPlayer player) {
            if (!this.isOnCooldown) {
                this.isCharging = true;
                this.startExtUpdate(player);
            }
        }

        @Override
        public void duringCharging(EntityPlayer player, int currentCharge) {
            this.power = currentCharge;
            double truePower = Math.abs(this.power - this.attr.getAbilityCharges());
            if (truePower % 25.0 == 0.0 && MainConfig.enableAnimeScreaming) {
                int voltVariType = (int)Math.floor(truePower / 25.0);
                switch (voltVariType) {
                    case 1: {
                        this.attr.setAbilityDisplayName("1 Million Volt Vari");
                        break;
                    }
                    case 2: {
                        this.attr.setAbilityDisplayName("5 Million Volt Vari");
                        break;
                    }
                    case 3: {
                        this.attr.setAbilityDisplayName("10 Million Volt Vari");
                        break;
                    }
                    case 4: {
                        this.attr.setAbilityDisplayName("20 Million Volt Vari");
                        break;
                    }
                    case 5: {
                        this.attr.setAbilityDisplayName("50 Million Volt Vari");
                        break;
                    }
                    case 6: {
                        this.attr.setAbilityDisplayName("60 Million Volt Vari");
                        break;
                    }
                    case 7: {
                        this.attr.setAbilityDisplayName("100 Million Volt Vari");
                    }
                }
                if (voltVariType < 8) {
                    this.sendShounenScream(player);
                }
            }
        }

        @Override
        public void endCharging(EntityPlayer player) {
            double truePower = Math.abs(this.power - this.attr.getAbilityCharges());
            double trueCooldown = truePower / 20.0 * 3.0;
            if (truePower > 0.0 && truePower <= 50.0) {
                if (MainConfig.enableAnimeScreaming) {
                    if (truePower > 0.0 && truePower <= 25.0) {
                        this.attr.setAbilityDisplayName("1 Million Volt Vari");
                    } else {
                        this.attr.setAbilityDisplayName("5 Million Volt Vari");
                    }
                }
                this.projectile = new GoroProjectiles.VoltVari5Million(player.field_70170_p, (EntityLivingBase)player, ListExtraAttributes.VOLT_VARI_5_MILLION);
            } else if (truePower > 50.0 && truePower <= 100.0) {
                if (MainConfig.enableAnimeScreaming) {
                    if (truePower > 50.0 && truePower <= 75.0) {
                        this.attr.setAbilityDisplayName("10 Million Volt Vari");
                    } else {
                        this.attr.setAbilityDisplayName("20 Million Volt Vari");
                    }
                }
                this.projectile = new GoroProjectiles.VoltVari20Million(player.field_70170_p, (EntityLivingBase)player, ListExtraAttributes.VOLT_VARI_20_MILLION);
            } else if (truePower > 100.0 && truePower <= 150.0) {
                if (MainConfig.enableAnimeScreaming) {
                    if (truePower > 100.0 && truePower <= 125.0) {
                        this.attr.setAbilityDisplayName("50 Million Volt Vari");
                    } else {
                        this.attr.setAbilityDisplayName("60 Million Volt Vari");
                    }
                }
                this.projectile = new GoroProjectiles.VoltVari60Million(player.field_70170_p, (EntityLivingBase)player, ListExtraAttributes.VOLT_VARI_60_MILLION);
            } else if (truePower > 150.0 && truePower <= 200.0) {
                if (MainConfig.enableAnimeScreaming) {
                    if (truePower > 150.0 && truePower <= 175.0) {
                        this.attr.setAbilityDisplayName("100 Million Volt Vari");
                    } else {
                        this.attr.setAbilityDisplayName("Max 200 Million Volt Vari");
                    }
                }
                this.projectile = new GoroProjectiles.VoltVari200Million(player.field_70170_p, (EntityLivingBase)player, ListExtraAttributes.VOLT_VARI_200_MILLION);
            }
            this.sendShounenScream(player);
            this.attr.setAbilityCooldown(trueCooldown);
            this.isCharging = false;
            this.isOnCooldown = true;
            WyNetworkHelper.sendTo(new PacketAbilitySync(AbilityProperties.get(player)), (EntityPlayerMP)player);
            if (!player.field_71075_bZ.field_75098_d) {
                WyTelemetry.addAbilityStat(this.getAttribute().getAbilityTexture(), this.getAttribute().getAttributeName(), 1);
            }
            if (this.projectile != null) {
                player.field_70170_p.func_72838_d((Entity)this.projectile);
            }
            this.startExtUpdate(player);
        }
    }

    public static class ElThor
    extends Ability {
        public ElThor() {
            super(ListAttributes.EL_THOR);
        }

        @Override
        public void startCharging(EntityPlayer player) {
            if (GoroAbilities.hasTomoeDrumsEquipped(player)) {
                this.attr.setAbilityDisplayName("Mamaragan");
                this.attr.setAbilityCooldown(20.0);
            }
            super.startCharging(player);
        }

        @Override
        public void duringCharging(EntityPlayer player, int currentCharge) {
            MovingObjectPosition mop = WyHelper.rayTraceBlocks((Entity)player);
            if (mop != null) {
                double i = mop.field_72311_b;
                double j = mop.field_72312_c;
                double k = mop.field_72309_d;
                WyNetworkHelper.sendToAllAround(new PacketParticles("elThor", i, j, k), player.field_71093_bK, player.field_70165_t, player.field_70163_u, player.field_70161_v, 128.0);
            }
        }

        @Override
        public void endCharging(EntityPlayer player) {
            MovingObjectPosition mop = WyHelper.rayTraceBlocks((Entity)player);
            if (mop != null) {
                double i = mop.field_72311_b;
                double j = mop.field_72312_c;
                double k = mop.field_72309_d;
                if (GoroAbilities.hasTomoeDrumsEquipped(player)) {
                    for (int t = 0; t < 5; ++t) {
                        WyNetworkHelper.sendTo(new PacketPlayer("ElThorThunder", i += WyMathHelper.randomWithRange(-15, 15), j, k += WyMathHelper.randomWithRange(-15, 15)), (EntityPlayerMP)player);
                        AbilityExplosion exp = WyHelper.newExplosion((Entity)player, i, j, k, 10.0);
                        exp.setFireAfterExplosion(true);
                        exp.doExplosion();
                    }
                } else {
                    WyNetworkHelper.sendTo(new PacketPlayer("ElThorThunder", i, j, k), (EntityPlayerMP)player);
                    AbilityExplosion exp = WyHelper.newExplosion((Entity)player, i, j, k, 10.0);
                    exp.setFireAfterExplosion(true);
                    exp.doExplosion();
                }
            }
            super.endCharging(player);
            this.attr.setAbilityDisplayName("El Thor");
            this.attr.setAbilityCooldown(8.0);
        }
    }
}

