/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.MineMineNoMi3.abilities;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import xyz.pixelatedw.MineMineNoMi3.Values;
import xyz.pixelatedw.MineMineNoMi3.api.WyHelper;
import xyz.pixelatedw.MineMineNoMi3.api.abilities.Ability;
import xyz.pixelatedw.MineMineNoMi3.api.abilities.extra.AbilityExplosion;
import xyz.pixelatedw.MineMineNoMi3.api.network.WyNetworkHelper;
import xyz.pixelatedw.MineMineNoMi3.data.ExtendedEntityData;
import xyz.pixelatedw.MineMineNoMi3.entities.abilityprojectiles.GuraProjectiles;
import xyz.pixelatedw.MineMineNoMi3.lists.ListAttributes;
import xyz.pixelatedw.MineMineNoMi3.packets.PacketParticles;

public class GuraAbilities {
    public static Ability[] abilitiesArray;

    static {
        Values.abilityWebAppExtraParams.put("kaishin", new String[]{"desc", "The user cracks the air, which launches a small but powerful explosion towards the opponent."});
        Values.abilityWebAppExtraParams.put("kabutowari", new String[]{"desc", "The user punches the air and creates a massive explosion around themselves."});
        Values.abilityWebAppExtraParams.put("shimayurashi", new String[]{"desc", "Launches a powerful explosion which spreads towards the opponent."});
        Values.abilityWebAppExtraParams.put("gekishin", new String[]{"desc", "The user creates a tremor while punching the enemy, inflicting massive damage."});
        abilitiesArray = new Ability[]{new Kaishin(), new Kabutowari(), new ShimaYurashi(), new Gekishin()};
    }

    public static class ShimaYurashi
    extends Ability {
        public ShimaYurashi() {
            super(ListAttributes.SHIMA_YURASHI);
        }

        @Override
        public void use(EntityPlayer player) {
            this.projectile = new GuraProjectiles.ShimaYurashi(player.field_70170_p, (EntityLivingBase)player, this.attr);
            super.use(player);
        }
    }

    public static class Kabutowari
    extends Ability {
        public Kabutowari() {
            super(ListAttributes.KABUTOWARI);
        }

        @Override
        public void use(EntityPlayer player) {
            super.use(player);
        }
    }

    public static class Kaishin
    extends Ability {
        public Kaishin() {
            super(ListAttributes.KAISHIN);
        }

        @Override
        public void use(EntityPlayer player) {
            this.projectile = new GuraProjectiles.Kaishin(player.field_70170_p, (EntityLivingBase)player, this.attr);
            super.use(player);
        }
    }

    public static class Gekishin
    extends Ability {
        public Gekishin() {
            super(ListAttributes.GEKISHIN);
        }

        @Override
        public void hitEntity(EntityPlayer player, EntityLivingBase target) {
            ExtendedEntityData props = ExtendedEntityData.get((EntityLivingBase)player);
            super.hitEntity(player, target);
            target.func_70097_a(DamageSource.func_76365_a((EntityPlayer)player), 200.0f * props.getDamageMultiplier());
            AbilityExplosion explosion = WyHelper.newExplosion((Entity)player, target.field_70165_t, target.field_70163_u, target.field_70161_v, 3.0);
            explosion.setDamageOwner(false);
            explosion.setSmokeParticles("");
            explosion.doExplosion();
            WyNetworkHelper.sendToAllAround(new PacketParticles("gekishin", (EntityLivingBase)player), player.field_71093_bK, player.field_70165_t, player.field_70163_u, player.field_70161_v, 128.0);
        }
    }
}

