/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.MineMineNoMi3.abilities;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.world.World;
import xyz.pixelatedw.MineMineNoMi3.MainConfig;
import xyz.pixelatedw.MineMineNoMi3.Values;
import xyz.pixelatedw.MineMineNoMi3.api.WyHelper;
import xyz.pixelatedw.MineMineNoMi3.api.abilities.Ability;
import xyz.pixelatedw.MineMineNoMi3.entities.abilityprojectiles.HieProjectiles;
import xyz.pixelatedw.MineMineNoMi3.lists.ListAttributes;
import xyz.pixelatedw.MineMineNoMi3.lists.ListMisc;

public class HieAbilities {
    public static Ability[] abilitiesArray;

    static {
        Values.abilityWebAppExtraParams.put("iceblockpartisan", new String[]{"desc", "Creates several spears of ice that the user hurls at the enemy."});
        Values.abilityWebAppExtraParams.put("iceball", new String[]{"desc", "Creates a sphere of ice that surrounds the opponent."});
        Values.abilityWebAppExtraParams.put("iceage", new String[]{"desc", "Freezes a large area around the user and everyone inside of it."});
        Values.abilityWebAppExtraParams.put("icetimecapsule", new String[]{"desc", "A wave of ice is sent along the ground and freezes every enemy it hits."});
        Values.abilityWebAppExtraParams.put("iceblockpheasant", new String[]{"desc", "Releases a massive wave of ice in the shape of a pheasant."});
        Values.abilityWebAppExtraParams.put("icesaber", new String[]{"desc", "Creates a sharp blade made of solid ice."});
        abilitiesArray = new Ability[]{new IceBlockPartisan(), new IceSaber(), new IceAge(), new IceBall(), new IceTimeCapsule(), new IceBlockPheasant()};
    }

    public static class IceBlockPheasant
    extends Ability {
        public IceBlockPheasant() {
            super(ListAttributes.ICE_BLOCK_PHEASANT);
        }

        @Override
        public void use(EntityPlayer player) {
            this.projectile = new HieProjectiles.IceBlockPheasant(player.field_70170_p, (EntityLivingBase)player, ListAttributes.ICE_BLOCK_PHEASANT);
            super.use(player);
        }
    }

    public static class IceTimeCapsule
    extends Ability {
        public IceTimeCapsule() {
            super(ListAttributes.ICE_TIME_CAPSULE);
        }

        @Override
        public void use(EntityPlayer player) {
            if (!this.isOnCooldown()) {
                if (MainConfig.enableGriefing) {
                    for (EntityLivingBase l : WyHelper.getEntitiesNear((Entity)player, 25.0)) {
                        WyHelper.createFilledCube((Entity)l, new int[]{2, 4, 2}, Blocks.field_150403_cj, "air", "foliage");
                    }
                }
                super.use(player);
            }
        }
    }

    public static class IceBall
    extends Ability {
        public IceBall() {
            super(ListAttributes.ICE_BALL);
        }

        @Override
        public void use(EntityPlayer player) {
            this.projectile = new HieProjectiles.IceBall(player.field_70170_p, (EntityLivingBase)player, ListAttributes.ICE_BALL);
            super.use(player);
        }
    }

    public static class IceAge
    extends Ability {
        public IceAge() {
            super(ListAttributes.ICE_AGE);
        }

        @Override
        public void use(EntityPlayer player) {
            if (!this.isOnCooldown) {
                World world = player.field_70170_p;
                for (EntityLivingBase target : WyHelper.getEntitiesNear((Entity)player, 15.0)) {
                    target.func_70690_d(new PotionEffect(Potion.field_76421_d.field_76415_H, 600));
                    target.func_70690_d(new PotionEffect(Potion.field_76419_f.field_76415_H, 600));
                }
                super.use(player);
            }
        }
    }

    public static class IceBlockPartisan
    extends Ability {
        public IceBlockPartisan() {
            super(ListAttributes.ICE_BLOCK_PARTISAN);
        }

        @Override
        public void use(EntityPlayer player) {
            this.projectile = new HieProjectiles.IceBlockPartisan(player.field_70170_p, (EntityLivingBase)player, ListAttributes.ICE_BLOCK_PARTISAN);
            super.use(player);
        }
    }

    public static class IceSaber
    extends Ability {
        public IceSaber() {
            super(ListAttributes.ICE_SABER);
        }

        @Override
        public void startPassive(EntityPlayer player) {
            if (player.field_71071_by.func_70448_g() == null) {
                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, new ItemStack((Item)ListMisc.IceSaber));
            } else {
                WyHelper.sendMsgToPlayer(player, "Cannot equip " + this.getAttribute().getAttributeName() + " while holding another item in hand !");
                this.passive(player);
            }
        }

        @Override
        public void endPassive(EntityPlayer player) {
            player.field_71071_by.func_146027_a((Item)ListMisc.IceSaber, -1);
        }
    }
}

