/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.MineMineNoMi3.abilities;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import xyz.pixelatedw.MineMineNoMi3.Values;
import xyz.pixelatedw.MineMineNoMi3.api.WyHelper;
import xyz.pixelatedw.MineMineNoMi3.api.abilities.Ability;
import xyz.pixelatedw.MineMineNoMi3.api.network.WyNetworkHelper;
import xyz.pixelatedw.MineMineNoMi3.entities.abilityprojectiles.ItoProjectiles;
import xyz.pixelatedw.MineMineNoMi3.entities.mobs.misc.EntityBlackKnight;
import xyz.pixelatedw.MineMineNoMi3.lists.ListAttributes;
import xyz.pixelatedw.MineMineNoMi3.lists.ListMisc;
import xyz.pixelatedw.MineMineNoMi3.packets.PacketParticles;
import xyz.pixelatedw.MineMineNoMi3.packets.PacketPlayer;

public class ItoAbilities {
    public static Ability[] abilitiesArray;

    private static void motion(String c, double x, double y, double z, EntityPlayer p) {
        WyNetworkHelper.sendTo(new PacketPlayer("motion" + c, x, y, z), (EntityPlayerMP)p);
    }

    static {
        Values.abilityWebAppExtraParams.put("parasite", new String[]{"desc", "The user binds the opponent with a string that renders them immobile."});
        Values.abilityWebAppExtraParams.put("soranomichi", new String[]{"desc", "The user creates strings under their feet to launch themselves into the air."});
        Values.abilityWebAppExtraParams.put("overheat", new String[]{"desc", "The user shoots a rope made of heated strings at the opponent, exploding upon impact."});
        Values.abilityWebAppExtraParams.put("tamaito", new String[]{"desc", "The user shoots a small bundle of strings, acting like a bullet."});
        Values.abilityWebAppExtraParams.put("kumonosugaki", new String[]{"desc", "Creates a huge web that protects the user from any attack."});
        Values.abilityWebAppExtraParams.put("torikago", new String[]{"desc", "Creates an indestructible dome made of strings, that damage anyone who toches then"});
        Values.abilityWebAppExtraParams.put("godthreat", new String[]{"desc", "Creates an indestructible dome made of strings, that damage anyone who toches then"});
        Values.abilityWebAppExtraParams.put("flapthread", new String[]{"desc", "Creates an indestructible dome made of strings, that damage anyone who toches then"});
        Values.abilityWebAppExtraParams.put("everwhite", new String[]{"desc", "Creates an indestructible dome made of strings, that damage anyone who toches then"});
        abilitiesArray = new Ability[]{new Parasite(), new GodThreat(), new FlapThread(), new Everwhite(), new SoraNoMichi(), new Overheat(), new Tamaito(), new KumoNoSugaki(), new Torikago(), new BlackKnight()};
    }

    public static class Parasite
    extends Ability {
        public Parasite() {
            super(ListAttributes.PARASITE);
        }

        @Override
        public void use(EntityPlayer player) {
            if (!this.isOnCooldown) {
                for (EntityLivingBase l : WyHelper.getEntitiesNear((Entity)player, 20.0)) {
                    System.out.println(l);
                    l.func_70690_d(new PotionEffect(Potion.field_76440_q.field_76415_H, 200, 10));
                    l.func_70690_d(new PotionEffect(Potion.field_76431_k.field_76415_H, 200, 10));
                    l.func_70690_d(new PotionEffect(Potion.field_76419_f.field_76415_H, 200, 10));
                    l.func_70690_d(new PotionEffect(Potion.field_76421_d.field_76415_H, 200, 10));
                }
                super.use(player);
            }
        }
    }

    public static class SoraNoMichi
    extends Ability {
        public SoraNoMichi() {
            super(ListAttributes.SORA_NO_MICHI);
        }

        @Override
        public void use(EntityPlayer player) {
            if (!this.isOnCooldown) {
                WyHelper.Direction dir = WyHelper.get8Directions((Entity)player);
                double mX = 0.0;
                double mY = 0.0;
                double mZ = 0.0;
                mY = player.field_70122_E ? (mY += 1.8) : (mY += 1.96);
                if (dir == WyHelper.Direction.NORTH) {
                    mZ -= 1.0;
                }
                if (dir == WyHelper.Direction.NORTH_WEST) {
                    mZ -= 1.0;
                    mX -= 1.0;
                }
                if (dir == WyHelper.Direction.SOUTH) {
                    mZ += 1.0;
                }
                if (dir == WyHelper.Direction.NORTH_EAST) {
                    mZ -= 1.0;
                    mX += 1.0;
                }
                if (dir == WyHelper.Direction.WEST) {
                    mX -= 1.0;
                }
                if (dir == WyHelper.Direction.SOUTH_WEST) {
                    mZ += 1.0;
                    mX -= 1.0;
                }
                if (dir == WyHelper.Direction.EAST) {
                    mX += 1.0;
                }
                if (dir == WyHelper.Direction.SOUTH_EAST) {
                    mZ += 1.0;
                    mX += 1.0;
                }
                ItoAbilities.motion("=", mX, mY, mZ, player);
                super.use(player);
            }
        }
    }

    public static class Overheat
    extends Ability {
        public Overheat() {
            super(ListAttributes.OVERHEAT);
        }

        @Override
        public void use(EntityPlayer player) {
            this.projectile = new ItoProjectiles.Overheat(player.field_70170_p, (EntityLivingBase)player, this.attr);
            super.use(player);
        }
    }

    public static class Tamaito
    extends Ability {
        public Tamaito() {
            super(ListAttributes.TAMAITO);
        }

        @Override
        public void use(EntityPlayer player) {
            this.projectile = new ItoProjectiles.Tamaito(player.field_70170_p, (EntityLivingBase)player, this.attr);
            super.use(player);
        }
    }

    public static class KumoNoSugaki
    extends Ability {
        public KumoNoSugaki() {
            super(ListAttributes.KUMO_NO_SUGAKI);
        }

        @Override
        public void duringPassive(EntityPlayer player, int passiveTimer) {
            WyNetworkHelper.sendToAllAround(new PacketParticles("kumoNoSugaki", (EntityLivingBase)player), player.field_71093_bK, player.field_70165_t, player.field_70163_u, player.field_70161_v, 128.0);
            if (passiveTimer >= 300) {
                this.setPassiveActive(false);
                this.startCooldown();
                this.startExtUpdate(player);
                super.endPassive(player);
            }
        }

        @Override
        public void endPassive(EntityPlayer player) {
            this.startCooldown();
            this.startExtUpdate(player);
        }
    }

    public static class Torikago
    extends Ability {
        private List<int[]> blockList = new ArrayList<int[]>();

        public Torikago() {
            super(ListAttributes.TORIKAGO);
        }

        @Override
        public void passive(EntityPlayer player) {
            if (!this.isOnCooldown) {
                if (this.blockList.isEmpty()) {
                    this.blockList.addAll(WyHelper.createEmptySphere(player.field_70170_p, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v, 20, ListMisc.StringWall, "air", "foliage", "liquids", "nogrief"));
                    player.field_70170_p.func_147449_b((int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v, ListMisc.StringMid);
                    this.blockList.add(new int[]{(int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v});
                }
                super.passive(player);
            }
        }

        @Override
        public void endPassive(EntityPlayer player) {
            for (int[] blockPos : this.blockList) {
                if (player.field_70170_p.func_147439_a(blockPos[0], blockPos[1], blockPos[2]) != ListMisc.StringWall && player.field_70170_p.func_147439_a(blockPos[0], blockPos[1], blockPos[2]) != ListMisc.StringMid) continue;
                player.field_70170_p.func_147449_b(blockPos[0], blockPos[1], blockPos[2], Blocks.field_150350_a);
            }
            this.blockList = new ArrayList<int[]>();
            this.startCooldown();
            this.startExtUpdate(player);
        }
    }

    public static class BlackKnight
    extends Ability {
        private EntityBlackKnight blackKnight;

        public BlackKnight() {
            super(ListAttributes.BLACK_KNIGHT);
        }

        @Override
        public void passive(EntityPlayer player) {
            if (this.passiveActive && player.func_70093_af() && this.blackKnight != null) {
                this.blackKnight.isAggressive = !this.blackKnight.isAggressive;
                WyHelper.sendMsgToPlayer(player, "Your Black Knight is now " + (this.blackKnight.isAggressive ? "aggressive" : "defensive"));
            } else {
                super.passive(player);
            }
        }

        @Override
        public void startPassive(EntityPlayer player) {
            this.blackKnight = new EntityBlackKnight(player.field_70170_p, player);
            this.blackKnight.func_70080_a(player.field_70165_t, player.field_70163_u, player.field_70161_v, 180.0f, 0.0f);
            player.field_70170_p.func_72838_d((Entity)this.blackKnight);
        }

        @Override
        public void endPassive(EntityPlayer player) {
            if (!WyHelper.getEntitiesNear((Entity)player, 20.0, EntityBlackKnight.class).isEmpty()) {
                WyHelper.getEntitiesNear((Entity)player, 20.0, EntityBlackKnight.class).forEach(x -> ((Entity)x).func_70106_y());
            }
            this.startCooldown();
            this.startExtUpdate(player);
        }
    }

    public static class FlapThread
    extends Ability {
        public FlapThread() {
            super(ListAttributes.FlapThread);
        }

        @Override
        public void use(EntityPlayer player) {
            this.projectile = new ItoProjectiles.FlapThread(player.field_70170_p, (EntityLivingBase)player, ListAttributes.FlapThread);
            super.use(player);
        }
    }

    public static class GodThreat
    extends Ability {
        public GodThreat() {
            super(ListAttributes.GodThreat);
        }

        @Override
        public void use(EntityPlayer player) {
            this.projectile = new ItoProjectiles.GodThreat(player.field_70170_p, (EntityLivingBase)player, ListAttributes.GodThreat);
            super.use(player);
        }
    }

    public static class Everwhite
    extends Ability {
        public Everwhite() {
            super(ListAttributes.Everwhite);
        }

        @Override
        public void use(EntityPlayer player) {
            this.projectile = new ItoProjectiles.Everwhite(player.field_70170_p, (EntityLivingBase)player, ListAttributes.Everwhite);
            super.use(player);
        }
    }
}

