/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.MineMineNoMi3.abilities;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S0BPacketAnimation;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.WorldServer;
import xyz.pixelatedw.MineMineNoMi3.MainConfig;
import xyz.pixelatedw.MineMineNoMi3.abilities.effects.DFEffect;
import xyz.pixelatedw.MineMineNoMi3.abilities.effects.DFEffectZushiAbareHimatsuri;
import xyz.pixelatedw.MineMineNoMi3.api.WyHelper;
import xyz.pixelatedw.MineMineNoMi3.api.abilities.Ability;
import xyz.pixelatedw.MineMineNoMi3.api.math.WyMathHelper;
import xyz.pixelatedw.MineMineNoMi3.data.ExtendedEntityData;
import xyz.pixelatedw.MineMineNoMi3.entities.abilityprojectiles.JuryoProjectiles;
import xyz.pixelatedw.MineMineNoMi3.helpers.DevilFruitsHelper;
import xyz.pixelatedw.MineMineNoMi3.helpers.ItemsHelper;
import xyz.pixelatedw.MineMineNoMi3.lists.ListAttributes;

public class JuryoAbilities {
    public static Ability[] abilitiesArray = new Ability[]{new SagariNoRyusei(), new Juryoku(), new Moko(), new AbareHimatsuri()};

    public static class SagariNoRyusei
    extends Ability {
        public SagariNoRyusei() {
            super(ListAttributes.SAGARI_NO_RYUSEI);
        }

        @Override
        public void use(EntityPlayer player) {
            MovingObjectPosition mop;
            if (!this.isOnCooldown && (mop = WyHelper.rayTraceBlocks((Entity)player)) != null) {
                double x = mop.field_72311_b;
                double y = mop.field_72312_c;
                double z = mop.field_72309_d;
                JuryoProjectiles.SagariNoRyusei sagariNoRyusei = new JuryoProjectiles.SagariNoRyusei(player.field_70170_p, (EntityLivingBase)player, ListAttributes.SAGARI_NO_RYUSEI);
                sagariNoRyusei.func_70012_b(x, y + 90.0, z, 0.0f, 0.0f);
                sagariNoRyusei.field_70159_w = 0.0;
                sagariNoRyusei.field_70179_y = 0.0;
                sagariNoRyusei.field_70181_x = -2.4;
                player.field_70170_p.func_72838_d((Entity)sagariNoRyusei);
            }
            super.use(player);
        }
    }

    public static class Juryoku
    extends Ability {
        public Juryoku() {
            super(ListAttributes.JURYOKU);
        }

        @Override
        public void duringPassive(EntityPlayer player, int passiveTimer) {
            ExtendedEntityData props = ExtendedEntityData.get((EntityLivingBase)player);
            if (passiveTimer > 400) {
                this.setPassiveActive(false);
                this.startCooldown();
                this.startExtUpdate(player);
            }
            for (EntityLivingBase entity : WyHelper.getEntitiesNear((Entity)player, 10.0)) {
                entity.field_70159_w = 0.0;
                entity.field_70179_y = 0.0;
                entity.field_70181_x -= 5.0;
                entity.func_70690_d(new PotionEffect(Potion.field_76421_d.field_76415_H, 100, 10));
                if (++passiveTimer % 100 != 0) continue;
                entity.func_70097_a(DamageSource.func_76365_a((EntityPlayer)player), 8.0f * props.getDamageMultiplier());
                if (!MainConfig.enableGriefing) continue;
                for (int x = -2; x < 2; ++x) {
                    for (int z = -2; z < 2; ++z) {
                        int posX = (int)entity.field_70165_t + x;
                        int posY = (int)entity.field_70163_u - 1;
                        int posZ = (int)entity.field_70161_v + z;
                        DevilFruitsHelper.placeBlockIfAllowed(player.field_70170_p, posX, posY, posZ, Blocks.field_150350_a, "all", "restricted", "ignore liquid");
                    }
                }
            }
        }

        @Override
        public void endPassive(EntityPlayer player) {
            this.startCooldown();
            this.startExtUpdate(player);
        }
    }

    public static class Moko
    extends Ability {
        public Moko() {
            super(ListAttributes.MOKO);
        }

        @Override
        public void use(EntityPlayer player) {
            if (!this.isOnCooldown()) {
                if (!ItemsHelper.isSword(player.func_70694_bm())) {
                    WyHelper.sendMsgToPlayer(player, "You need a sword to use this ability !");
                    return;
                }
                for (int j = 0; j < 50; ++j) {
                    JuryoProjectiles.Moko moko = new JuryoProjectiles.Moko(player.field_70170_p, (EntityLivingBase)player, ListAttributes.MOKO);
                    moko.func_70012_b(player.field_70165_t + WyMathHelper.randomWithRange(-5, 5) + player.field_70170_p.field_73012_v.nextDouble(), player.field_70163_u + 0.3 + WyMathHelper.randomWithRange(0, 5) + player.field_70170_p.field_73012_v.nextDouble(), player.field_70161_v + WyMathHelper.randomWithRange(-5, 5) + player.field_70170_p.field_73012_v.nextDouble(), 0.0f, 0.0f);
                    player.field_70170_p.func_72838_d((Entity)moko);
                }
                if (player.field_70170_p instanceof WorldServer) {
                    ((WorldServer)player.field_70170_p).func_73039_n().func_151248_b((Entity)player, (Packet)new S0BPacketAnimation((Entity)player, 0));
                }
                super.use(player);
            }
        }
    }

    public static class AbareHimatsuri
    extends Ability {
        private DFEffect extra = null;

        public AbareHimatsuri() {
            super(ListAttributes.ABARE_HIMATSURI);
        }

        @Override
        public void passive(EntityPlayer player) {
            ExtendedEntityData props = ExtendedEntityData.get((EntityLivingBase)player);
            if (!player.field_71075_bZ.field_75100_b && player.field_70122_E) {
                if (this.extra == null) {
                    this.extra = new DFEffectZushiAbareHimatsuri((EntityLivingBase)player, 99999);
                } else {
                    this.extra.forceStop();
                    this.extra = null;
                }
                super.passive(player);
            } else if (!player.field_70122_E) {
                if (this.extra != null) {
                    this.extra.forceStop();
                    this.extra = null;
                }
                super.passive(player);
            }
        }

        @Override
        public void startPassive(EntityPlayer player) {
        }

        @Override
        public void endPassive(EntityPlayer player) {
        }
    }
}

