/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.MineMineNoMi3.abilities;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.MovingObjectPosition;
import xyz.pixelatedw.MineMineNoMi3.Values;
import xyz.pixelatedw.MineMineNoMi3.api.WyHelper;
import xyz.pixelatedw.MineMineNoMi3.api.abilities.Ability;
import xyz.pixelatedw.MineMineNoMi3.entities.abilityprojectiles.KageProjectiles;
import xyz.pixelatedw.MineMineNoMi3.entities.mobs.misc.EntityDoppelman;
import xyz.pixelatedw.MineMineNoMi3.lists.ListAttributes;
import xyz.pixelatedw.MineMineNoMi3.lists.ListExtraAttributes;

public class KageAbilities {
    public static Ability[] abilitiesArray;

    static {
        Values.abilityWebAppExtraParams.put("brickbat", new String[]{"desc", "Launches bats created from the user's shadow at the the opponent."});
        Values.abilityWebAppExtraParams.put("blackbox", new String[]{"desc", "Encases and suffocates the opponent in a box made of shadows."});
        Values.abilityWebAppExtraParams.put("tsunotokage", new String[]{"desc", "The user creates a lizard-like shadow under his opponent, which pierces them from below."});
        Values.abilityWebAppExtraParams.put("doppelman", new String[]{"desc", "Creates a living version of the user's shadow to help them fight."});
        abilitiesArray = new Ability[]{new Doppelman(), new Kagemusha(), new BrickBat(), new BlackBox(), new Tsunotokage()};
    }

    public static class Tsunotokage
    extends Ability {
        public Tsunotokage() {
            super(ListAttributes.TSUNOTOKAGE);
        }

        @Override
        public void use(EntityPlayer player) {
            if (!this.isOnCooldown) {
                MovingObjectPosition mop = WyHelper.rayTraceBlocks((Entity)player);
                if (mop != null) {
                    double i = mop.field_72311_b;
                    double j = mop.field_72312_c;
                    double k = mop.field_72309_d;
                    KageProjectiles.TsunotokagePillar pillar = new KageProjectiles.TsunotokagePillar(player.field_70170_p, (EntityLivingBase)player, ListExtraAttributes.TSUNOTOKAGE_PILLAR);
                    pillar.func_70012_b(i, j + 1.0, k, 0.0f, 0.0f);
                    pillar.field_70159_w = 0.0;
                    pillar.field_70179_y = 0.0;
                    pillar.field_70181_x = 0.7;
                    player.field_70170_p.func_72838_d((Entity)pillar);
                }
                super.use(player);
            }
        }
    }

    public static class BlackBox
    extends Ability {
        public BlackBox() {
            super(ListAttributes.BLACK_BOX);
        }

        @Override
        public void use(EntityPlayer player) {
            this.projectile = new KageProjectiles.BlackBox(player.field_70170_p, (EntityLivingBase)player, this.attr);
            super.use(player);
        }
    }

    public static class Doppelman
    extends Ability {
        private EntityDoppelman doppelman;

        public Doppelman() {
            super(ListAttributes.DOPPELMAN);
        }

        @Override
        public void passive(EntityPlayer player) {
            if (this.passiveActive && player.func_70093_af() && this.doppelman != null) {
                this.doppelman.isAggressive = !this.doppelman.isAggressive;
                WyHelper.sendMsgToPlayer(player, "Your Doppelman is now " + (this.doppelman.isAggressive ? "aggressive" : "defensive"));
            } else {
                super.passive(player);
            }
        }

        @Override
        public void startPassive(EntityPlayer player) {
            this.doppelman = new EntityDoppelman(player.field_70170_p, player);
            this.doppelman.func_70080_a(player.field_70165_t, player.field_70163_u, player.field_70161_v, 180.0f, 0.0f);
            player.field_70170_p.func_72838_d((Entity)this.doppelman);
        }

        @Override
        public void endPassive(EntityPlayer player) {
            if (!WyHelper.getEntitiesNear((Entity)player, 20.0, EntityDoppelman.class).isEmpty()) {
                WyHelper.getEntitiesNear((Entity)player, 20.0, EntityDoppelman.class).forEach(x -> ((Entity)x).func_70106_y());
            }
            this.startCooldown();
            this.startExtUpdate(player);
        }
    }

    public static class Kagemusha
    extends Ability {
        public Kagemusha() {
            super(ListAttributes.KAGEMUSHA);
        }

        @Override
        public void use(EntityPlayer player) {
            if (!WyHelper.getEntitiesNear((Entity)player, 20.0, EntityDoppelman.class).isEmpty()) {
                EntityDoppelman dopp = WyHelper.getEntitiesNear((Entity)player, 20.0, EntityDoppelman.class).stream().findFirst().orElse(null);
                if (dopp != null) {
                    int[] auxPos = new int[]{(int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v};
                    player.func_70634_a(dopp.field_70165_t, dopp.field_70163_u, dopp.field_70161_v);
                    dopp.func_70634_a(auxPos[0], auxPos[1], auxPos[2]);
                }
            } else {
                WyHelper.sendMsgToPlayer(player, "Your Doppelman is too far away");
            }
            super.use(player);
        }
    }

    public static class BrickBat
    extends Ability {
        public BrickBat() {
            super(ListAttributes.BRICK_BAT);
        }

        @Override
        public void use(EntityPlayer player) {
            this.projectile = new KageProjectiles.BrickBat(player.field_70170_p, (EntityLivingBase)player, this.attr);
            super.use(player);
        }
    }
}

