/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.MineMineNoMi3.abilities;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import xyz.pixelatedw.MineMineNoMi3.api.WyHelper;
import xyz.pixelatedw.MineMineNoMi3.api.abilities.Ability;
import xyz.pixelatedw.MineMineNoMi3.api.abilities.extra.AbilityProperties;
import xyz.pixelatedw.MineMineNoMi3.api.network.PacketAbilitySync;
import xyz.pixelatedw.MineMineNoMi3.api.network.WyNetworkHelper;
import xyz.pixelatedw.MineMineNoMi3.lists.ListAttributes;
import xyz.pixelatedw.MineMineNoMi3.lists.ListMisc;
import xyz.pixelatedw.MineMineNoMi3.packets.PacketParticles;
import xyz.pixelatedw.MineMineNoMi3.packets.PacketPlayer;

public class KiloAbilities {
    public static Ability[] abilitiesArray = new Ability[]{new Weightless(), new KickOffJump(), new HeavyPunch(), new KiloPress()};

    private static boolean hasStrength(EntityPlayer player) {
        Object[] effects = player.func_70651_bq().toArray();
        for (int i = 0; i < effects.length; ++i) {
            PotionEffect currentEffect = (PotionEffect)effects[i];
            if (currentEffect.func_76456_a() != 5 || currentEffect.func_76458_c() != 8) continue;
            return true;
        }
        return false;
    }

    private static void movePlayer(String c, double x, double y, double z, EntityPlayer p) {
        WyNetworkHelper.sendTo(new PacketPlayer("motion" + c, x, y, z), (EntityPlayerMP)p);
    }

    public static class KiloPress
    extends Ability {
        private double initialY;

        public KiloPress() {
            super(ListAttributes.KILO_PRESS);
        }

        @Override
        public void passive(EntityPlayer player) {
            if (!this.isOnCooldown) {
                AbilityProperties abilityProps = AbilityProperties.get(player);
                Weightless weightless = (Weightless)abilityProps.getAbilityFromName(ListAttributes.WEIGHTLESS.getAttributeName());
                if (weightless != null && weightless.isPassiveActive()) {
                    weightless.endPassive(player);
                    WyNetworkHelper.sendTo(new PacketAbilitySync(abilityProps), (EntityPlayerMP)player);
                }
                this.initialY = player.field_70163_u;
                super.passive(player);
            }
        }

        @Override
        public void duringPassive(EntityPlayer player, int timer) {
            if (player.field_70122_E) {
                this.setPassiveActive(false);
                this.setCooldownActive(true);
                this.endPassive(player);
            } else {
                KiloAbilities.movePlayer("=", 0.0, -2.0, 0.0, player);
            }
        }

        @Override
        public void endPassive(EntityPlayer player) {
            double damage = this.initialY - player.field_70163_u;
            if (damage > 0.0) {
                for (EntityLivingBase entity : WyHelper.getEntitiesNear((Entity)player, 5.0)) {
                    entity.func_70097_a(DamageSource.func_76365_a((EntityPlayer)player), (float)(damage * 0.75));
                }
            }
            WyNetworkHelper.sendToAllAround(new PacketParticles("kiloPress", player.field_70165_t, player.field_70163_u, player.field_70161_v), player.field_71093_bK, player.field_70165_t, player.field_70163_u, player.field_70161_v, 128.0);
            this.startExtUpdate(player);
        }
    }

    public static class HeavyPunch
    extends Ability {
        public HeavyPunch() {
            super(ListAttributes.HEAVY_PUNCH);
        }
    }

    public static class KickOffJump
    extends Ability {
        private double initialY = 255.0;
        private boolean isFlying = false;
        private int countDoon = 0;

        public KickOffJump() {
            super(ListAttributes.KICK_OFF_JUMP);
        }

        @Override
        public void passive(EntityPlayer player) {
            if (!this.isOnCooldown) {
                this.initialY = player.field_70163_u;
                super.passive(player);
            }
        }

        @Override
        public void duringPassive(EntityPlayer player, int passiveTimer) {
            if (!this.isFlying && player.field_70163_u > this.initialY) {
                this.isFlying = true;
            } else if (this.isFlying && this.countDoon <= 10) {
                KiloAbilities.movePlayer("=", player.field_70159_w, 2.5, player.field_70179_y, player);
                ++this.countDoon;
            } else if (this.isFlying && this.countDoon >= 4) {
                this.setPassiveActive(false);
                this.setCooldownActive(true);
                this.endPassive(player);
            } else if (player.field_70122_E) {
                this.initialY = player.field_70163_u;
            }
        }

        @Override
        public void endPassive(EntityPlayer player) {
            this.countDoon = 0;
            this.isFlying = false;
            this.startCooldown();
            this.startExtUpdate(player);
        }
    }

    public static class Weightless
    extends Ability {
        public Weightless() {
            super(ListAttributes.WEIGHTLESS);
        }

        @Override
        public void passive(EntityPlayer player) {
            if (!this.isOnCooldown) {
                super.passive(player);
            }
        }

        @Override
        public void duringPassive(EntityPlayer player, int passiveTimer) {
            if (player.field_70122_E) {
                this.replaceUmbrella(player);
                this.setPassiveActive(false);
                this.setCooldownActive(true);
                this.endPassive(player);
            } else if (player.func_70694_bm() != null && player.func_70694_bm().func_77973_b() == ListMisc.UmbrellaOpen) {
                double mZ = 0.0;
                double mX = 0.0;
                WyHelper.Direction dir = WyHelper.get8Directions((Entity)player);
                if (dir == WyHelper.Direction.NORTH) {
                    mZ -= 0.25;
                }
                if (dir == WyHelper.Direction.NORTH_WEST) {
                    mZ -= 0.2;
                    mX -= 0.2;
                }
                if (dir == WyHelper.Direction.SOUTH) {
                    mZ += 0.25;
                }
                if (dir == WyHelper.Direction.NORTH_EAST) {
                    mZ -= 0.2;
                    mX += 0.2;
                }
                if (dir == WyHelper.Direction.WEST) {
                    mX -= 0.25;
                }
                if (dir == WyHelper.Direction.SOUTH_WEST) {
                    mZ += 0.2;
                    mX -= 0.2;
                }
                if (dir == WyHelper.Direction.EAST) {
                    mX += 0.25;
                }
                if (dir == WyHelper.Direction.SOUTH_EAST) {
                    mZ += 0.2;
                    mX += 0.2;
                }
                player.field_70143_R = 0.0f;
                KiloAbilities.movePlayer("=", mX, -0.1, mZ, player);
            } else if (player.func_70694_bm() != null && player.func_70694_bm().func_77973_b() == ListMisc.Umbrella) {
                int slot = player.field_71071_by.field_70461_c;
                player.field_71071_by.func_70299_a(slot, new ItemStack((Item)ListMisc.UmbrellaOpen));
            } else {
                this.replaceUmbrella(player);
            }
        }

        @Override
        public void endPassive(EntityPlayer player) {
            this.setPassiveActive(false);
            this.replaceUmbrella(player);
        }

        public void replaceUmbrella(EntityPlayer player) {
            for (int count = 0; count < player.field_71071_by.func_70302_i_(); ++count) {
                if (player.field_71071_by.func_70301_a(count) == null || player.field_71071_by.func_70301_a(count).func_77973_b() != ListMisc.UmbrellaOpen) continue;
                player.field_71071_by.func_70299_a(count, new ItemStack((Item)ListMisc.Umbrella));
            }
        }
    }
}

