/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.MineMineNoMi3.abilities;

import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S0BPacketAnimation;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.MathHelper;
import net.minecraft.world.WorldServer;
import xyz.pixelatedw.MineMineNoMi3.MainConfig;
import xyz.pixelatedw.MineMineNoMi3.api.WyHelper;
import xyz.pixelatedw.MineMineNoMi3.api.abilities.Ability;
import xyz.pixelatedw.MineMineNoMi3.api.abilities.extra.AbilityProperties;
import xyz.pixelatedw.MineMineNoMi3.api.network.PacketAbilitySync;
import xyz.pixelatedw.MineMineNoMi3.api.network.WyNetworkHelper;
import xyz.pixelatedw.MineMineNoMi3.data.ExtendedEntityData;
import xyz.pixelatedw.MineMineNoMi3.helpers.DevilFruitsHelper;
import xyz.pixelatedw.MineMineNoMi3.lists.ListAttributes;
import xyz.pixelatedw.MineMineNoMi3.packets.PacketEntityVelocity;
import xyz.pixelatedw.MineMineNoMi3.packets.PacketNewAABB;
import xyz.pixelatedw.MineMineNoMi3.packets.PacketParticles;
import xyz.pixelatedw.MineMineNoMi3.packets.PacketPlayer;
import xyz.pixelatedw.MineMineNoMi3.packets.PacketSync;
import xyz.pixelatedw.MineMineNoMi3.packets.PacketSyncInfo;

public class MoguAbilities {
    public static Ability[] abilitiesArray = new Ability[]{new PowerPoint(), new MoguraBanana(), new MoguraTonpo()};

    private static void motion(String c, double x, double y, double z, EntityPlayer p) {
        WyNetworkHelper.sendTo(new PacketPlayer("motion" + c, x, y, z), (EntityPlayerMP)p);
    }

    public static class PowerPoint
    extends Ability {
        public PowerPoint() {
            super(ListAttributes.MOGU_POWER_POINT);
        }

        @Override
        public void passive(EntityPlayer player) {
            ExtendedEntityData props = ExtendedEntityData.get((EntityLivingBase)player);
            if (!this.isOnCooldown && (props.getZoanPoint().equalsIgnoreCase("n/a") || props.getZoanPoint().equalsIgnoreCase("power"))) {
                super.passive(player);
            }
        }

        @Override
        public void startPassive(EntityPlayer player) {
            ExtendedEntityData props = ExtendedEntityData.get((EntityLivingBase)player);
            if (props.getZoanPoint().isEmpty()) {
                props.setZoanPoint("n/a");
            }
            player.func_70690_d(new PotionEffect(Potion.field_76422_e.field_76415_H, Integer.MAX_VALUE, 3, true));
            WyNetworkHelper.sendTo(new PacketNewAABB(0.5f, 1.5f), (EntityPlayerMP)player);
            props.setZoanPoint("power");
            WyNetworkHelper.sendTo(new PacketSync(props), (EntityPlayerMP)player);
            WyNetworkHelper.sendToAll(new PacketSyncInfo(player.getDisplayName(), props));
        }

        @Override
        public void endPassive(EntityPlayer player) {
            ExtendedEntityData props = ExtendedEntityData.get((EntityLivingBase)player);
            player.func_82170_o(Potion.field_76422_e.field_76415_H);
            WyNetworkHelper.sendTo(new PacketNewAABB(0.6f, 1.8f), (EntityPlayerMP)player);
            props.setZoanPoint("n/a");
            WyNetworkHelper.sendTo(new PacketSync(props), (EntityPlayerMP)player);
            WyNetworkHelper.sendToAll(new PacketSyncInfo(player.getDisplayName(), props));
        }
    }

    public static class MoguraBanana
    extends Ability {
        public MoguraBanana() {
            super(ListAttributes.MOGURA_BANANA);
        }

        @Override
        public void startPassive(EntityPlayer player) {
            ExtendedEntityData props = ExtendedEntityData.get((EntityLivingBase)player);
            AbilityProperties abilityProps = AbilityProperties.get(player);
            if (!props.getZoanPoint().equals("power")) {
                this.setPassiveActive(false);
                WyNetworkHelper.sendTo(new PacketAbilitySync(abilityProps), (EntityPlayerMP)player);
                WyHelper.sendMsgToPlayer(player, "" + this.getAttribute().getAttributeName() + " can only be used while Power Point is active !");
            }
        }

        @Override
        public void hitEntity(EntityPlayer player, EntityLivingBase target) {
            double mX = (double)(-MathHelper.func_76126_a((float)(player.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(player.field_70125_A / 180.0f * (float)Math.PI))) * 0.4;
            double mZ = (double)(MathHelper.func_76134_b((float)(player.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(player.field_70125_A / 180.0f * (float)Math.PI))) * 0.4;
            double f2 = MathHelper.func_76133_a((double)(mX * mX + player.field_70181_x * player.field_70181_x + mZ * mZ));
            mX /= f2;
            mZ /= f2;
            mX += player.field_70170_p.field_73012_v.nextGaussian() * (double)0.0075f * 1.0;
            mZ += player.field_70170_p.field_73012_v.nextGaussian() * (double)0.0075f * 1.0;
            WyNetworkHelper.sendToAll(new PacketEntityVelocity(target.func_145782_y(), mX *= 2.5, 0.1, mZ *= 2.5));
            super.hitEntity(player, target);
        }
    }

    public static class MoguraTonpo
    extends Ability {
        private int initialY;
        private boolean breakBlocks;

        public MoguraTonpo() {
            super(ListAttributes.MOGURA_TONPO);
        }

        @Override
        public void use(EntityPlayer player) {
            ExtendedEntityData props = ExtendedEntityData.get((EntityLivingBase)player);
            if (!this.isOnCooldown && MainConfig.enableGriefing) {
                if (props.getZoanPoint().equals("power")) {
                    if (player.func_70093_af()) {
                        boolean i = false;
                        for (int x = -1; x < 1; ++x) {
                            for (int y = 0; y < 10; ++y) {
                                for (int z = -1; z < 1; ++z) {
                                    int posX = (int)player.field_70165_t + x;
                                    int posY = (int)player.field_70163_u - y;
                                    int posZ = (int)player.field_70161_v + z;
                                    player.func_70690_d(new PotionEffect(Potion.field_76429_m.field_76415_H, 50, 100, true));
                                    player.func_70690_d(new PotionEffect(Potion.field_76422_e.field_76415_H, 400, 2, true));
                                    Block tempBlock = player.field_70170_p.func_147439_a(posX, posY, posZ);
                                    if (!DevilFruitsHelper.placeBlockIfAllowed(player.field_70170_p, posX, posY, posZ, Blocks.field_150350_a, "all", "restricted", "ignore liquid")) continue;
                                    player.field_71071_by.func_70441_a(new ItemStack(tempBlock));
                                    WyNetworkHelper.sendToAllAround(new PacketParticles("bakuMunch", posX, posY, posZ), player.field_71093_bK, posX, posY, posZ, 128.0);
                                }
                            }
                        }
                        this.attr.setAbilityCooldown(2.0);
                    } else {
                        double mX = (double)(-MathHelper.func_76126_a((float)(player.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(player.field_70125_A / 180.0f * (float)Math.PI))) * 0.4;
                        double mZ = (double)(MathHelper.func_76134_b((float)(player.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(player.field_70125_A / 180.0f * (float)Math.PI))) * 0.4;
                        this.initialY = (int)player.field_70163_u;
                        this.breakBlocks = true;
                        double f2 = MathHelper.func_76133_a((double)(mX * mX + player.field_70181_x * player.field_70181_x + mZ * mZ));
                        mX /= f2;
                        mZ /= f2;
                        mX += player.field_70170_p.field_73012_v.nextGaussian() * (double)0.0075f * 1.0;
                        mZ += player.field_70170_p.field_73012_v.nextGaussian() * (double)0.0075f * 1.0;
                        MoguAbilities.motion("=", mX *= 4.0, player.field_70181_x, mZ *= 4.0, player);
                        this.attr.setAbilityCooldown(10.0);
                    }
                    super.use(player);
                } else {
                    WyHelper.sendMsgToPlayer(player, "" + this.getAttribute().getAttributeName() + " can only be used while Mole Point is active !");
                }
            }
        }

        @Override
        public void duringCooldown(EntityPlayer player, int currentCooldown) {
            ExtendedEntityData props = ExtendedEntityData.get((EntityLivingBase)player);
            if (currentCooldown > 100 && player.field_70163_u >= (double)this.initialY && props.getZoanPoint().equals("power")) {
                for (int[] location : WyHelper.getBlockLocationsNearby((EntityLivingBase)player, 2)) {
                    if (!((double)location[1] >= player.field_70163_u)) continue;
                    Block tempBlock = player.field_70170_p.func_147439_a(location[0], location[1], location[2]);
                    if (!DevilFruitsHelper.placeBlockIfAllowed(player.field_70170_p, location[0], location[1], location[2], Blocks.field_150350_a, "core", "foliage")) continue;
                    player.field_71071_by.func_70441_a(new ItemStack(tempBlock));
                    WyNetworkHelper.sendToAllAround(new PacketParticles("bakuMunch", location[0], location[1], location[2]), player.field_71093_bK, location[0], location[1], location[2], 128.0);
                    if (!(player.field_70170_p instanceof WorldServer)) continue;
                    ((WorldServer)player.field_70170_p).func_73039_n().func_151248_b((Entity)player, (Packet)new S0BPacketAnimation((Entity)player, 0));
                }
            } else if (currentCooldown < 10) {
                this.breakBlocks = false;
            }
        }
    }
}

