/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.MineMineNoMi3.abilities;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import xyz.pixelatedw.MineMineNoMi3.Values;
import xyz.pixelatedw.MineMineNoMi3.api.WyHelper;
import xyz.pixelatedw.MineMineNoMi3.api.abilities.Ability;
import xyz.pixelatedw.MineMineNoMi3.api.network.WyNetworkHelper;
import xyz.pixelatedw.MineMineNoMi3.data.ExtendedEntityData;
import xyz.pixelatedw.MineMineNoMi3.entities.abilityprojectiles.MokuProjectiles;
import xyz.pixelatedw.MineMineNoMi3.lists.ListAttributes;
import xyz.pixelatedw.MineMineNoMi3.packets.PacketParticles;
import xyz.pixelatedw.MineMineNoMi3.packets.PacketPlayer;

public class MokuAbilities {
    public static Ability[] abilitiesArray;

    private static void motion(String c, double x, double y, double z, EntityPlayer p) {
        WyNetworkHelper.sendTo(new PacketPlayer("motion" + c, x, y, z), (EntityPlayerMP)p);
    }

    static {
        Values.abilityWebAppExtraParams.put("whiteout", new String[]{"desc", "Shoots clouds of smoke to engulf the opponent and trap them."});
        Values.abilityWebAppExtraParams.put("whitesnake", new String[]{"desc", "Launches a long dense smoke cloud in the shape of a snake to grab the opponent and damage them."});
        Values.abilityWebAppExtraParams.put("whitelauncher", new String[]{"desc", "Transforms the user into smoke and launches them forward."});
        abilitiesArray = new Ability[]{new WhiteOut(), new WhiteSnake(), new WhiteLauncher(), new WhiteStrike()};
    }

    public static class WhiteOut
    extends Ability {
        public WhiteOut() {
            super(ListAttributes.WHITE_OUT);
        }

        @Override
        public void use(EntityPlayer player) {
            this.projectile = new MokuProjectiles.WhiteOut(player.field_70170_p, (EntityLivingBase)player, this.attr);
            super.use(player);
        }
    }

    public static class WhiteSnake
    extends Ability {
        public WhiteSnake() {
            super(ListAttributes.WHITE_SNAKE);
        }

        @Override
        public void use(EntityPlayer player) {
            this.projectile = new MokuProjectiles.WhiteSnake(player.field_70170_p, (EntityLivingBase)player, this.attr);
            super.use(player);
        }
    }

    public static class WhiteLauncher
    extends Ability {
        public WhiteLauncher() {
            super(ListAttributes.WHITE_LAUNCHER);
        }

        @Override
        public void endCharging(EntityPlayer player) {
            double mX = (double)(-MathHelper.func_76126_a((float)(player.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(player.field_70125_A / 180.0f * (float)Math.PI))) * 0.4;
            double mZ = (double)(MathHelper.func_76134_b((float)(player.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(player.field_70125_A / 180.0f * (float)Math.PI))) * 0.4;
            double mY = (double)(-MathHelper.func_76126_a((float)((player.field_70125_A + 0.0f) / 180.0f * (float)Math.PI))) * 0.4;
            double f2 = MathHelper.func_76133_a((double)(mX * mX + mY * mY + mZ * mZ));
            mX /= f2;
            mY /= f2;
            mZ /= f2;
            mX += player.field_70170_p.field_73012_v.nextGaussian() * (double)0.0075f * 1.0;
            mY += player.field_70170_p.field_73012_v.nextGaussian() * (double)0.0075f * 1.0;
            mZ += player.field_70170_p.field_73012_v.nextGaussian() * (double)0.0075f * 1.0;
            MokuAbilities.motion("=", mX *= 5.0, mY *= 1.5, mZ *= 5.0, player);
            super.endCharging(player);
        }

        @Override
        public void duringCooldown(EntityPlayer player, int currentCooldown) {
            ExtendedEntityData props = ExtendedEntityData.get((EntityLivingBase)player);
            if (currentCooldown / 20 > ListAttributes.WHITE_LAUNCHER.getAbilityCooldown() / 20 - 3) {
                for (EntityLivingBase e : WyHelper.getEntitiesNear((Entity)player, 1.6)) {
                    e.func_70097_a(DamageSource.func_76365_a((EntityPlayer)player), 2.0f * props.getDamageMultiplier());
                }
                WyNetworkHelper.sendToAllAround(new PacketParticles("whiteLauncher", (EntityLivingBase)player), player.field_71093_bK, player.field_70165_t, player.field_70163_u, player.field_70161_v, 128.0);
            }
        }
    }

    public static class WhiteStrike
    extends Ability {
        public WhiteStrike() {
            super(ListAttributes.WHITE_STRIKE);
        }

        @Override
        public void use(EntityPlayer player) {
            if (!this.isOnCooldown()) {
                WyNetworkHelper.sendToAllAround(new PacketParticles("whiteStrike", (EntityLivingBase)player), player.field_71093_bK, player.field_70165_t, player.field_70163_u, player.field_70161_v, 128.0);
            }
            super.use(player);
        }
    }
}

