/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.MineMineNoMi3.abilities;

import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import xyz.pixelatedw.MineMineNoMi3.Values;
import xyz.pixelatedw.MineMineNoMi3.api.WyHelper;
import xyz.pixelatedw.MineMineNoMi3.api.abilities.Ability;
import xyz.pixelatedw.MineMineNoMi3.entities.abilityprojectiles.NoroProjectiles;
import xyz.pixelatedw.MineMineNoMi3.lists.ListAttributes;
import xyz.pixelatedw.MineMineNoMi3.lists.ListMisc;

public class NoroAbilities {
    public static Ability[] abilitiesArray;

    static {
        Values.abilityWebAppExtraParams.put("noronorobeam", new String[]{"desc", "Shoots a beam of photons at the opponent, completely slowing them down."});
        Values.abilityWebAppExtraParams.put("noronorobeamsword", new String[]{"desc", "Focuses photons inside a hilt to create a sword."});
        Values.abilityWebAppExtraParams.put("kyubirush", new String[]{"desc", "While the opponent is slowed, the user delivers a series of punches, which hits the opponent all at once."});
        abilitiesArray = new Ability[]{new NoroNoroBeam(), new NoroNoroBeamSword(), new KyubiRush()};
    }

    public static class NoroNoroBeam
    extends Ability {
        public NoroNoroBeam() {
            super(ListAttributes.NORO_NORO_BEAM);
        }

        @Override
        public void use(EntityPlayer player) {
            this.projectile = new NoroProjectiles.NoroNoroBeam(player.field_70170_p, (EntityLivingBase)player, this.attr);
            super.use(player);
        }
    }

    public static class KyubiRush
    extends Ability {
        public KyubiRush() {
            super(ListAttributes.KYUBI_RUSH);
        }

        @Override
        public void hitEntity(EntityPlayer player, EntityLivingBase target) {
            float damageFromSlowness = 0.0f;
            if (target.func_82165_m(Potion.field_76421_d.field_76415_H)) {
                damageFromSlowness = (float)(Math.sqrt(target.func_70660_b(Potion.field_76421_d).func_76459_b()) / 2.0);
                int newTime = target.func_70660_b(Potion.field_76421_d).func_76459_b() / 2;
                int newAmplifier = target.func_70660_b(Potion.field_76421_d).func_76458_c() - 5;
                target.func_82170_o(Potion.field_76421_d.field_76415_H);
                target.func_82170_o(Potion.field_76419_f.field_76415_H);
                target.func_70690_d(new PotionEffect(Potion.field_76421_d.field_76415_H, newTime, newAmplifier));
                target.func_70690_d(new PotionEffect(Potion.field_76419_f.field_76415_H, newTime, newAmplifier));
            } else {
                damageFromSlowness = 2.0f;
            }
            super.hitEntity(player, target);
            target.func_70097_a(DamageSource.func_76365_a((EntityPlayer)player), damageFromSlowness);
        }
    }

    public static class NoroNoroBeamSword
    extends Ability {
        public NoroNoroBeamSword() {
            super(ListAttributes.NORO_NORO_BEAM_SWORD);
        }

        @Override
        public void startPassive(EntityPlayer player) {
            if (player.field_71071_by.func_70448_g() == null) {
                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, new ItemStack((Item)ListMisc.NoroNoroBeamSword));
            } else {
                WyHelper.sendMsgToPlayer(player, "Cannot equip " + this.getAttribute().getAttributeName() + " while holding another item in hand !");
                this.passive(player);
            }
        }

        @Override
        public void endPassive(EntityPlayer player) {
            player.field_71071_by.func_146027_a((Item)ListMisc.NoroNoroBeamSword, -1);
        }
    }
}

