/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.MineMineNoMi3.abilities;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S0BPacketAnimation;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.WorldServer;
import xyz.pixelatedw.MineMineNoMi3.Values;
import xyz.pixelatedw.MineMineNoMi3.api.WyHelper;
import xyz.pixelatedw.MineMineNoMi3.api.abilities.Ability;
import xyz.pixelatedw.MineMineNoMi3.api.network.WyNetworkHelper;
import xyz.pixelatedw.MineMineNoMi3.data.ExtendedEntityData;
import xyz.pixelatedw.MineMineNoMi3.entities.abilityprojectiles.OpeProjectiles;
import xyz.pixelatedw.MineMineNoMi3.helpers.DevilFruitsHelper;
import xyz.pixelatedw.MineMineNoMi3.helpers.ItemsHelper;
import xyz.pixelatedw.MineMineNoMi3.items.devilfruitextras.Heart;
import xyz.pixelatedw.MineMineNoMi3.lists.ListAttributes;
import xyz.pixelatedw.MineMineNoMi3.lists.ListMisc;
import xyz.pixelatedw.MineMineNoMi3.packets.PacketParticles;
import xyz.pixelatedw.MineMineNoMi3.packets.PacketPlayer;

public class OpeAbilities {
    public static Ability[] abilitiesArray;

    private static void motion(String c, double x, double y, double z, EntityPlayer p) {
        WyNetworkHelper.sendTo(new PacketPlayer("motion" + c, x, y, z), (EntityPlayerMP)p);
    }

    static {
        Values.abilityWebAppExtraParams.put("room", new String[]{"desc", "Creates a spherical space around the user, in which they can manipulate anything with other skills."});
        Values.abilityWebAppExtraParams.put("countershock", new String[]{"desc", "Releases a strong electrical current, which shocks the opponent."});
        Values.abilityWebAppExtraParams.put("mes", new String[]{"desc", "Removes the heart of the user's target, which they can then damage to hurt the opponent."});
        Values.abilityWebAppExtraParams.put("gammaknife", new String[]{"desc", "Creates a blade of gamma radiation, which massively damages the opponent's organs"});
        Values.abilityWebAppExtraParams.put("shambles", new String[]{"desc", "The user swaps place with the closest entity within the ROOM."});
        Values.abilityWebAppExtraParams.put("takt", new String[]{"desc", "Lifts all entities inside ROOM, making them unable to move."});
        Values.abilityWebAppExtraParams.put("injectionshot", new String[]{"desc", "While holding a weapon, the user charges at the enemy, leaving them poisoned and confused."});
        abilitiesArray = new Ability[]{new Room(), new Mes(), new CounterShock(), new GammaKnife(), new Takt(), new Shambles(), new InjectionShot()};
    }

    public static class Room
    extends Ability {
        private List<int[]> blockList = new ArrayList<int[]>();

        public Room() {
            super(ListAttributes.ROOM);
        }

        @Override
        public void passive(EntityPlayer player) {
            if (!this.isOnCooldown) {
                if (this.blockList.isEmpty()) {
                    this.blockList.addAll(WyHelper.createEmptySphere(player.field_70170_p, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v, 20, ListMisc.Ope, "air", "foliage", "liquids", "nogrief"));
                    player.field_70170_p.func_147449_b((int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v, ListMisc.OpeMid);
                    this.blockList.add(new int[]{(int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v});
                }
                super.passive(player);
            }
        }

        @Override
        public void endPassive(EntityPlayer player) {
            for (int[] blockPos : this.blockList) {
                if (player.field_70170_p.func_147439_a(blockPos[0], blockPos[1], blockPos[2]) != ListMisc.Ope && player.field_70170_p.func_147439_a(blockPos[0], blockPos[1], blockPos[2]) != ListMisc.OpeMid) continue;
                player.field_70170_p.func_147449_b(blockPos[0], blockPos[1], blockPos[2], Blocks.field_150350_a);
            }
            this.blockList = new ArrayList<int[]>();
            this.startCooldown();
            this.startExtUpdate(player);
        }
    }

    public static class CounterShock
    extends Ability {
        public CounterShock() {
            super(ListAttributes.COUNTER_SHOCK);
        }

        @Override
        public void hitEntity(EntityPlayer player, EntityLivingBase target) {
            super.hitEntity(player, target);
            WyNetworkHelper.sendTo(new PacketParticles("elThor", target.field_70165_t, target.field_70163_u, target.field_70161_v), (EntityPlayerMP)player);
        }
    }

    public static class Mes
    extends Ability {
        public Mes() {
            super(ListAttributes.MES);
        }

        @Override
        public void hitEntity(EntityPlayer player, EntityLivingBase target) {
            ExtendedEntityData targetprops = ExtendedEntityData.get(target);
            if (targetprops.hasHeart()) {
                ItemStack heart = new ItemStack(ListMisc.Heart);
                ((Heart)heart.func_77973_b()).setHeartOwner(heart, target);
                heart.func_151001_c(target.func_70005_c_() + "'s Heart");
                player.field_71071_by.func_70441_a(heart);
                targetprops.setHasHeart(false);
            }
            super.hitEntity(player, target);
        }
    }

    public static class GammaKnife
    extends Ability {
        public GammaKnife() {
            super(ListAttributes.GAMMA_KNIFE);
        }

        @Override
        public void use(EntityPlayer player) {
            if (DevilFruitsHelper.isEntityInRoom((EntityLivingBase)player)) {
                this.projectile = new OpeProjectiles.GammaKnife(player.field_70170_p, (EntityLivingBase)player, this.attr);
                super.use(player);
            } else {
                WyHelper.sendMsgToPlayer(player, "" + this.getAttribute().getAttributeName() + " can only be used inside ROOM !");
            }
        }
    }

    public static class Shambles
    extends Ability {
        public Shambles() {
            super(ListAttributes.SHAMBLES);
        }

        @Override
        public void use(EntityPlayer player) {
            if (DevilFruitsHelper.isEntityInRoom((EntityLivingBase)player)) {
                MovingObjectPosition mop;
                if (!this.isOnCooldown && (mop = WyHelper.rayTraceBlocks((Entity)player)) != null) {
                    double i = mop.field_72311_b;
                    double j = mop.field_72312_c;
                    double k = mop.field_72309_d;
                    List<EntityLivingBase> entityList = WyHelper.getEntitiesNear((int)i, (int)j, (int)k, player.field_70170_p, 4.0, EntityLivingBase.class);
                    if (entityList.size() <= 0) {
                        return;
                    }
                    EntityLivingBase target = entityList.get(0);
                    double[] beforeCoords = new double[]{player.field_70165_t, player.field_70163_u, player.field_70161_v};
                    player.func_70080_a(target.field_70165_t, target.field_70163_u, target.field_70161_v, target.field_70177_z, target.field_70125_A);
                    player.func_70634_a(target.field_70165_t, target.field_70163_u, target.field_70161_v);
                    target.func_70634_a(beforeCoords[0], beforeCoords[1], beforeCoords[2]);
                }
                super.use(player);
            } else {
                WyHelper.sendMsgToPlayer(player, "" + this.getAttribute().getAttributeName() + " can only be used inside ROOM !");
            }
        }
    }

    public static class Takt
    extends Ability {
        private HashMap<EntityLivingBase, Double> entitiesInRoom = new HashMap();

        public Takt() {
            super(ListAttributes.TAKT);
        }

        @Override
        public void passive(EntityPlayer player) {
            if (!this.isPassiveActive()) {
                if (DevilFruitsHelper.isEntityInRoom((EntityLivingBase)player)) {
                    for (EntityLivingBase entity : WyHelper.getEntitiesNear((Entity)player, 40.0)) {
                        if (!DevilFruitsHelper.isEntityInRoom(entity) || entity.equals((Object)player)) continue;
                        this.entitiesInRoom.put(entity, entity.field_70163_u + 3.0);
                    }
                    super.passive(player);
                } else {
                    WyHelper.sendMsgToPlayer(player, "" + this.getAttribute().getAttributeName() + " can only be used inside ROOM !");
                }
            } else {
                super.passive(player);
            }
        }

        @Override
        public void duringPassive(EntityPlayer player, int passiveTimer) {
            if (!DevilFruitsHelper.isEntityInRoom((EntityLivingBase)player)) {
                this.setPassiveActive(false);
                this.setCooldownActive(true);
                this.endPassive(player);
            }
            if (passiveTimer >= 160) {
                this.setPassiveActive(false);
                this.setCooldownActive(true);
                this.endPassive(player);
            }
            for (Map.Entry<EntityLivingBase, Double> pair : this.entitiesInRoom.entrySet()) {
                pair.getKey().func_70634_a(pair.getKey().field_70165_t, pair.getValue().doubleValue(), pair.getKey().field_70161_v);
                pair.getKey().field_70143_R = 0.0f;
            }
        }

        @Override
        public void endPassive(EntityPlayer player) {
            this.startCooldown();
            this.startExtUpdate(player);
            this.entitiesInRoom.clear();
        }
    }

    public static class InjectionShot
    extends Ability {
        public InjectionShot() {
            super(ListAttributes.INJECTION_SHOT);
        }

        @Override
        public void use(EntityPlayer player) {
            if (DevilFruitsHelper.isEntityInRoom((EntityLivingBase)player)) {
                if (!ItemsHelper.isSword(player.func_70694_bm())) {
                    WyHelper.sendMsgToPlayer(player, "You need a sword to use this ability !");
                    return;
                }
                if (!this.isOnCooldown) {
                    double mX = (double)(-MathHelper.func_76126_a((float)(player.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(player.field_70125_A / 180.0f * (float)Math.PI))) * 0.4;
                    double mZ = (double)(MathHelper.func_76134_b((float)(player.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(player.field_70125_A / 180.0f * (float)Math.PI))) * 0.4;
                    double f2 = MathHelper.func_76133_a((double)(mX * mX + player.field_70181_x * player.field_70181_x + mZ * mZ));
                    mX /= f2;
                    mZ /= f2;
                    mX += player.field_70170_p.field_73012_v.nextGaussian() * (double)0.0075f * 1.0;
                    mZ += player.field_70170_p.field_73012_v.nextGaussian() * (double)0.0075f * 1.0;
                    OpeAbilities.motion("=", mX *= 3.0, player.field_70181_x, mZ *= 3.0, player);
                    if (player.field_70170_p instanceof WorldServer) {
                        ((WorldServer)player.field_70170_p).func_73039_n().func_151248_b((Entity)player, (Packet)new S0BPacketAnimation((Entity)player, 0));
                    }
                }
                super.use(player);
            } else {
                WyHelper.sendMsgToPlayer(player, "" + this.getAttribute().getAttributeName() + " can only be used inside ROOM !");
            }
        }

        @Override
        public void duringCooldown(EntityPlayer player, int currentCooldown) {
            if (currentCooldown > 260) {
                for (EntityLivingBase e : WyHelper.getEntitiesNear((Entity)player, 1.6)) {
                    e.func_70097_a(DamageSource.func_76365_a((EntityPlayer)player), 20.0f);
                    e.func_70690_d(new PotionEffect(Potion.field_76436_u.field_76415_H, 200, 0));
                    e.func_70690_d(new PotionEffect(Potion.field_76431_k.field_76415_H, 200, 0));
                }
            }
        }
    }
}

