/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.MineMineNoMi3.abilities;

import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.MovingObjectPosition;
import xyz.pixelatedw.MineMineNoMi3.MainConfig;
import xyz.pixelatedw.MineMineNoMi3.abilities.effects.DFEffectOriBind;
import xyz.pixelatedw.MineMineNoMi3.api.WyHelper;
import xyz.pixelatedw.MineMineNoMi3.api.abilities.Ability;
import xyz.pixelatedw.MineMineNoMi3.entities.abilityprojectiles.OriProjectiles;
import xyz.pixelatedw.MineMineNoMi3.lists.ListAttributes;
import xyz.pixelatedw.MineMineNoMi3.lists.ListMisc;

public class OriAbilities {
    public static Ability[] abilitiesArray = new Ability[]{new GreatCage(), new PrisonBreak(), new AwaseBaori(), new Bind()};

    public static ArrayList<int[]> makeShapeSquare(EntityPlayer player, int blockX, int blockY, int blockZ, Block blockCheck, Block blockReplace) {
        Block blockToReplace;
        int count;
        ArrayList<int[]> blockList = new ArrayList<int[]>();
        for (count = blockX - 1; count < blockX + 2; ++count) {
            blockToReplace = player.field_70170_p.func_147439_a(count, blockY, blockZ);
            if (blockToReplace != blockCheck) continue;
            player.field_70170_p.func_147449_b(count, blockY, blockZ, blockReplace);
            blockList.add(new int[]{count, blockY, blockZ});
        }
        for (count = blockY - 1; count < blockY + 2; ++count) {
            blockToReplace = player.field_70170_p.func_147439_a(blockX, count, blockZ);
            if (blockToReplace != blockCheck) continue;
            player.field_70170_p.func_147449_b(blockX, count, blockZ, blockReplace);
            blockList.add(new int[]{blockX, count, blockZ});
        }
        for (count = blockZ - 1; count < blockZ + 2; ++count) {
            blockToReplace = player.field_70170_p.func_147439_a(blockX, blockY, count);
            if (blockToReplace != blockCheck) continue;
            player.field_70170_p.func_147449_b(blockX, blockY, count, blockReplace);
            blockList.add(new int[]{blockX, blockY, count});
        }
        return blockList;
    }

    public static class Bind
    extends Ability {
        public Bind() {
            super(ListAttributes.BIND);
        }

        @Override
        public void hitEntity(EntityPlayer player, EntityLivingBase target) {
            target.func_70690_d(new PotionEffect(2, 160, 40));
            target.func_70690_d(new PotionEffect(Potion.field_76421_d.field_76415_H, 160, 30));
            new DFEffectOriBind(target, 160);
            super.hitEntity(player, target);
        }
    }

    public static class AwaseBaori
    extends Ability {
        public AwaseBaori() {
            super(ListAttributes.AWASE_BAORI);
        }

        @Override
        public void use(EntityPlayer player) {
            this.projectile = new OriProjectiles.AwaseBaori(player.field_70170_p, (EntityLivingBase)player, this.attr);
            super.use(player);
        }
    }

    public static class PrisonBreak
    extends Ability {
        private ArrayList<int[]> blockList;

        public PrisonBreak() {
            super(ListAttributes.PRISON_BREAK);
        }

        @Override
        public void passive(EntityPlayer player) {
            MovingObjectPosition point = WyHelper.rayTraceBlocks((Entity)player);
            if (!this.isOnCooldown && point != null) {
                if (this.blockList == null) {
                    this.blockList = OriAbilities.makeShapeSquare(player, point.field_72311_b, point.field_72312_c, point.field_72309_d, ListMisc.OriBars, Blocks.field_150350_a);
                }
                super.passive(player);
            }
        }

        @Override
        public void endPassive(EntityPlayer player) {
            if (this.blockList != null) {
                for (int count = 0; count < this.blockList.size(); ++count) {
                    int[] currentArray = this.blockList.get(count);
                    if (player.field_70170_p.func_147439_a(currentArray[0], currentArray[1], currentArray[2]) != Blocks.field_150350_a) continue;
                    player.field_70170_p.func_147449_b(currentArray[0], currentArray[1], currentArray[2], ListMisc.OriBars);
                }
            }
            this.blockList = null;
            this.startCooldown();
            this.startExtUpdate(player);
        }
    }

    public static class GreatCage
    extends Ability {
        public GreatCage() {
            super(ListAttributes.GREAT_CAGE);
        }

        @Override
        public void use(EntityPlayer player) {
            if (!this.isOnCooldown) {
                if (MainConfig.enableGriefing) {
                    WyHelper.createEmptyCube((Entity)player, new int[]{5, 3, 5}, ListMisc.OriBars, "air");
                }
                super.use(player);
            }
        }
    }
}

