/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.MineMineNoMi3.abilities;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.DamageSource;
import xyz.pixelatedw.MineMineNoMi3.Values;
import xyz.pixelatedw.MineMineNoMi3.api.WyHelper;
import xyz.pixelatedw.MineMineNoMi3.api.abilities.Ability;
import xyz.pixelatedw.MineMineNoMi3.api.network.WyNetworkHelper;
import xyz.pixelatedw.MineMineNoMi3.entities.abilityprojectiles.RokushikiProjectiles;
import xyz.pixelatedw.MineMineNoMi3.lists.ListAttributes;
import xyz.pixelatedw.MineMineNoMi3.packets.PacketParticles;
import xyz.pixelatedw.MineMineNoMi3.packets.PacketPlayer;

public class RokushikiAbilities {
    public static final Ability SORU;
    public static final Ability TEKKAI;
    public static final Ability GEPPO;
    public static final Ability RANKYAKU;
    public static final Ability SHIGAN;
    public static final Ability KAMIE;
    public static Ability[] abilitiesArray;

    private static void motion(String c, double x, double y, double z, EntityPlayer p) {
        WyNetworkHelper.sendTo(new PacketPlayer("motion" + c, x, y, z), (EntityPlayerMP)p);
    }

    static {
        Values.abilityWebAppExtraParams.put("soru", new String[]{"desc", "Allows the user to move at an extremely high speed.", "dorikiRequiredForHumans", "500"});
        Values.abilityWebAppExtraParams.put("tekkai", new String[]{"desc", "Hardens the user's body to protect themselves, but they're unable to move.", "dorikiRequiredForHumans", "1500"});
        Values.abilityWebAppExtraParams.put("geppo", new String[]{"desc", "The user kicks the air beneath them to launch themselves into the air.", "dorikiRequiredForHumans", "4500"});
        Values.abilityWebAppExtraParams.put("rankyaku", new String[]{"desc", "By kicking at a very high speed, the user launches an air blade at the opponent.", "dorikiRequiredForHumans", "8500"});
        Values.abilityWebAppExtraParams.put("shigan", new String[]{"desc", "The user thrusts their finger at the opponent, to pierce them.", "dorikiRequiredForHumans", "3000"});
        Values.abilityWebAppExtraParams.put("kamie", new String[]{"desc", "Maked the user's body flexible in order to avoid attacks.", "dorikiRequiredForHumans", "6000"});
        SORU = new Soru();
        TEKKAI = new Tekkai();
        GEPPO = new Geppo();
        RANKYAKU = new Rankyaku();
        SHIGAN = new Shigan();
        KAMIE = new Kamie();
        abilitiesArray = new Ability[]{SORU, TEKKAI, GEPPO, RANKYAKU, SHIGAN, KAMIE};
    }

    public static class Kamie
    extends Ability {
        public Kamie() {
            super(ListAttributes.KAMIE);
        }

        @Override
        public void duringPassive(EntityPlayer player, int passiveTimer) {
            if (passiveTimer > 400) {
                this.setPassiveActive(false);
                this.startCooldown();
                this.startExtUpdate(player);
                super.endPassive(player);
            }
        }

        @Override
        public void endPassive(EntityPlayer player) {
            this.startCooldown();
            this.startExtUpdate(player);
        }
    }

    public static class Shigan
    extends Ability {
        public Shigan() {
            super(ListAttributes.SHIGAN);
        }

        @Override
        public void hitEntity(EntityPlayer player, EntityLivingBase target) {
            super.hitEntity(player, target);
            target.func_70097_a(DamageSource.func_76365_a((EntityPlayer)player), 20.0f);
        }
    }

    public static class Rankyaku
    extends Ability {
        public Rankyaku() {
            super(ListAttributes.RANKYAKU);
        }

        @Override
        public void use(EntityPlayer player) {
            this.projectile = new RokushikiProjectiles.Rankyaku(player.field_70170_p, (EntityLivingBase)player, ListAttributes.RANKYAKU);
            super.use(player);
        }
    }

    public static class Geppo
    extends Ability {
        public Geppo() {
            super(ListAttributes.GEPPO);
        }

        @Override
        public void use(EntityPlayer player) {
            if (!this.isOnCooldown) {
                WyHelper.Direction dir = WyHelper.get8Directions((Entity)player);
                double mX = 0.0;
                double mY = 0.0;
                double mZ = 0.0;
                mY = player.field_70122_E ? (mY += 1.7) : (mY += 1.86);
                if (dir == WyHelper.Direction.NORTH) {
                    mZ -= 1.0;
                }
                if (dir == WyHelper.Direction.NORTH_WEST) {
                    mZ -= 1.0;
                    mX -= 1.0;
                }
                if (dir == WyHelper.Direction.SOUTH) {
                    mZ += 1.0;
                }
                if (dir == WyHelper.Direction.NORTH_EAST) {
                    mZ -= 1.0;
                    mX += 1.0;
                }
                if (dir == WyHelper.Direction.WEST) {
                    mX -= 1.0;
                }
                if (dir == WyHelper.Direction.SOUTH_WEST) {
                    mZ += 1.0;
                    mX -= 1.0;
                }
                if (dir == WyHelper.Direction.EAST) {
                    mX += 1.0;
                }
                if (dir == WyHelper.Direction.SOUTH_EAST) {
                    mZ += 1.0;
                    mX += 1.0;
                }
                RokushikiAbilities.motion("=", mX, mY, mZ, player);
                WyNetworkHelper.sendToAllAround(new PacketParticles("geppo", (EntityLivingBase)player), player.field_71093_bK, player.field_70165_t, player.field_70163_u, player.field_70161_v, 128.0);
                super.use(player);
            }
        }
    }

    public static class Tekkai
    extends Ability {
        private int threshold = 300;

        public Tekkai() {
            super(ListAttributes.TEKKAI);
        }

        @Override
        public void duringPassive(EntityPlayer player, int passiveTimer) {
            if (passiveTimer > 2400 || this.threshold <= 0) {
                this.setPassiveActive(false);
                this.startCooldown();
                this.startExtUpdate(player);
                this.endPassive(player);
            }
            if (player.field_70737_aN > 0) {
                --this.threshold;
            }
        }

        @Override
        public void endPassive(EntityPlayer player) {
            this.startCooldown();
            this.startExtUpdate(player);
            this.threshold = 300;
            super.endPassive(player);
        }
    }

    public static class Soru
    extends Ability {
        public Soru() {
            super(ListAttributes.SORU);
        }
    }
}

