/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.MineMineNoMi3.abilities;

import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import xyz.pixelatedw.MineMineNoMi3.MainConfig;
import xyz.pixelatedw.MineMineNoMi3.Values;
import xyz.pixelatedw.MineMineNoMi3.api.WyHelper;
import xyz.pixelatedw.MineMineNoMi3.api.abilities.Ability;
import xyz.pixelatedw.MineMineNoMi3.api.math.WyMathHelper;
import xyz.pixelatedw.MineMineNoMi3.api.network.WyNetworkHelper;
import xyz.pixelatedw.MineMineNoMi3.entities.abilityprojectiles.SunaProjectiles;
import xyz.pixelatedw.MineMineNoMi3.helpers.DevilFruitsHelper;
import xyz.pixelatedw.MineMineNoMi3.lists.ListAttributes;
import xyz.pixelatedw.MineMineNoMi3.lists.ListMisc;
import xyz.pixelatedw.MineMineNoMi3.packets.PacketParticles;

public class SunaAbilities {
    public static Ability[] abilitiesArray;

    static {
        Values.abilityWebAppExtraParams.put("barjan", new String[]{"desc", "Launches a crescent-shaped wave of sand at the opponent, that dehydrates them."});
        Values.abilityWebAppExtraParams.put("grounddeath", new String[]{"desc", "Dries out the surroundings and suffucates all nearby opponents in sand."});
        Values.abilityWebAppExtraParams.put("sables", new String[]{"desc", "The user launches a compressed sandstorm at the opponent, which sends them flying."});
        Values.abilityWebAppExtraParams.put("sablespesado", new String[]{"desc", "The user launches a compressed sandstorm at the opponent, which sends them flying."});
        Values.abilityWebAppExtraParams.put("desertspada", new String[]{"desc", "The user extends their sand along the ground, splitting it and suffocating everything it its path. "});
        abilitiesArray = new Ability[]{new Barjan(), new Sables(), new SablesPesado(), new GroundDeath(), new DesertSpada(), new DesertEncierro(), new DesertGirasole()};
    }

    public static class DesertSpada
    extends Ability {
        public DesertSpada() {
            super(ListAttributes.DESERT_SPADA);
        }

        @Override
        public void use(EntityPlayer player) {
            if (!this.isOnCooldown) {
                if (MainConfig.enableGriefing) {
                    if (WyHelper.get4Directions((Entity)player) == WyHelper.Direction.NORTH) {
                        for (int i = -4; i < 6; ++i) {
                            for (int j = 0; j < 5; ++j) {
                                for (int k = 0; k < 30; ++k) {
                                    int posX = (int)player.field_70165_t + i;
                                    int posY = (int)player.field_70163_u - j + 1;
                                    int posZ = (int)player.field_70161_v - k + 2;
                                    DevilFruitsHelper.placeBlockIfAllowed(player.field_70170_p, posX, posY, posZ, ListMisc.SunaSand, "core");
                                }
                            }
                        }
                    } else if (WyHelper.get4Directions((Entity)player) == WyHelper.Direction.SOUTH) {
                        for (int i = -4; i < 6; ++i) {
                            for (int j = 0; j < 5; ++j) {
                                for (int k = 0; k < 30; ++k) {
                                    int posX = (int)player.field_70165_t + i;
                                    int posY = (int)player.field_70163_u - j + 1;
                                    int posZ = (int)player.field_70161_v + k + 2;
                                    DevilFruitsHelper.placeBlockIfAllowed(player.field_70170_p, posX, posY, posZ, ListMisc.SunaSand, "core");
                                }
                            }
                        }
                    } else if (WyHelper.get4Directions((Entity)player) == WyHelper.Direction.EAST) {
                        for (int i = 0; i < 30; ++i) {
                            for (int j = 0; j < 5; ++j) {
                                for (int k = -4; k < 6; ++k) {
                                    int posX = (int)player.field_70165_t + i + 2;
                                    int posY = (int)player.field_70163_u - j + 1;
                                    int posZ = (int)player.field_70161_v + k;
                                    DevilFruitsHelper.placeBlockIfAllowed(player.field_70170_p, posX, posY, posZ, ListMisc.SunaSand, "core");
                                }
                            }
                        }
                    } else if (WyHelper.get4Directions((Entity)player) == WyHelper.Direction.WEST) {
                        for (int i = 0; i < 30; ++i) {
                            for (int j = 0; j < 5; ++j) {
                                for (int k = -4; k < 6; ++k) {
                                    int posX = (int)player.field_70165_t - i + 2;
                                    int posY = (int)player.field_70163_u - j + 1;
                                    int posZ = (int)player.field_70161_v + k;
                                    DevilFruitsHelper.placeBlockIfAllowed(player.field_70170_p, posX, posY, posZ, ListMisc.SunaSand, "core");
                                }
                            }
                        }
                    }
                    WyNetworkHelper.sendToAllAround(new PacketParticles("desertSpada", (EntityLivingBase)player), player.field_71093_bK, player.field_70165_t, player.field_70163_u, player.field_70161_v, 128.0);
                }
                super.use(player);
            }
        }
    }

    public static class GroundDeath
    extends Ability {
        public GroundDeath() {
            super(ListAttributes.GROUND_DEATH);
        }

        @Override
        public void use(EntityPlayer player) {
            if (!this.isOnCooldown()) {
                if (MainConfig.enableGriefing) {
                    for (EntityLivingBase entityLivingBase : WyHelper.getEntitiesNear((Entity)player, 25.0)) {
                        WyHelper.createFilledCube((Entity)entityLivingBase, new int[]{2, 2, 2}, (Block)Blocks.field_150354_m, "air", "foliage");
                    }
                    WyNetworkHelper.sendToAllAround(new PacketParticles("groundDeath", player.field_70165_t, player.field_70163_u, player.field_70161_v), player.field_71093_bK, player.field_70165_t, player.field_70163_u, player.field_70161_v, 128.0);
                }
                super.use(player);
            }
        }
    }

    public static class SablesPesado
    extends Ability {
        public SablesPesado() {
            super(ListAttributes.SABLESPESADO);
        }

        @Override
        public void hitEntity(EntityPlayer player, EntityLivingBase target) {
            double newPosX = 0.0;
            double newPosY = 0.0;
            double newPosZ = 0.0;
            newPosY += 35.0;
            target.func_70690_d(new PotionEffect(Potion.field_76438_s.field_76415_H, 500, 1));
            WyHelper.Direction dir = WyHelper.get4Directions((Entity)player);
            if (dir == WyHelper.Direction.SOUTH) {
                newPosX += WyMathHelper.randomWithRange(-20, 20);
            } else if (dir == WyHelper.Direction.EAST) {
                newPosX -= WyMathHelper.randomWithRange(-20, 20);
            } else if (dir == WyHelper.Direction.NORTH) {
                newPosZ += WyMathHelper.randomWithRange(-20, 20);
            } else if (dir == WyHelper.Direction.WEST) {
                newPosZ -= WyMathHelper.randomWithRange(-20, 20);
            }
            WyNetworkHelper.sendToAllAround(new PacketParticles("sables", target), player.field_71093_bK, player.field_70165_t, player.field_70163_u, player.field_70161_v, 128.0);
            target.func_70634_a(target.field_70165_t + newPosX, target.field_70163_u + newPosY, target.field_70161_v + newPosZ);
            super.hitEntity(player, target);
        }
    }

    public static class Sables
    extends Ability {
        public Sables() {
            super(ListAttributes.SABLES);
        }

        @Override
        public void hitEntity(EntityPlayer player, EntityLivingBase target) {
            double newPosX = 0.0;
            double newPosY = 0.0;
            double newPosZ = 0.0;
            newPosY += 25.0;
            target.func_70690_d(new PotionEffect(Potion.field_76438_s.field_76415_H, 500, 1));
            WyHelper.Direction dir = WyHelper.get4Directions((Entity)player);
            if (dir == WyHelper.Direction.SOUTH) {
                newPosX += WyMathHelper.randomWithRange(-10, 10);
            } else if (dir == WyHelper.Direction.EAST) {
                newPosX -= WyMathHelper.randomWithRange(-10, 10);
            } else if (dir == WyHelper.Direction.NORTH) {
                newPosZ += WyMathHelper.randomWithRange(-10, 10);
            } else if (dir == WyHelper.Direction.WEST) {
                newPosZ -= WyMathHelper.randomWithRange(-10, 10);
            }
            WyNetworkHelper.sendToAllAround(new PacketParticles("sables", target), player.field_71093_bK, player.field_70165_t, player.field_70163_u, player.field_70161_v, 128.0);
            target.func_70634_a(target.field_70165_t + newPosX, target.field_70163_u + newPosY, target.field_70161_v + newPosZ);
            super.hitEntity(player, target);
        }
    }

    public static class Barjan
    extends Ability {
        public Barjan() {
            super(ListAttributes.BARJAN);
        }

        @Override
        public void use(EntityPlayer player) {
            this.projectile = new SunaProjectiles.Barjan(player.field_70170_p, (EntityLivingBase)player, this.attr);
            super.use(player);
        }
    }

    public static class DesertEncierro
    extends Ability {
        public DesertEncierro() {
            super(ListAttributes.DESERT_ENCIERRO);
        }

        @Override
        public void hitEntity(EntityPlayer player, EntityLivingBase target) {
            WyNetworkHelper.sendToAllAround(new PacketParticles("desertEncierro", target), player.field_71093_bK, player.field_70165_t, player.field_70163_u, player.field_70161_v, 128.0);
            super.hitEntity(player, target);
        }
    }

    public static class DesertGirasole
    extends Ability {
        public DesertGirasole() {
            super(ListAttributes.DESERT_GIRASOLE);
        }

        @Override
        public void startCharging(EntityPlayer player) {
            if (!this.isOnCooldown) {
                WyNetworkHelper.sendToAllAround(new PacketParticles("desertGirasole", (EntityLivingBase)player), player.field_71093_bK, player.field_70165_t, player.field_70163_u, player.field_70161_v, 128.0);
            }
            super.startCharging(player);
        }

        @Override
        public void endCharging(EntityPlayer player) {
            if (!this.isOnCooldown) {
                if (MainConfig.enableGriefing) {
                    for (int i = -15; i < 15; ++i) {
                        for (int j = -5; j < 5; ++j) {
                            for (int k = -15; k < 15; ++k) {
                                int posX = (int)(player.field_70165_t + (double)i + ((double)i < -WyMathHelper.randomWithRange(8, 12) || (double)i > WyMathHelper.randomWithRange(8, 12) ? WyMathHelper.randomWithRange(-5, 5) : 0.0));
                                int posY = (int)player.field_70163_u + j;
                                int posZ = (int)(player.field_70161_v + (double)k + ((double)k < -WyMathHelper.randomWithRange(8, 12) || (double)k > WyMathHelper.randomWithRange(8, 12) ? WyMathHelper.randomWithRange(-5, 5) : 0.0));
                                DevilFruitsHelper.placeBlockIfAllowed(player.field_70170_p, posX, posY, posZ, ListMisc.SunaSand, 2, "core");
                            }
                        }
                    }
                    WyNetworkHelper.sendToAllAround(new PacketParticles("desertGirasole2", (EntityLivingBase)player), player.field_71093_bK, player.field_70165_t, player.field_70163_u, player.field_70161_v, 128.0);
                }
                super.endCharging(player);
            }
        }
    }
}

