/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.MineMineNoMi3.abilities;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import xyz.pixelatedw.MineMineNoMi3.abilities.effects.DFEffectSpiderOverlay;
import xyz.pixelatedw.MineMineNoMi3.api.WyHelper;
import xyz.pixelatedw.MineMineNoMi3.api.abilities.Ability;
import xyz.pixelatedw.MineMineNoMi3.api.network.WyNetworkHelper;
import xyz.pixelatedw.MineMineNoMi3.data.ExtendedEntityData;
import xyz.pixelatedw.MineMineNoMi3.entities.abilityprojectiles.SupaProjectiles;
import xyz.pixelatedw.MineMineNoMi3.helpers.DevilFruitsHelper;
import xyz.pixelatedw.MineMineNoMi3.lists.ListAttributes;
import xyz.pixelatedw.MineMineNoMi3.packets.PacketParticles;
import xyz.pixelatedw.MineMineNoMi3.packets.PacketPlayer;
import xyz.pixelatedw.MineMineNoMi3.packets.PacketSync;

public class SupaAbilities {
    public static Ability[] abilitiesArray = new Ability[]{new Spider(), new SparClaw(), new AtomicSpurt(), new SpiralHollow(), new SparklingDaisy()};

    private static void motion(String c, double x, double y, double z, EntityPlayer p) {
        WyNetworkHelper.sendTo(new PacketPlayer("motion" + c, x, y, z), (EntityPlayerMP)p);
    }

    public static class Spider
    extends Ability {
        private int threshold = 300;

        public Spider() {
            super(ListAttributes.SPIDER);
        }

        @Override
        public void startPassive(EntityPlayer player) {
            new DFEffectSpiderOverlay((EntityLivingBase)player, 30);
            WyNetworkHelper.sendTo(new PacketSync(ExtendedEntityData.get((EntityLivingBase)player)), (EntityPlayerMP)player);
        }

        @Override
        public void duringPassive(EntityPlayer player, int passiveTimer) {
            if (passiveTimer > 2400 || this.threshold <= 0) {
                this.setPassiveActive(false);
                this.startCooldown();
                this.startExtUpdate(player);
                this.endPassive(player);
            }
            if (player.field_70737_aN > 0) {
                --this.threshold;
            }
        }

        @Override
        public void endPassive(EntityPlayer player) {
            ExtendedEntityData.get((EntityLivingBase)player).removeExtraEffects("spiderOverlay");
            WyNetworkHelper.sendTo(new PacketSync(ExtendedEntityData.get((EntityLivingBase)player)), (EntityPlayerMP)player);
            super.endPassive(player);
        }
    }

    public static class SparClaw
    extends Ability {
        public SparClaw() {
            super(ListAttributes.SPAR_CLAW);
        }

        @Override
        public void hitEntity(EntityPlayer player, EntityLivingBase target) {
            super.hitEntity(player, target);
        }
    }

    public static class AtomicSpurt
    extends Ability {
        public AtomicSpurt() {
            super(ListAttributes.ATOMIC_SPURT);
        }

        @Override
        public void duringPassive(EntityPlayer player, int passiveTime) {
            if (passiveTime > 1000) {
                this.setPassiveActive(false);
                this.startCooldown();
                this.startExtUpdate(player);
                super.endPassive(player);
            }
            WyNetworkHelper.sendToAllAround(new PacketParticles("atomicSpurt", (EntityLivingBase)player), player.field_71093_bK, player.field_70165_t, player.field_70163_u, player.field_70161_v, 128.0);
        }

        @Override
        public void endPassive(EntityPlayer player) {
            this.startCooldown();
            this.startExtUpdate(player);
        }
    }

    public static class SpiralHollow
    extends Ability {
        public SpiralHollow() {
            super(ListAttributes.SPIRAL_HOLLOW);
        }

        @Override
        public void use(EntityPlayer player) {
            this.projectile = new SupaProjectiles.SpiralHollow(player.field_70170_p, (EntityLivingBase)player, this.attr);
            super.use(player);
        }
    }

    public static class SparklingDaisy
    extends Ability {
        private int initialY;

        public SparklingDaisy() {
            super(ListAttributes.SPARKLING_DAISY);
        }

        @Override
        public void use(EntityPlayer player) {
            if (!this.isOnCooldown()) {
                ExtendedEntityData props = ExtendedEntityData.get((EntityLivingBase)player);
                double mX = (double)(-MathHelper.func_76126_a((float)(player.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(player.field_70125_A / 180.0f * (float)Math.PI))) * 0.4;
                double mZ = (double)(MathHelper.func_76134_b((float)(player.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(player.field_70125_A / 180.0f * (float)Math.PI))) * 0.4;
                this.initialY = (int)player.field_70163_u;
                double f2 = MathHelper.func_76133_a((double)(mX * mX + player.field_70181_x * player.field_70181_x + mZ * mZ));
                mX /= f2;
                mZ /= f2;
                mX += player.field_70170_p.field_73012_v.nextGaussian() * (double)0.0075f * 1.0;
                mZ += player.field_70170_p.field_73012_v.nextGaussian() * (double)0.0075f * 1.0;
                SupaAbilities.motion("=", mX *= 3.0, player.field_70181_x, mZ *= 3.0, player);
                super.use(player);
            }
        }

        @Override
        public void duringCooldown(EntityPlayer player, int currentCooldown) {
            if (currentCooldown > 180 && player.field_70163_u >= (double)this.initialY) {
                for (EntityLivingBase e : WyHelper.getEntitiesNear((Entity)player, 1.6)) {
                    e.func_70097_a(DamageSource.func_76365_a((EntityPlayer)player), 18.0f);
                }
                for (int[] location : WyHelper.getBlockLocationsNearby((EntityLivingBase)player, 4)) {
                    if (!((double)location[1] >= player.field_70163_u) || !DevilFruitsHelper.placeBlockIfAllowed(player.field_70170_p, location[0], location[1], location[2], Blocks.field_150350_a, "core", "foliage", "ores")) continue;
                    WyNetworkHelper.sendToAllAround(new PacketParticles("bakuMunch", location[0], location[1], location[2]), player.field_71093_bK, location[0], location[1], location[2], 128.0);
                }
            }
        }
    }
}

