/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.MineMineNoMi3.abilities;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S0BPacketAnimation;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.WorldServer;
import xyz.pixelatedw.MineMineNoMi3.Values;
import xyz.pixelatedw.MineMineNoMi3.api.WyHelper;
import xyz.pixelatedw.MineMineNoMi3.api.abilities.Ability;
import xyz.pixelatedw.MineMineNoMi3.api.network.WyNetworkHelper;
import xyz.pixelatedw.MineMineNoMi3.data.ExtendedEntityData;
import xyz.pixelatedw.MineMineNoMi3.entities.abilityprojectiles.SwordsmanProjectiles;
import xyz.pixelatedw.MineMineNoMi3.helpers.DevilFruitsHelper;
import xyz.pixelatedw.MineMineNoMi3.helpers.ItemsHelper;
import xyz.pixelatedw.MineMineNoMi3.lists.ListAttributes;
import xyz.pixelatedw.MineMineNoMi3.packets.PacketParticles;
import xyz.pixelatedw.MineMineNoMi3.packets.PacketPlayer;

public class SwordsmanAbilities {
    public static final Ability SHI_SHISHI_SONSON;
    public static final Ability SANBYAKUROKUJU_POUND_HO;
    public static final Ability YAKKODORI;
    public static final Ability OTATSUMAKI;
    public static Ability[] abilitiesArray;

    private static void motion(String c, double x, double y, double z, EntityPlayer p) {
        WyNetworkHelper.sendTo(new PacketPlayer("motion" + c, x, y, z), (EntityPlayerMP)p);
    }

    static {
        Values.abilityWebAppExtraParams.put("shishishisonson", new String[]{"desc", "The user dashes forward and rapidly slashes the opponent."});
        Values.abilityWebAppExtraParams.put("yakkodori", new String[]{"desc", "Launches a crescent moon-shaped slash, which destroys everything in its path."});
        Values.abilityWebAppExtraParams.put("sanbyakurokujupoundho", new String[]{"desc", "The user launches a powerful slash, causing great destruction."});
        Values.abilityWebAppExtraParams.put("otatsumaki", new String[]{"desc", "By spinning, the user creates a small tornado, which slashes and weakens nearby opponents."});
        SHI_SHISHI_SONSON = new ShiShishiSonson();
        SANBYAKUROKUJU_POUND_HO = new SanbyakurokujuPoundHo();
        YAKKODORI = new Yakkodori();
        OTATSUMAKI = new OTatsumaki();
        abilitiesArray = new Ability[]{SHI_SHISHI_SONSON, SANBYAKUROKUJU_POUND_HO, YAKKODORI, OTATSUMAKI};
    }

    public static class SanbyakurokujuPoundHo
    extends Ability {
        public SanbyakurokujuPoundHo() {
            super(ListAttributes.SANBYAKUROKUJU_POUND_HO);
        }

        @Override
        public void use(EntityPlayer player) {
            if (!ItemsHelper.isSword(player.func_70694_bm()) && !DevilFruitsHelper.canUseSwordsmanAbilities(player)) {
                WyHelper.sendMsgToPlayer(player, "You need a sword to use this ability !");
                return;
            }
            this.projectile = new SwordsmanProjectiles.SanbyakurokujuPoundHo(player.field_70170_p, (EntityLivingBase)player, ListAttributes.SANBYAKUROKUJU_POUND_HO);
            if (!this.isOnCooldown && player.field_70170_p instanceof WorldServer) {
                ((WorldServer)player.field_70170_p).func_73039_n().func_151248_b((Entity)player, (Packet)new S0BPacketAnimation((Entity)player, 0));
            }
            super.use(player);
        }
    }

    public static class ShiShishiSonson
    extends Ability {
        public ShiShishiSonson() {
            super(ListAttributes.SHI_SHISHI_SONSON);
        }

        @Override
        public void use(EntityPlayer player) {
            if (!ItemsHelper.isSword(player.func_70694_bm()) && !DevilFruitsHelper.canUseSwordsmanAbilities(player)) {
                WyHelper.sendMsgToPlayer(player, "You need a sword to use this ability !");
                return;
            }
            if (!this.isOnCooldown) {
                double mX = (double)(-MathHelper.func_76126_a((float)(player.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(player.field_70125_A / 180.0f * (float)Math.PI))) * 0.4;
                double mZ = (double)(MathHelper.func_76134_b((float)(player.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(player.field_70125_A / 180.0f * (float)Math.PI))) * 0.4;
                double f2 = MathHelper.func_76133_a((double)(mX * mX + player.field_70181_x * player.field_70181_x + mZ * mZ));
                mX /= f2;
                mZ /= f2;
                mX += player.field_70170_p.field_73012_v.nextGaussian() * (double)0.0075f * 1.0;
                mZ += player.field_70170_p.field_73012_v.nextGaussian() * (double)0.0075f * 1.0;
                SwordsmanAbilities.motion("=", mX *= 3.0, player.field_70181_x, mZ *= 3.0, player);
                if (player.field_70170_p instanceof WorldServer) {
                    ((WorldServer)player.field_70170_p).func_73039_n().func_151248_b((Entity)player, (Packet)new S0BPacketAnimation((Entity)player, 0));
                }
            }
            super.use(player);
        }

        @Override
        public void duringCooldown(EntityPlayer player, int currentCooldown) {
            ExtendedEntityData props = ExtendedEntityData.get((EntityLivingBase)player);
            if (currentCooldown > 80) {
                for (EntityLivingBase e : WyHelper.getEntitiesNear((Entity)player, 1.6)) {
                    e.func_70097_a(DamageSource.func_76365_a((EntityPlayer)player), 8.0f * props.getDamageMultiplier());
                }
            }
        }
    }

    public static class Yakkodori
    extends Ability {
        public Yakkodori() {
            super(ListAttributes.YAKKODORI);
        }

        @Override
        public void use(EntityPlayer player) {
            if (!ItemsHelper.isSword(player.func_70694_bm()) && !DevilFruitsHelper.canUseSwordsmanAbilities(player)) {
                WyHelper.sendMsgToPlayer(player, "You need a sword to use this ability !");
                return;
            }
            this.projectile = new SwordsmanProjectiles.Yakkodori(player.field_70170_p, (EntityLivingBase)player, ListAttributes.YAKKODORI);
            if (!this.isOnCooldown && player.field_70170_p instanceof WorldServer) {
                ((WorldServer)player.field_70170_p).func_73039_n().func_151248_b((Entity)player, (Packet)new S0BPacketAnimation((Entity)player, 0));
            }
            super.use(player);
        }
    }

    public static class OTatsumaki
    extends Ability {
        public OTatsumaki() {
            super(ListAttributes.O_TATSUMAKI);
        }

        @Override
        public void use(EntityPlayer player) {
            if (!ItemsHelper.isSword(player.func_70694_bm()) && !DevilFruitsHelper.canUseSwordsmanAbilities(player)) {
                WyHelper.sendMsgToPlayer(player, "You need a sword to use this ability !");
                return;
            }
            if (!this.isOnCooldown) {
                ExtendedEntityData props = ExtendedEntityData.get((EntityLivingBase)player);
                for (EntityLivingBase e : WyHelper.getEntitiesNear((Entity)player, 2.5)) {
                    e.func_70097_a(DamageSource.func_76365_a((EntityPlayer)player), 12.0f * props.getDamageMultiplier());
                    e.func_70690_d(new PotionEffect(Potion.field_76437_t.field_76415_H, 200, 1, true));
                }
                WyNetworkHelper.sendToAllAround(new PacketParticles("kokuteiCross", (EntityLivingBase)player), player.field_71093_bK, player.field_70165_t, player.field_70163_u, player.field_70161_v, 128.0);
                if (player.field_70170_p instanceof WorldServer) {
                    ((WorldServer)player.field_70170_p).func_73039_n().func_151248_b((Entity)player, (Packet)new S0BPacketAnimation((Entity)player, 0));
                }
            }
            super.use(player);
        }
    }
}

