/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.MineMineNoMi3.abilities;

import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.DamageSource;
import xyz.pixelatedw.MineMineNoMi3.Values;
import xyz.pixelatedw.MineMineNoMi3.api.WyHelper;
import xyz.pixelatedw.MineMineNoMi3.api.abilities.Ability;
import xyz.pixelatedw.MineMineNoMi3.api.network.WyNetworkHelper;
import xyz.pixelatedw.MineMineNoMi3.data.ExtendedEntityData;
import xyz.pixelatedw.MineMineNoMi3.entities.abilityprojectiles.ToriPhoenixProjectiles;
import xyz.pixelatedw.MineMineNoMi3.lists.ListAttributes;
import xyz.pixelatedw.MineMineNoMi3.packets.PacketParticles;
import xyz.pixelatedw.MineMineNoMi3.packets.PacketPlayer;
import xyz.pixelatedw.MineMineNoMi3.packets.PacketSync;
import xyz.pixelatedw.MineMineNoMi3.packets.PacketSyncInfo;

public class ToriPhoenixAbilities {
    public static Ability[] abilitiesArray;

    private static void motion(String c, double x, double y, double z, EntityPlayer p) {
        WyNetworkHelper.sendTo(new PacketPlayer("motion" + c, x, y, z), (EntityPlayerMP)p);
    }

    static {
        Values.abilityWebAppExtraParams.put("hybridpoint", new String[]{"desc", "The user transforms into a phoenix-human hybrid, which allows them to fly. Allows the user to use 'Phoenix Goen' "});
        Values.abilityWebAppExtraParams.put("phoenixpoint", new String[]{"desc", "The user fully transforms into a phoenix, allowing them to fly at great speed. Allows the user to use both 'Phoenix Goen' and 'Tensei no Soen'"});
        Values.abilityWebAppExtraParams.put("phoenixgoen", new String[]{"desc", "Launches a powerful fiery shockwave made of blue flames at the target."});
        Values.abilityWebAppExtraParams.put("tenseinosoen", new String[]{"desc", "While in the air, the user amasses spiraling flames, then slams into the ground, releasing a massive shockwave."});
        Values.abilityWebAppExtraParams.put("blueflamesofresurrection", new String[]{"desc", "Blue phoenix flames grant the user regeneration."});
        Values.abilityWebAppExtraParams.put("flameofrestoration", new String[]{"desc", "Uses the blue flames to heal the target."});
        abilitiesArray = new Ability[]{new PhoenixPoint(), new HybridPoint(), new BlueFlamesOfResurrection(), new FlameOfRestoration(), new PhoenixGoen(), new TenseiNoSoen()};
    }

    public static class PhoenixPoint
    extends Ability {
        public PhoenixPoint() {
            super(ListAttributes.PHOENIX_FULL_POINT);
        }

        @Override
        public void passive(EntityPlayer player) {
            ExtendedEntityData props = ExtendedEntityData.get((EntityLivingBase)player);
            if (!this.isOnCooldown && (props.getZoanPoint().equalsIgnoreCase("n/a") || props.getZoanPoint().equalsIgnoreCase("full"))) {
                super.passive(player);
            }
        }

        @Override
        public void startPassive(EntityPlayer player) {
            ExtendedEntityData props = ExtendedEntityData.get((EntityLivingBase)player);
            if (props.getZoanPoint().isEmpty()) {
                props.setZoanPoint("n/a");
            }
            props.setZoanPoint("full");
            WyNetworkHelper.sendTo(new PacketSync(props), (EntityPlayerMP)player);
            WyNetworkHelper.sendToAll(new PacketSyncInfo(player.getDisplayName(), props));
        }

        @Override
        public void endPassive(EntityPlayer player) {
            ExtendedEntityData props = ExtendedEntityData.get((EntityLivingBase)player);
            props.setZoanPoint("n/a");
            WyNetworkHelper.sendTo(new PacketSync(props), (EntityPlayerMP)player);
            WyNetworkHelper.sendToAll(new PacketSyncInfo(player.getDisplayName(), props));
        }
    }

    public static class BlueFlamesOfResurrection
    extends Ability {
        public BlueFlamesOfResurrection() {
            super(ListAttributes.BLUE_FLAMES_OF_RESURRECTION);
        }

        @Override
        public void use(EntityPlayer player) {
            if (!this.isOnCooldown) {
                WyNetworkHelper.sendTo(new PacketParticles("blueFlames", (EntityLivingBase)player), (EntityPlayerMP)player);
            }
            super.use(player);
        }
    }

    public static class FlameOfRestoration
    extends Ability {
        public FlameOfRestoration() {
            super(ListAttributes.FLAME_OF_RESTORATION);
        }

        @Override
        public void hitEntity(EntityPlayer player, EntityLivingBase target) {
            super.hitEntity(player, target);
            if (target.func_110143_aJ() + 6.0f < target.func_110138_aP()) {
                target.func_70606_j(target.func_110143_aJ() + 6.0f);
            } else {
                target.func_70606_j(target.func_110138_aP());
            }
            WyNetworkHelper.sendTo(new PacketParticles("blueFlames", (EntityLivingBase)player), (EntityPlayerMP)player);
        }
    }

    public static class PhoenixGoen
    extends Ability {
        public PhoenixGoen() {
            super(ListAttributes.PHOENIX_GOEN);
        }

        @Override
        public void use(EntityPlayer player) {
            ExtendedEntityData props = ExtendedEntityData.get((EntityLivingBase)player);
            if ((props.getZoanPoint().equals("full") || props.getZoanPoint().equals("hybrid")) && !this.isOnCooldown) {
                for (int i = 0; i < 100; ++i) {
                    double offsetX = ((double)new Random().nextInt(20) + 1.0 - 5.0) / 5.0;
                    double offsetY = ((double)new Random().nextInt(20) + 1.0 - 20.0) / 10.0;
                    double offsetZ = ((double)new Random().nextInt(20) + 1.0 - 5.0) / 5.0;
                    this.projectile = new ToriPhoenixProjectiles.PhoenixGoen(player.field_70170_p, (EntityLivingBase)player, this.attr);
                    this.projectile.func_70012_b(player.field_70165_t - 1.0 + offsetX, player.field_70163_u + 2.0 + offsetY, player.field_70161_v + offsetZ, player.field_70726_aT, player.field_71109_bG);
                    player.field_70170_p.func_72838_d((Entity)this.projectile);
                }
                WyNetworkHelper.sendTo(new PacketSync(props), (EntityPlayerMP)player);
                super.use(player);
            } else if (!props.getZoanPoint().equals("full") && !props.getZoanPoint().equals("hybrid")) {
                WyHelper.sendMsgToPlayer(player, "" + this.getAttribute().getAttributeName() + " can only be used while Phoenix Point or Hybrid Point is active !");
            }
        }
    }

    public static class TenseiNoSoen
    extends Ability {
        private int particlesSpawned = 0;

        public TenseiNoSoen() {
            super(ListAttributes.TENSEI_NO_SOEN);
        }

        @Override
        public void startCharging(EntityPlayer player) {
            ExtendedEntityData props = ExtendedEntityData.get((EntityLivingBase)player);
            this.particlesSpawned = 0;
            if (props.getZoanPoint().equals("full") && !this.isOnCooldown) {
                if (!player.field_70122_E) {
                    WyNetworkHelper.sendToAllAround(new PacketParticles("tenseiNoSoen1", (EntityLivingBase)player), player.field_71093_bK, player.field_70165_t, player.field_70163_u, player.field_70161_v, 128.0);
                    super.startCharging(player);
                } else {
                    WyHelper.sendMsgToPlayer(player, "" + this.getAttribute().getAttributeName() + " can only be used while airborne !");
                }
            } else if (!props.getZoanPoint().equals("full")) {
                WyHelper.sendMsgToPlayer(player, "" + this.getAttribute().getAttributeName() + " can only be used while Phoenix Point is active !");
            }
        }

        @Override
        public void endCharging(EntityPlayer player) {
            player.field_70143_R = 0.0f;
            ToriPhoenixAbilities.motion("=", 0.0, -100.0, 0.0, player);
            super.endCharging(player);
        }

        @Override
        public void duringCooldown(EntityPlayer player, int currentCooldown) {
            if (currentCooldown > 560) {
                if (player.field_70122_E && this.particlesSpawned < 10) {
                    WyNetworkHelper.sendToAllAround(new PacketParticles("tenseiNoSoen2", (EntityLivingBase)player), player.field_71093_bK, player.field_70165_t, player.field_70163_u, player.field_70161_v, 128.0);
                    ++this.particlesSpawned;
                }
                for (EntityLivingBase e : WyHelper.getEntitiesNear((Entity)player, 20.0)) {
                    if (!(e.field_70163_u >= player.field_70163_u)) continue;
                    e.func_70097_a(DamageSource.func_76365_a((EntityPlayer)player), 30.0f);
                }
            }
        }
    }

    public static class HybridPoint
    extends Ability {
        public HybridPoint() {
            super(ListAttributes.PHOENIX_HYBRID_POINT);
        }

        @Override
        public void passive(EntityPlayer player) {
            ExtendedEntityData props = ExtendedEntityData.get((EntityLivingBase)player);
            if (!this.isOnCooldown && (props.getZoanPoint().equalsIgnoreCase("n/a") || props.getZoanPoint().equalsIgnoreCase("hybrid"))) {
                super.passive(player);
            }
        }

        @Override
        public void startPassive(EntityPlayer player) {
            ExtendedEntityData props = ExtendedEntityData.get((EntityLivingBase)player);
            if (props.getZoanPoint().isEmpty()) {
                props.setZoanPoint("n/a");
            }
            props.setZoanPoint("hybrid");
            WyNetworkHelper.sendTo(new PacketSync(props), (EntityPlayerMP)player);
            WyNetworkHelper.sendToAll(new PacketSyncInfo(player.getDisplayName(), props));
        }

        @Override
        public void endPassive(EntityPlayer player) {
            ExtendedEntityData props = ExtendedEntityData.get((EntityLivingBase)player);
            props.setZoanPoint("n/a");
            WyNetworkHelper.sendTo(new PacketSync(props), (EntityPlayerMP)player);
            WyNetworkHelper.sendToAll(new PacketSyncInfo(player.getDisplayName(), props));
        }
    }
}

