/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.MineMineNoMi3.abilities;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import xyz.pixelatedw.MineMineNoMi3.Values;
import xyz.pixelatedw.MineMineNoMi3.api.WyHelper;
import xyz.pixelatedw.MineMineNoMi3.api.abilities.Ability;
import xyz.pixelatedw.MineMineNoMi3.api.abilities.extra.AbilityProperties;
import xyz.pixelatedw.MineMineNoMi3.api.network.PacketAbilitySync;
import xyz.pixelatedw.MineMineNoMi3.api.network.WyNetworkHelper;
import xyz.pixelatedw.MineMineNoMi3.data.ExtendedEntityData;
import xyz.pixelatedw.MineMineNoMi3.lists.ListAttributes;
import xyz.pixelatedw.MineMineNoMi3.packets.PacketNewAABB;
import xyz.pixelatedw.MineMineNoMi3.packets.PacketParticles;
import xyz.pixelatedw.MineMineNoMi3.packets.PacketPlayer;
import xyz.pixelatedw.MineMineNoMi3.packets.PacketSync;
import xyz.pixelatedw.MineMineNoMi3.packets.PacketSyncInfo;

public class UshiBisonAbilities {
    public static Ability[] abilitiesArray;

    private static void motion(String c, double x, double y, double z, EntityPlayer p) {
        WyNetworkHelper.sendTo(new PacketPlayer("motion" + c, x, y, z), (EntityPlayerMP)p);
    }

    static {
        Values.abilityWebAppExtraParams.put("bisonpowerpoint", new String[]{"desc", "The user transforms into a half-bison hybrid, which focuses on strength, Allows the user to use 'Kokutei Cross' and 'Fiddle Banff'"});
        Values.abilityWebAppExtraParams.put("bisonspeedpoint", new String[]{"desc", ""});
        Values.abilityWebAppExtraParams.put("kokuteicross", new String[]{"desc", "The transformed user crosses their hooves to hit the opponent."});
        Values.abilityWebAppExtraParams.put("fiddlebanff", new String[]{"desc", "The transformed user dashes towards the opponent to crash against them with great power."});
        abilitiesArray = new Ability[]{new PowerPoint(), new SpeedPoint(), new FiddleBanff(), new KokuteiCross()};
    }

    public static class KokuteiCross
    extends Ability {
        public KokuteiCross() {
            super(ListAttributes.KOKUTEI_CROSS);
        }

        @Override
        public void startPassive(EntityPlayer player) {
            ExtendedEntityData props = ExtendedEntityData.get((EntityLivingBase)player);
            AbilityProperties abilityProps = AbilityProperties.get(player);
            if (!props.getZoanPoint().equals("power")) {
                this.setPassiveActive(false);
                WyNetworkHelper.sendTo(new PacketAbilitySync(abilityProps), (EntityPlayerMP)player);
                WyHelper.sendMsgToPlayer(player, "" + this.getAttribute().getAttributeName() + " can only be used while Power Point is active !");
            }
        }

        @Override
        public void hitEntity(EntityPlayer player, EntityLivingBase target) {
            ExtendedEntityData props = ExtendedEntityData.get((EntityLivingBase)player);
            if (props.getZoanPoint().equals("power")) {
                super.hitEntity(player, target);
                target.func_70097_a(DamageSource.func_76365_a((EntityPlayer)player), 20.0f);
                WyNetworkHelper.sendToAllAround(new PacketParticles("kokuteiCross", target), player.field_71093_bK, player.field_70165_t, player.field_70163_u, player.field_70161_v, 128.0);
                double mX = (double)(-MathHelper.func_76126_a((float)(player.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(player.field_70125_A / 180.0f * (float)Math.PI))) * 0.4;
                double mZ = (double)(MathHelper.func_76134_b((float)(player.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(player.field_70125_A / 180.0f * (float)Math.PI))) * 0.4;
                double f2 = MathHelper.func_76133_a((double)(mX * mX + player.field_70181_x * player.field_70181_x + mZ * mZ));
                mX /= f2;
                mZ /= f2;
                mX += player.field_70170_p.field_73012_v.nextGaussian() * (double)0.0075f * 1.0;
                mZ += player.field_70170_p.field_73012_v.nextGaussian() * (double)0.0075f * 1.0;
                UshiBisonAbilities.motion("=", mX *= -0.7, player.field_70181_x, mZ *= -0.7, player);
            } else {
                this.setPassiveActive(false);
                WyHelper.sendMsgToPlayer(player, "" + this.getAttribute().getAttributeName() + " can only be used while Power Point is active !");
            }
        }
    }

    public static class FiddleBanff
    extends Ability {
        public FiddleBanff() {
            super(ListAttributes.FIDDLE_BANFF);
        }

        @Override
        public void use(EntityPlayer player) {
            ExtendedEntityData props = ExtendedEntityData.get((EntityLivingBase)player);
            if ((props.getZoanPoint().equals("power") || props.getZoanPoint().equals("speed")) && !this.isOnCooldown) {
                double mX = (double)(-MathHelper.func_76126_a((float)(player.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(player.field_70125_A / 180.0f * (float)Math.PI))) * 0.4;
                double mZ = (double)(MathHelper.func_76134_b((float)(player.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(player.field_70125_A / 180.0f * (float)Math.PI))) * 0.4;
                double f2 = MathHelper.func_76133_a((double)(mX * mX + player.field_70181_x * player.field_70181_x + mZ * mZ));
                mX /= f2;
                mZ /= f2;
                mX += player.field_70170_p.field_73012_v.nextGaussian() * (double)0.0075f * 1.0;
                mZ += player.field_70170_p.field_73012_v.nextGaussian() * (double)0.0075f * 1.0;
                UshiBisonAbilities.motion("=", mX *= 5.0, player.field_70181_x, mZ *= 5.0, player);
                super.use(player);
            } else if (!props.getZoanPoint().equals("power") && !props.getZoanPoint().equals("speed")) {
                WyHelper.sendMsgToPlayer(player, "" + this.getAttribute().getAttributeName() + " can only be used while Power Point or Speed Point is active !");
            }
        }

        @Override
        public void duringCooldown(EntityPlayer player, int currentCooldown) {
            if (currentCooldown > 110) {
                for (EntityLivingBase e : WyHelper.getEntitiesNear((Entity)player, 1.6)) {
                    e.func_70097_a(DamageSource.func_76365_a((EntityPlayer)player), 6.0f);
                }
            }
        }
    }

    public static class SpeedPoint
    extends Ability {
        public SpeedPoint() {
            super(ListAttributes.BISON_SPEED_POINT);
        }

        @Override
        public void passive(EntityPlayer player) {
            ExtendedEntityData props = ExtendedEntityData.get((EntityLivingBase)player);
            if (!this.isOnCooldown && (props.getZoanPoint().equalsIgnoreCase("n/a") || props.getZoanPoint().equalsIgnoreCase("speed"))) {
                super.passive(player);
            }
        }

        @Override
        public void startPassive(EntityPlayer player) {
            ExtendedEntityData props = ExtendedEntityData.get((EntityLivingBase)player);
            if (props.getZoanPoint().isEmpty()) {
                props.setZoanPoint("n/a");
            }
            props.setZoanPoint("speed");
            WyNetworkHelper.sendTo(new PacketSync(props), (EntityPlayerMP)player);
            WyNetworkHelper.sendToAll(new PacketSyncInfo(player.getDisplayName(), props));
        }

        @Override
        public void endPassive(EntityPlayer player) {
            ExtendedEntityData props = ExtendedEntityData.get((EntityLivingBase)player);
            props.setZoanPoint("n/a");
            WyNetworkHelper.sendTo(new PacketSync(props), (EntityPlayerMP)player);
            WyNetworkHelper.sendToAll(new PacketSyncInfo(player.getDisplayName(), props));
        }
    }

    public static class PowerPoint
    extends Ability {
        public PowerPoint() {
            super(ListAttributes.BISON_POWER_POINT);
        }

        @Override
        public void passive(EntityPlayer player) {
            ExtendedEntityData props = ExtendedEntityData.get((EntityLivingBase)player);
            if (!this.isOnCooldown && (props.getZoanPoint().equalsIgnoreCase("n/a") || props.getZoanPoint().equalsIgnoreCase("power"))) {
                super.passive(player);
            }
        }

        @Override
        public void startPassive(EntityPlayer player) {
            ExtendedEntityData props = ExtendedEntityData.get((EntityLivingBase)player);
            if (props.getZoanPoint().isEmpty()) {
                props.setZoanPoint("n/a");
            }
            WyNetworkHelper.sendTo(new PacketNewAABB(1.5f, 2.5f), (EntityPlayerMP)player);
            props.setZoanPoint("power");
            WyNetworkHelper.sendTo(new PacketSync(props), (EntityPlayerMP)player);
            WyNetworkHelper.sendToAll(new PacketSyncInfo(player.getDisplayName(), props));
        }

        @Override
        public void endPassive(EntityPlayer player) {
            ExtendedEntityData props = ExtendedEntityData.get((EntityLivingBase)player);
            WyNetworkHelper.sendTo(new PacketNewAABB(0.6f, 1.8f), (EntityPlayerMP)player);
            props.setZoanPoint("n/a");
            WyNetworkHelper.sendTo(new PacketSync(props), (EntityPlayerMP)player);
            WyNetworkHelper.sendToAll(new PacketSyncInfo(player.getDisplayName(), props));
        }
    }
}

