/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.MineMineNoMi3.abilities;

import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.potion.Potion;
import xyz.pixelatedw.MineMineNoMi3.api.WyHelper;
import xyz.pixelatedw.MineMineNoMi3.api.abilities.Ability;
import xyz.pixelatedw.MineMineNoMi3.api.network.WyNetworkHelper;
import xyz.pixelatedw.MineMineNoMi3.data.ExtendedEntityData;
import xyz.pixelatedw.MineMineNoMi3.entities.abilityprojectiles.UshiGiraffeProjectiles;
import xyz.pixelatedw.MineMineNoMi3.lists.ListAttributes;
import xyz.pixelatedw.MineMineNoMi3.packets.PacketNewAABB;
import xyz.pixelatedw.MineMineNoMi3.packets.PacketSync;
import xyz.pixelatedw.MineMineNoMi3.packets.PacketSyncInfo;

public class UshiGiraffeAbilities {
    public static Ability[] abilitiesArray = new Ability[]{new PowerPoint(), new SpeedPoint(), new Bigan(), new RankyakuHyobiGiraf()};

    public static class SpeedPoint
    extends Ability {
        public SpeedPoint() {
            super(ListAttributes.GIRAFFE_SPEED_POINT);
        }

        @Override
        public void passive(EntityPlayer player) {
            ExtendedEntityData props = ExtendedEntityData.get((EntityLivingBase)player);
            if (!this.isOnCooldown && (props.getZoanPoint().equalsIgnoreCase("n/a") || props.getZoanPoint().equalsIgnoreCase("speed"))) {
                super.passive(player);
            }
        }

        @Override
        public void startPassive(EntityPlayer player) {
            ExtendedEntityData props = ExtendedEntityData.get((EntityLivingBase)player);
            if (props.getZoanPoint().isEmpty()) {
                props.setZoanPoint("n/a");
            }
            WyNetworkHelper.sendTo(new PacketNewAABB(1.2f, 3.1f), (EntityPlayerMP)player);
            props.setZoanPoint("speed");
            WyNetworkHelper.sendTo(new PacketSync(props), (EntityPlayerMP)player);
            WyNetworkHelper.sendToAll(new PacketSyncInfo(player.getDisplayName(), props));
        }

        @Override
        public void endPassive(EntityPlayer player) {
            ExtendedEntityData props = ExtendedEntityData.get((EntityLivingBase)player);
            player.func_82170_o(Potion.field_76424_c.field_76415_H);
            player.func_82170_o(Potion.field_76430_j.field_76415_H);
            WyNetworkHelper.sendTo(new PacketNewAABB(0.6f, 1.8f), (EntityPlayerMP)player);
            props.setZoanPoint("n/a");
            WyNetworkHelper.sendTo(new PacketSync(props), (EntityPlayerMP)player);
            WyNetworkHelper.sendToAll(new PacketSyncInfo(player.getDisplayName(), props));
        }
    }

    public static class PowerPoint
    extends Ability {
        public PowerPoint() {
            super(ListAttributes.GIRAFFE_POWER_POINT);
        }

        @Override
        public void passive(EntityPlayer player) {
            ExtendedEntityData props = ExtendedEntityData.get((EntityLivingBase)player);
            if (!this.isOnCooldown && (props.getZoanPoint().equalsIgnoreCase("n/a") || props.getZoanPoint().equalsIgnoreCase("power"))) {
                super.passive(player);
            }
        }

        @Override
        public void startPassive(EntityPlayer player) {
            ExtendedEntityData props = ExtendedEntityData.get((EntityLivingBase)player);
            if (props.getZoanPoint().isEmpty()) {
                props.setZoanPoint("n/a");
            }
            WyNetworkHelper.sendTo(new PacketNewAABB(1.5f, 3.2f), (EntityPlayerMP)player);
            props.setZoanPoint("power");
            WyNetworkHelper.sendTo(new PacketSync(props), (EntityPlayerMP)player);
            WyNetworkHelper.sendToAll(new PacketSyncInfo(player.getDisplayName(), props));
        }

        @Override
        public void endPassive(EntityPlayer player) {
            ExtendedEntityData props = ExtendedEntityData.get((EntityLivingBase)player);
            WyNetworkHelper.sendTo(new PacketNewAABB(0.6f, 1.8f), (EntityPlayerMP)player);
            props.setZoanPoint("n/a");
            WyNetworkHelper.sendTo(new PacketSync(props), (EntityPlayerMP)player);
            WyNetworkHelper.sendToAll(new PacketSyncInfo(player.getDisplayName(), props));
        }
    }

    public static class Bigan
    extends Ability {
        public Bigan() {
            super(ListAttributes.BIGAN);
        }

        @Override
        public void use(EntityPlayer player) {
            ExtendedEntityData props = ExtendedEntityData.get((EntityLivingBase)player);
            if ((props.getZoanPoint().equals("power") || props.getZoanPoint().equals("speed")) && !this.isOnCooldown) {
                this.projectile = new UshiGiraffeProjectiles.Bigan(player.field_70170_p, (EntityLivingBase)player, this.attr);
                super.use(player);
            } else if (!props.getZoanPoint().equals("power") && !props.getZoanPoint().equals("speed")) {
                WyHelper.sendMsgToPlayer(player, "" + this.getAttribute().getAttributeName() + " can only be used while Power Point or Speed Point is active !");
            }
        }
    }

    public static class RankyakuHyobiGiraf
    extends Ability {
        public RankyakuHyobiGiraf() {
            super(ListAttributes.RankyakuHyobiGiraf);
        }

        @Override
        public void use(EntityPlayer player) {
            ExtendedEntityData props = ExtendedEntityData.get((EntityLivingBase)player);
            if (!this.isOnCooldown && props.getZoanPoint().equalsIgnoreCase("power") || props.getZoanPoint().equals("speed") && !this.isOnCooldown) {
                this.projectile = new UshiGiraffeProjectiles.Rankyaku(player.field_70170_p, (EntityLivingBase)player, ListAttributes.RankyakuHyobiGiraf);
            }
            super.use(player);
        }
    }
}

