/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.MineMineNoMi3.abilities;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import xyz.pixelatedw.MineMineNoMi3.api.WyHelper;
import xyz.pixelatedw.MineMineNoMi3.api.abilities.Ability;
import xyz.pixelatedw.MineMineNoMi3.api.network.WyNetworkHelper;
import xyz.pixelatedw.MineMineNoMi3.entities.abilityprojectiles.WeatherProjectiles;
import xyz.pixelatedw.MineMineNoMi3.entities.mobs.misc.EntityMirageClone;
import xyz.pixelatedw.MineMineNoMi3.helpers.DevilFruitsHelper;
import xyz.pixelatedw.MineMineNoMi3.helpers.ItemsHelper;
import xyz.pixelatedw.MineMineNoMi3.items.weapons.ClimaTact;
import xyz.pixelatedw.MineMineNoMi3.lists.ListAttributes;
import xyz.pixelatedw.MineMineNoMi3.packets.PacketParticles;

public class WeatherAbilities {
    public static final Ability HEAT_BALL = new HeatBall();
    public static final Ability COOL_BALL = new CoolBall();
    public static final Ability THUNDER_BALL = new ThunderBall();
    public static final Ability GUST_SWORD = new GustSword();
    public static final Ability WEATHER_EGG = new WeatherEgg();
    public static Ability[] abilitiesArray = new Ability[]{HEAT_BALL, COOL_BALL, THUNDER_BALL, GUST_SWORD, WEATHER_EGG};

    public static class HeatBall
    extends Ability {
        public HeatBall() {
            super(ListAttributes.HEAT_BALL);
        }

        @Override
        public void use(EntityPlayer player) {
            if (!this.isOnCooldown()) {
                ItemStack stack = player.func_70694_bm();
                if (stack == null || !(stack.func_77973_b() instanceof ClimaTact)) {
                    WyHelper.sendMsgToPlayer(player, "Cannot use " + this.getAttribute().getAttributeName() + " without a Clima Tact in hand!");
                    return;
                }
                ClimaTact climaTact = (ClimaTact)stack.func_77973_b();
                if (player.func_70093_af()) {
                    climaTact.chargeWeatherBall(stack, "H");
                } else {
                    WeatherProjectiles.HeatBall proj = new WeatherProjectiles.HeatBall(player.field_70170_p, (EntityLivingBase)player, ListAttributes.HEAT_BALL);
                    proj.func_70012_b(player.field_70165_t, player.field_70163_u + (double)player.func_70047_e(), player.field_70161_v, player.field_70177_z, player.field_70125_A);
                    player.field_70170_p.func_72838_d((Entity)proj);
                }
                if (climaTact.checkCharge(stack).length() == 3) {
                    String tempo = climaTact.checkCharge(stack);
                    if (tempo.equalsIgnoreCase("CCH")) {
                        WeatherProjectiles.EntityMirageTempoCloud smokeCloud = new WeatherProjectiles.EntityMirageTempoCloud(player.field_70170_p);
                        smokeCloud.setLife(50);
                        smokeCloud.func_70012_b(player.field_70165_t, player.field_70163_u + 1.0, player.field_70161_v, 0.0f, 0.0f);
                        smokeCloud.field_70159_w = 0.0;
                        smokeCloud.field_70179_y = 0.0;
                        smokeCloud.field_70181_x = 0.0;
                        smokeCloud.setThrower(player);
                        player.field_70170_p.func_72838_d((Entity)smokeCloud);
                        for (int i = 0; i < 5; ++i) {
                            EntityMirageClone mirageClone = new EntityMirageClone(player.field_70170_p, player);
                            mirageClone.func_70080_a(player.field_70165_t, player.field_70163_u, player.field_70161_v, 180.0f, 0.0f);
                            player.field_70170_p.func_72838_d((Entity)mirageClone);
                        }
                        climaTact.emptyCharge(stack);
                        super.use(player);
                        DevilFruitsHelper.sendShounenScream(player, "Mirage Tempo", 0);
                        return;
                    }
                    WyHelper.sendMsgToPlayer(player, "Failed Tempo");
                    WyNetworkHelper.sendToAllAround(new PacketParticles("commonExplosion", player.field_70165_t, player.field_70163_u - 1.0, player.field_70161_v), player.field_71093_bK, player.field_70165_t, player.field_70163_u, player.field_70161_v, 128.0);
                    climaTact.emptyCharge(stack);
                    super.use(player);
                    return;
                }
                super.use(player);
            }
        }
    }

    public static class CoolBall
    extends Ability {
        public CoolBall() {
            super(ListAttributes.COOL_BALL);
        }

        @Override
        public void use(EntityPlayer player) {
            if (!this.isOnCooldown()) {
                ItemStack stack = player.func_70694_bm();
                if (stack == null || !(stack.func_77973_b() instanceof ClimaTact)) {
                    WyHelper.sendMsgToPlayer(player, "Cannot use " + this.getAttribute().getAttributeName() + " without a Clima Tact in hand!");
                    return;
                }
                ClimaTact climaTact = (ClimaTact)stack.func_77973_b();
                if (player.func_70093_af()) {
                    climaTact.chargeWeatherBall(stack, "C");
                } else {
                    WeatherProjectiles.CoolBall proj = new WeatherProjectiles.CoolBall(player.field_70170_p, (EntityLivingBase)player, ListAttributes.COOL_BALL);
                    proj.func_70012_b(player.field_70165_t, player.field_70163_u + (double)player.func_70047_e(), player.field_70161_v, player.field_70177_z, player.field_70125_A);
                    player.field_70170_p.func_72838_d((Entity)proj);
                }
                if (climaTact.checkCharge(stack).length() == 3) {
                    String tempo = climaTact.checkCharge(stack);
                    if (tempo.equalsIgnoreCase("HHC")) {
                        WeatherProjectiles.EntityMirageTempoCloud smokeCloud = new WeatherProjectiles.EntityMirageTempoCloud(player.field_70170_p);
                        smokeCloud.setLife(70);
                        smokeCloud.func_70012_b(player.field_70165_t, player.field_70163_u + 1.0, player.field_70161_v, 0.0f, 0.0f);
                        smokeCloud.field_70159_w = 0.0;
                        smokeCloud.field_70179_y = 0.0;
                        smokeCloud.field_70181_x = 0.0;
                        smokeCloud.setThrower(player);
                        player.field_70170_p.func_72838_d((Entity)smokeCloud);
                        for (EntityLivingBase entity : WyHelper.getEntitiesNear((Entity)player, 10.0)) {
                            entity.func_70690_d(new PotionEffect(Potion.field_76440_q.field_76415_H, 200, 1));
                        }
                        climaTact.emptyCharge(stack);
                        super.use(player);
                        DevilFruitsHelper.sendShounenScream(player, "Fog Tempo", 0);
                        return;
                    }
                    WyHelper.sendMsgToPlayer(player, "Failed Tempo");
                    WyNetworkHelper.sendToAllAround(new PacketParticles("commonExplosion", player.field_70165_t, player.field_70163_u - 1.0, player.field_70161_v), player.field_71093_bK, player.field_70165_t, player.field_70163_u, player.field_70161_v, 128.0);
                    climaTact.emptyCharge(stack);
                    super.use(player);
                    return;
                }
                super.use(player);
            }
        }
    }

    public static class ThunderBall
    extends Ability {
        public ThunderBall() {
            super(ListAttributes.THUNDER_BALL);
        }

        @Override
        public void use(EntityPlayer player) {
            if (!this.isOnCooldown()) {
                ItemStack stack = player.func_70694_bm();
                if (stack == null || !(stack.func_77973_b() instanceof ClimaTact)) {
                    WyHelper.sendMsgToPlayer(player, "Cannot use " + this.getAttribute().getAttributeName() + " without a Clima Tact in hand!");
                    return;
                }
                ClimaTact climaTact = (ClimaTact)stack.func_77973_b();
                if (player.func_70093_af()) {
                    climaTact.chargeWeatherBall(stack, "T");
                } else {
                    WeatherProjectiles.ThunderBall proj = new WeatherProjectiles.ThunderBall(player.field_70170_p, (EntityLivingBase)player, ListAttributes.THUNDER_BALL);
                    proj.func_70012_b(player.field_70165_t, player.field_70163_u + (double)player.func_70047_e(), player.field_70161_v, player.field_70177_z, player.field_70125_A);
                    player.field_70170_p.func_72838_d((Entity)proj);
                }
                if (climaTact.checkCharge(stack).length() == 3) {
                    String tempo = climaTact.checkCharge(stack);
                    if (tempo.equalsIgnoreCase("TTT")) {
                        WeatherProjectiles.EntityWeatherCloud target;
                        List targets = WyHelper.getEntitiesNear((Entity)player, new double[]{15.0, 80.0, 15.0}, WeatherProjectiles.EntityWeatherCloud.class);
                        if (targets.size() > 0 && (target = (WeatherProjectiles.EntityWeatherCloud)((Object)targets.get(0))) != null && target.isSuperCharged()) {
                            climaTact.setDamage(20.0);
                        }
                        climaTact.emptyCharge(stack);
                        super.use(player);
                        DevilFruitsHelper.sendShounenScream(player, "Thunder Lance Tempo", 0);
                        return;
                    }
                    WyHelper.sendMsgToPlayer(player, "Failed Tempo");
                    WyNetworkHelper.sendToAllAround(new PacketParticles("commonExplosion", player.field_70165_t, player.field_70163_u - 1.0, player.field_70161_v), player.field_71093_bK, player.field_70165_t, player.field_70163_u, player.field_70161_v, 128.0);
                    climaTact.emptyCharge(stack);
                    super.use(player);
                    return;
                }
                super.use(player);
            }
        }
    }

    public static class GustSword
    extends Ability {
        public GustSword() {
            super(ListAttributes.GUST_SWORD);
        }

        @Override
        public void use(EntityPlayer player) {
            if (player.field_71071_by.func_70448_g() == null || player.field_71071_by.func_70448_g() != null && ItemsHelper.getClimaTactLevel(player.field_71071_by.func_70448_g().func_77973_b()) < 3) {
                WyHelper.sendMsgToPlayer(player, "Cannot use " + this.getAttribute().getAttributeName() + " without a Sorcery or better Clima Tact in hand!");
                return;
            }
            this.projectile = new WeatherProjectiles.GustSword(player.field_70170_p, (EntityLivingBase)player, this.attr);
            super.use(player);
        }
    }

    public static class WeatherEgg
    extends Ability {
        public WeatherEgg() {
            super(ListAttributes.WEATHER_EGG);
        }

        @Override
        public void use(EntityPlayer player) {
            if (player.field_71071_by.func_70448_g() == null || player.field_71071_by.func_70448_g() != null && ItemsHelper.getClimaTactLevel(player.field_71071_by.func_70448_g().func_77973_b()) < 3) {
                WyHelper.sendMsgToPlayer(player, "Cannot use " + this.getAttribute().getAttributeName() + " without a Sorcery or better Clima Tact in hand!");
                return;
            }
            this.projectile = new WeatherProjectiles.WeatherEgg(player.field_70170_p, (EntityLivingBase)player, this.attr);
            super.use(player);
        }
    }
}

